# Contributing to Shower

You’re always welcome to contibute! There are seven repositories in Shower project:

- [Core](https://github.com/shower/core) of Shower
- [Shower](https://github.com/shower/template) template
- [Ribbon](https://github.com/shower/ribbon) theme for Shower
- [Bright](https://github.com/shower/bright) theme for Shower
- [Jekyller](https://github.com/shower/jekyller) generator for Shower
- [Sho.io](https://github.com/shower/sho.io) online service
- [Shwr.me](https://github.com/shower/sho.io) service project

The most important part of the project is the [Core](https://github.com/shower/core) repository, containing [shower.js](https://github.com/shower/core/blob/master/shower.js) file.

## Issues

Before contributing to Shower, please read through [Issues](https://github.com/shower/shower/issues) to see open bugs and feature requests. If you have any feature to add to Shower or found a bug and want to fix it, please make sure you file an issue first.

## Process

To contribute to Shower fork needed repository and start making changes. Don’t forget to add upstream link to original repository and keep your fork updated. Once you finished, send pull request back to original repository and supply clear description or link to existing issue.

## Code style

Please keep existing code style while contributing to Shower and be ready for code review by Shower maintainers. It’s strongly recommended to install [EditorConfig](http://editorconfig.org) extension to your editor and validate your JavaScript changes using [JSHint](http://jshint.com/).

By historical reasons, Shower project is using tabs instead of spaces for code indentation. It’s not a big deal to keep this rule while contributing using you code editor options, even if your code style is 13.4 spaces.

## Language

English is the main language for Shower project. All discussions and commit messages should be in English, no matter if it’s good or bad. The second language of Shower is Russian. Offical Shower themes are always compatible with Cyrillic and Russian typography. All documentation to Shower is always localized to Russian.

---
If you have any questions, please ask [@shower_me](http://twitter.com/shower_me/) or file an [issue](https://github.com/shower/shower/issues/new).