# Возможности

Все возможности темы продемонстрированы в файле [index.html](../index.html), используйте его как руководство для создания презентации. Ниже представлено более подробное описание.

- [Анатомия](#Анатомия)
- [Общие](#Общие)
	- [Язык](#Язык)
	- [Холст](#Холст)
	- [Заглавие](#Заглавие)
	- [Бейдж](#Бейдж)
	- [Прогресс](#Прогресс)
- [Слайд](#Слайд)
	- [Номер](#Номер)
	- [Типы](#Типы)
		- [Белый](#Белый)
		- [Чёрный](#Чёрный)
		- [Сетка](#Сетка)
	- [Содержимое](#Содержимое)
		- [Заголовок](#Заголовок)
		- [Абзацы](#Абзацы)
		- [Строчные](#Строчные)
		- [Цитаты](#Цитаты)
		- [Списки](#Списки)
		- [Колонки](#Колонки)
		- [Таблицы](#Таблицы)
		- [Код](#Код)
	- [Элементы](#Элементы)
		- [Обложка](#Обложка)
		- [Шаут](#Шаут)
		- [Вставка](#Вставка)
		- [Заметки](#Заметки)

## Анатомия

Готовый пакет темы состоит из следующих папок и файлов:

1. Папка `docs` с документацией по использованию, включая это руководство.
2. Папка `fonts` со шрифтами в сжатом формате WOFF.
3. Папка `images` с картинками для оформления.
4. Папка `pictures` с примерами картинок.
5. Папка `styles` с собранными стилями в размерах 16×10 и 4×3.
6. Файл `index.html` с демонстрацией всех возможностей.

Дополнительно к этим файлам, в репозитории содержатся исходные файлы:

1. Папка `source` с исходными файлами шрифта в TTF и макетом для [Sketch](http://bohemiancoding.com/sketch/).
2. Папка `styles` также содержит исходные стили в формате SCSS.

## Общие

### Язык

Основной язык презентации указан в корневом элементе документа, обратите на него внимание и выставите верный:

	<html lang="ru">
	<html lang="en">

На основе этого тема использует подходящие типографские традиции. Атрибут `lang` можно также задавать отдельным слайдам или даже элементам.

### Холст

Корневой элемент презентации имеет основной класс `shower` и дополнительный класс режима: `list` для списка и `full` для показа слайдов. Режим `list` обычно указан по умолчанию, но если его нет, то он всё равно примет значение `list` и презентация откроется в режиме списка. Если вместо `list` задать `full`, то презентация откроется в режиме показа.

Список:

	<body class="shower list">
		…
	</body>

Показ:

	<body class="shower full">
		…
	</body>

Архитектура темы опирается на договорённости, что все части презентации вложены в корневой элемент `shower`, а классы режимов скрывают или показывают нужные элементы, в зависимости от текущего режима.

### Заглавие

Заглавие презентации обозначено элементом `caption`, в котором предусмотрены следующие элементы: `<h1>` для заголовка, `<p>` для описания, а также ссылки.

	<header class="caption">
		<h1>Presentation Title</h1>
		<p><a href="">Yours Truly</a>, Famous Inc.</p>
	</header>

### Бейдж

Бейдж со ссылкой «Форкни меня на Гитхабе» (или любым другим призывом) обозначен элементом `badge` и расположен в правом верхнем углу:

	<footer class="badge">
		<a href="…">Fork me on Github</a>
	</footer>

### Прогресс

Индикатор прогресса показывает сколько слайдов осталось до конца презентации, обозначается элементом `progress` и виден только в режиме показа:

	<div class="progress"></div>

Если вы хотите убрать его из презентации, просто удалите этот элемент из документа. Отключить его для отдельных слайдов не получится.

## Слайд

Слайды обозначаются классом `slide`. Не вкладывайте слайды друг в друга и не теряйте закрывающие теги, это может плохо закончиться.

	<section class="slide">
		…
	</section>
	<section class="slide">
		…
	</section>

Тема поддерживает два соотношения сторон слайдов: 16×10 и 4×3. Для переключения в нужный, подключите подходящий файл стилей: `screen-4x3.css` или `screen-16x10.css`. По умолчанию подключается широкоформатный 16×10.

Ширина слайдов в обоих форматах 1024 пикселя, высота 640 пикселей для 16×10 и 768 пикселей для 4×3. Рассчитывайте на эти размеры, когда готовите картинки для презентации. В режиме списка слайды уменьшаются в 2 или 4 раза, а в режиме показа масштабируются динамически, в зависимости от размеров окна.

### Номер

Нумерация на слайдах помогает слушателям запоминать слайды для вопросов, а также открывать нужный слайд, меняя его номер в адресной строке. Нумерация генерируется автоматически с помощью CSS-счётчиков и может быть отключена для отдельных слайдов.

Красная ленточка с номером слайда по умолчанию видна на всех слайдах, кроме белого и чёрного типов. Что скрыть номер слайда, добавьте к классу `slide` ещё один: `white` или `black`. Подробнее о типах читайте в следующей части.

### Типы

Типы слайда меняют его внешний вид. Тип задаётся дополнительным классом к основному `slide`. В теме есть несколько встроенных типов, вы можете описать собственные типы для каждой презентации или добавить их в свою тему.

#### Белый

Белый тип задаёт белый фон и отключает ленточку с номером слайда. Используйте его, когда вам нужен абсолютно белый слайд:

	<section class="slide white">
		…
	</section>

#### Чёрный

Чёрный тип задаёт чёрный фон и отключает ленточку с номером слайда. Используйте его, когда вам нужен абсолютно чёрный слайд:

	<section class="slide black">
		…
	</section>

Обратите внимание, что чёрный тип слайда не меняет цвет текста.

#### Сетка

Сетка задаёт слайду фон с двумя сетками: базовую розовую и дополнительную голубую с полями, строками и колонками.

	<section class="slide grid">
		…
	</section>

Базовая единица сетки — 25 пикселей. Высота строки основного текста 2 единицы, расстояние между блоками содержимого 3, боковые поля 4, ширина содержимого 33, ширина одной колонки 15.

Все элементы презентации выровнены по этой сетке и рекомендуется следовать ей при изменении или расширении темы.

### Содержимое

Простое содержимое: заголовки, абзацы, списки.

#### Заголовок

Заголовок слайда обозначается элементом `<h2>`:

	<section class="slide">
		<h2>Slide Header</h2>
	</section>

Мы осознанно не стали вводить следующие уровни заголовков, чтобы не провоцировать иерархические сложности на слайде.

#### Абзацы

Абзацы текста обозначаются элементом `<p>`, которому также можно задать класс `note`, чтобы превратить текст в заметку.

	<section class="slide">
		<p>Текст</p>
		<p class="note">Заметка</p>
	</section>

#### Строчные

В теме предусмотрено оформление для следующих строчных элементов:

- `<a>` голубого цвета с подчёркиванием;
- `<strong>` и `<b>` полужирного начертания;
- `<em>` и `<i>` курсивного начертания;
- `<code>`, `<samp>` и `<kbd>` моноширинным шрифтом;
- `<sup>` и `<sub>` для надстрочных и подстрочных индексов;
- `<mark>` для выделения частей текста жёлтым.

#### Цитаты

Цитаты обозначаются элементом `<blockquote>` в который помещается один или несколько абзацев:

	<blockquote>
		<p>Flannel bicycle rights locavore selfies.</p>
	</blockquote>

Цитата оформляется курсивом и свешенной кавычкой. Если вам нужно добавить автора цитаты, мы рекомендуем обернуть цитату в элемент `<figure>` и поместить подпись в `<figcaption>`, который, следуя сразу за цитатой, станет полужирным.

	<figure>
		<blockquote>
			<p>Post-ironic fashion axe flexitarian</p>
		</blockquote>
		<figcaption>Yours Truly</figcaption>
	</figure>

#### Списки

Списки обозначаются элементами `<ol>` для нумерованных и `<ul>` для ненумерованных. Списки можно произвольно вкладывать:

	<ol>
		<li>Literally viral vegan</li>
		<li>Wes Anderson chillwave Marfa
			<ul>
				<li>Retro meh brunch aesthetic</li>
				<li>Messenger bag retro cred</li>
			</ul>
		</li>
	</ol>

Маркерами нумерованных списков становятся цифры, маркеры ненумерованных различаются в зависимости от указанного языка презентации: буллиты `•` для английского и тире `—` для русского языка.

#### Колонки

Содержимое на слайде можно разделить на две колонки с помощью класса `double`:

	<p class="double">
		Echo Park 8-bit sustainable umami deep v Kickstarter.
	</p>

Полезнее всего это будет для списков — на слайд тогда поместится не 7, а 14 коротких пунктов:

	<ul class="double">
		<li>Occupy locavore blog</li>
		<li>Mustache you haven’t heard of</li>
	</ul>

#### Таблицы

Таблицы обозначаются элементами `<table>`, `<th>` выделяет заголовки колонок или строк полужирным, а строки по умолчанию разделяются линейками:

	<table>
	<tr>
		<th scope="col">Gentrify</th>
		<th>Twee</th>
	</tr>
	<tr>
		<th scope="row">Messenger</th>
		<td>Mixtape</td>
	</tr>
	</table>

Чтобы вместо линеек сделать полосатую таблицу, где каждая чётная строчка выделена серым фоном, добавьте таблице класс `striped`:

	<table class="striped">

#### Код

Блоки кода обозначаются элементом `<pre>` со вложенным `<code>`, внутри которых сохраняется форматирование текста:

	<pre><code>function action() {
		// TODO
		return true;
	}</code></pre>

Чтобы пронумеровать строки, оберните каждую в `<code>` и номер автоматически появится слева:

	<pre>
		<code>function action() {</code>
		<code>	// TODO</code>
		<code>	return true;</code>
		<code>}<code>
	</pre>

Шовер не подсвечивает код автоматически, но мы рекомендуем вам выделять значимые части кода вручную с помощью элемента `<mark>`. В этом случае будет не просто красиво, но понятно на что обратить внимание.

	<pre><code>function <mark>action()</mark> {
		<span class="comment">// TODO<span>
		return <mark class="important">true</mark>;
	}</code></pre>

По умолчанию `<mark>` выделяет фрагмент кода жёлтым, а если добавить класс `important`, то красным. Для оформления комментариев используйте `<span class="comment">`.

### Элементы

Элементы для вставки специального содержимого.

#### Обложка

Чтобы вставить на слайд картинку-обложку, которая займёт весь слайд и не будет мешать содержимому, используйте `<img>` с классом `cover`:

	<section class="slide">
		<img class="cover" src="picture.png">
	</section>

Картинка позиционируется на слайде и становится позади любого содержимого. Это удобно, если вы хотите сделать подложку для текста или скомбинировать обложку и заголовок.

Вставленная картинка вписывается в размеры слайда по ширине и высоте. Это не заметно, когда картинка и слайд имеют одинаковые пропорции. Если же картинка выше или шире слайда, то она встанет по центру и упрётся самой длинной стороной в края слайда.

Этим поведением можно управлять с помощью дополнительных классов `width` и `height`, которые определяют как впишется непропорциональная картинка: по ширине или по высоте.

	<img class="cover width" src="picture.png">
	<img class="cover height" src="picture.png">

Также можно использовать сокращённые классы `w` и `h`:

	<img class="cover w" src="picture.png">
	<img class="cover h" src="picture.png">

Чтобы добавить подпись с автором картинки, ссылкой или другой информацией, оберните обложку в `<figure>` и вставьте подпись в `<figcaption>`. По умолчанию цвет подписи чёрный, но её можно сделать белой, добавив к `<figcaption>` класс `white`.

	<figure>
		<img class="cover" src="picture.png">
		<figcaption class="white">
			© Yours Truly
		</figcaption>
	</figure>

### Шаут

Чтобы обозначить раздел презентации, добавьте к заголовку `<h2>` класс `shout`, тогда он станет больше и встанет посередине:

	<section class="slide">
		<h2 class="shout">Shout</h2>
	</section>

Чтобы заголовок плавно вырастал, добавьте к нему класс `grow`:

	<section class="slide">
		<h2 class="shout grow">Growing Shout</h2>
	</section>

Или класс `shrink`, чтобы он плавно уменьшался:

	<section class="slide">
		<h2 class="shout shrink">Shrinking Shout</h2>
	</section>

### Вставка

Чтобы вставить на слайд элемент в заданном месте, используйте класс `place`, по умолчанию элемент расположится ровно посередине:

	<section class="slide">
		<img class="place" src="picture.png">
	</section>

Указав дополнительный класс, можно прикрепить элемент посередине к одной из сторон, также можно использовать сокращения `t`, `r`, `b`, `l`:

	<img class="place top" src="picture.png">
	<img class="place right" src="picture.png">
	<img class="place bottom" src="picture.png">
	<img class="place left" src="picture.png">

Если скомбинировать классы сторон, то элемент встанет в соответствующий угол, например, `top right` для верхнего правого:

	<img class="place top left" src="picture.png">
	<img class="place top right" src="picture.png">
	<img class="place bottom left" src="picture.png">
	<img class="place bottom right" src="picture.png">

### Заметка

Чтобы вставить на слайд заметку, которую не видно во время презентации, но видно при наведении на слайд в режиме списка, используйте элемент с классом `footer`:

	<section class="slide">
		<p>Retro meh brunch aesthetic.</p>
		<footer class="footer">
			<p>Cosby sweater Shoreditch.</p>
		</footer>
	</section>

В заметках удобно хранить тезисы для отдельных слайдов.
