# Работа с GitHub и реализацией функциональности в IT-проекте

##### Цель работы — добавить новую функцию отображения прогресса пользователя в веб-ориентированном модуле образовательной среды, используя стратегию ветвления и стандартный процесс разработки.

### Постановка задачи

Необходимо реализовать функциональность **прогресс-бара для курса**, предварительно создав issue в GitHub и спланировав время выполнения. Функция позволит студентам видеть процент пройденных уроков.

### Создание Issue

В репозитории создано issue с описанием задачи, критериями готовности и метками.  
Пример содержания: «Добавить отображение прогресса пользователя в курсе», с описанием требований и ожидаемого результата (обновление прогресса при завершении урока, отображение в виде прогресс-бара).

### Стратегия ветвления

Используется подход **Feature Branch Workflow**:

- основная ветка `main` остаётся стабильной;  
- создаётся ветка `feature/add-progress-tracking` для разработки функционала;  
- все изменения выполняются изолированно и затем отправлены в Pull Request (PR).

### Реализация функции

В новой ветке:

- разрабатывается компонент прогресс-бара на странице курса;  
- добавляется логика обновления прогресса при прохождении урока;  
- выполняется локальное тестирование;  
- оформляются коммиты с понятными описаниями и документация.

### Планирование времени

Основные затраты:

- анализ и изучение кода – 1–2 ч;  
- разработка функции – 4–5 ч;  
- тестирование и исправление ошибок – 1–2 ч;  
- оформление PR и документации – 0.5–1 ч.  

**Общее время:** 6.5–10 ч.

### Pull Request

Создаётся PR с описанием выполненной работы и ссылкой на issue. После проверки и тестирования изменения сливаются в основную ветку `main`.

### Результат

- Изучена практика управления проектами на GitHub;  
- Создано issue с описанием новой функции и оценкой временных затрат;  
- Реализована функция отображения прогресса в курсе;  
- Подготовлены коммиты, Pull Request и документация;  