import React from 'react';
import { useNavigate } from 'react-router-dom';
import {
  Box,
  Button,
  Card,
  CardActionArea,
  CardContent,
  Container,
  Grid,
  Typography,
  Paper,
} from '@mui/material';
import SpeedIcon from '@mui/icons-material/Speed';
import MemoryIcon from '@mui/icons-material/Memory';
import StorageIcon from '@mui/icons-material/Storage';
import TimelineIcon from '@mui/icons-material/Timeline';

const performanceData = [
  { title: 'Время ответа', icon: <TimelineIcon fontSize="large" color="primary" />, value: '124 мс', change: '-23%' },
  { title: 'Использование CPU', icon: <SpeedIcon fontSize="large" color="primary" />, value: '32%', change: '-12%' },
  { title: 'Использование RAM', icon: <MemoryIcon fontSize="large" color="primary" />, value: '256 MB', change: '-18%' },
  { title: 'Хранилище', icon: <StorageIcon fontSize="large" color="primary" />, value: '45 MB', change: '-8%' },
];

function HomePage() {
  const navigate = useNavigate();

  return (
    <Container maxWidth="lg">
      <Box sx={{ my: 4 }}>
        <Typography variant="h4" component="h1" gutterBottom>
          Тестирование и оптимизация Serverless-функций
        </Typography>
        <Typography variant="body1" paragraph>
          Добро пожаловать в платформу для автоматизированного запуска и замера производительности
          serverless-функций на облачной инфраструктуре импортозамещения.
        </Typography>
        <Paper sx={{ p: 3, mb: 4, bgcolor: 'primary.main', color: 'white' }}>
          <Typography variant="h5" gutterBottom>
            Текущий статус:
          </Typography>
          <Typography variant="body1">
            Проведено 153 тестов • Оптимизировано 27 функций • Среднее улучшение: 24%
          </Typography>
          <Button 
            variant="contained" 
            color="secondary" 
            sx={{ mt: 2 }}
            onClick={() => navigate('/testing')}
          >
            Запустить новый тест
          </Button>
        </Paper>

        <Typography variant="h5" gutterBottom>
          Сводка производительности
        </Typography>
        <Grid container spacing={3}>
          {performanceData.map((item) => (
            <Grid item xs={12} sm={6} md={3} key={item.title} sx={{ display: 'flex' }}>
              <Card className="dashboard-card" sx={{ width: '100%', height: '100%' }}>
                <CardActionArea sx={{ height: '100%' }} onClick={() => navigate('/results')}>
                  <CardContent sx={{ textAlign: 'center', display: 'flex', flexDirection: 'column', height: '100%' }}>
                    <Box sx={{ mb: 2 }}>{item.icon}</Box>
                    <Typography variant="h6" component="div">
                      {item.title}
                    </Typography>
                    <Typography variant="h4" color="text.primary" sx={{ mt: 1 }}>
                      {item.value}
                    </Typography>
                    <Box sx={{ flexGrow: 1 }} />
                    <Typography
                      variant="body2"
                      color={item.change.startsWith('-') ? 'success.main' : 'error.main'}
                      sx={{ mt: 2 }}
                    >
                      {item.change} после оптимизации
                    </Typography>
                  </CardContent>
                </CardActionArea>
              </Card>
            </Grid>
          ))}
        </Grid>

        <Grid container spacing={4} sx={{ mt: 2 }}>
          <Grid item xs={12} md={6} sx={{ display: 'flex' }}>
            <Card sx={{ width: '100%', height: '100%' }}>
              <CardContent sx={{ display: 'flex', flexDirection: 'column', height: '100%' }}>
                <Typography variant="h6" gutterBottom>
                  Последние тесты
                </Typography>
                <Typography variant="body2">
                  • Тест обработки изображений (завершен 12.05.2024)
                </Typography>
                <Typography variant="body2">
                  • Тест API Gateway с аутентификацией (завершен 10.05.2024)
                </Typography>
                <Typography variant="body2">
                  • Тест базы данных PostgreSQL (завершен 08.05.2024)
                </Typography>
                <Box sx={{ flexGrow: 1 }} />
                <Button
                  variant="outlined"
                  size="small"
                  sx={{ mt: 2 }}
                  onClick={() => navigate('/results')}
                >
                  Все результаты
                </Button>
              </CardContent>
            </Card>
          </Grid>
          <Grid item xs={12} md={6} sx={{ display: 'flex' }}>
            <Card sx={{ width: '100%', height: '100%' }}>
              <CardContent sx={{ display: 'flex', flexDirection: 'column', height: '100%' }}>
                <Typography variant="h6" gutterBottom>
                  Рекомендации
                </Typography>
                <Typography variant="body2">
                  • Оптимизировать использование памяти в функции обработки изображений
                </Typography>
                <Typography variant="body2">
                  • Кэшировать результаты HTTP-запросов для улучшения времени отклика
                </Typography>
                <Typography variant="body2">
                  • Уменьшить размер пакета зависимостей для функции аналитики
                </Typography>
                <Box sx={{ flexGrow: 1 }} />
                <Button
                  variant="outlined"
                  size="small"
                  sx={{ mt: 2 }}
                  onClick={() => navigate('/configuration')}
                >
                  Настроить оптимизации
                </Button>
              </CardContent>
            </Card>
          </Grid>
        </Grid>
      </Box>
    </Container>
  );
}

export default HomePage; 