import React from 'react';
import { Routes, Route } from 'react-router-dom';
import { ThemeProvider, createTheme } from '@mui/material/styles';
import CssBaseline from '@mui/material/CssBaseline';

import Layout from './components/Layout';
import FunctionsPage from './pages/FunctionsPage';
import OptimizationPage from './pages/OptimizationPage';
import TestingPage from './pages/TestingPage';
import ResultsPage from './pages/ResultsPage';

const theme = createTheme({
  palette: {
    primary: {
      main: '#1976d2',
    },
    secondary: {
      main: '#dc004e',
    },
    background: {
      default: '#f5f5f5',
    },
  },
  typography: {
    fontFamily: 'Roboto, Arial, sans-serif',
  },
});

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Layout>
        <Routes>
          <Route path="/" element={<FunctionsPage />} />
          <Route path="/optimization" element={<OptimizationPage />} />
          <Route path="/optimization/:functionId" element={<OptimizationPage />} />
          <Route path="/optimization/:functionId/:version" element={<OptimizationPage />} />
          <Route path="/testing" element={<TestingPage />} />
          <Route path="/testing/:functionId/:version" element={<TestingPage />} />
          <Route path="/results" element={<ResultsPage />} />
        </Routes>
      </Layout>
    </ThemeProvider>
  );
}

export default App; 