# Языки написания спецификаций. Задание 2
Автор: **Величко Арсений, ИВТ 4**

[**Ссылка на скринкаст**](https://youtu.be/VVwZlHOib6g)

Тема моей ВКР - "Оптимизация выполнения serverless-функций на облачных инфраструктурах на основе импортозамещения". Разрабатываемый программный продукт представляет собой программный комплекс для автоматизированного запуска и замера производительности serverless-функций на облачной инфраструктуре импортозамещения, включающий набор тестовых сценариев, модуль сбора метрик и инструмент сравнения показателей до и после оптимизации. В качестве пользовательского интерфейса реализуется веб-портал с визуализацией результатов испытаний и формулировкой рекомендаций по эффективному развертыванию и конфигурации функций.

# Диаграммы
Для генерации диаграмм использовался ИИ ChatGPT o4-mini-high от OpenAI. Промпт:

> Ты - студент четвертого курса специальности "Информатика и вычислительная техника". Ты пишешь ВКР по теме "Оптимизация выполнения serverless-функций на облачных инфраструктурах на основе импортозамещения". Разрабатываемый программный продукт представляет собой программный комплекс для автоматизированного запуска и замера производительности serverless-функций на облачной инфраструктуре импортозамещения, включающий набор тестовых сценариев, модуль сбора метрик и инструмент сравнения показателей до и после оптимизации. В качестве пользовательского интерфейса реализуется веб-портал с визуализацией результатов испытаний и формулировкой рекомендаций по эффективному развертыванию и конфигурации функций.
> 
> Используя PlantUML, создай набор диаграмм, раскрывающих функционал разрабатываемого продукта в рамках ВКР. Диаграммы должны раскрывать динамическую и статическую сущность разрабатываемого продукта.
> 
> Необходимо реализовать следующие диаграммы: 
> - вариантов использования (use case);
> - классов (classes);
> - последовательности (sequence);
> - диаграмма состояний (state);
> - диаграмма деятельности (activity).
> 
> Для названия элементов используй русский язык

## Диаграмма вариантов использования (Use Case)
Показывает, кто (акторы) взаимодействует с системой и какие функции (варианты использования) она поддерживает. Помогает зафиксировать требования на высоком уровне: какие сценарии выполнения задач имеются у пользователей и как они входят/выходят за границы системы.

### Результат

![Use Case Diagram](diagrams/UseCase.png)

## Диаграмма классов (Class Diagram)
Отображает статическую структуру системы: её классы (или сущности), их атрибуты и методы, а также связи между ними (наследование, ассоциации, зависимости и т. д.). Помогает понять, из каких компонентов строится приложение и как они взаимодействуют на уровне типов.

### Результат

![Class Diagram](diagrams/ClassDiagram.png)

## Диаграмма последовательности (Sequence Diagram)
Показывает динамику взаимодействия между объектами или компонентами в ходе выполнения конкретного сценария. По горизонтали — участники, по вертикали — временная шкала: кто и в каком порядке вызывает какие методы, и какие ответы получает.

### Результат

![Sequence Diagram - Optimization](diagrams/Sequence_Optimization.png)
![Sequence Diagram - Testing](diagrams/Sequence_Testing.png)
![Sequence Diagram - Results](diagrams/Sequence_Results.png)

## Диаграмма состояний (State Diagram)
Описывает жизненный цикл единственного объекта или сущности: набор возможных состояний, в которых он может находиться, и переходы между ними (события и условия перехода). Полезна для моделирования поведения компонентов с явно выраженными стадиями.

### Результат

![State Diagram - Editor](diagrams/State_Editor.png)
![State Diagram - Testing](diagrams/State_Testing.png)
![State Diagram - Results](diagrams/State_Results.png)

## Диаграмма деятельности (Activity Diagram)
Моделирует процесс или рабочий поток: последовательность действий (активностей), ветвления, параллельных потоков и точек синхронизации. Помогает визуализировать бизнес-процессы или алгоритмы внутри системы.

### Результат

![Activity Diagram - Editor](diagrams/Activity_Editor.png)
![Activity Diagram - Testing](diagrams/Activity_Testing.png)
![Activity Diagram - Results](diagrams/Activity_Results.png)

# Код на Python

Для предложенной диаграммы классов был сгенерирован Python модуль. Для генерации кода использовался IDE Cursor и ИИ Claude 3.7 Sonnet от Anthropic. Промпт:

> Given this class diagram, generate a Python module containing all the classes and relationships. Translate all class, method and field names into English. Do not implement the methods, but define their signatures. Use modern Python 3.12 syntax. Follow PEP8 style. Do not write comments. Clean code

### Результат

```python
from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from enum import Enum


class Function:
    def __init__(self, id: str, name: str, language: str, platform: str) -> None:
        self.id: str = id
        self.name: str = name
        self.language: str = language
        self.platform: str = platform


class Version:
    def __init__(
        self, function: Function, version_number: str, origin: str, code: str, created_at: datetime
    ) -> None:
        self.function: Function = function
        self.version_number: str = version_number
        self.origin: str = origin
        self.code: str = code
        self.created_at: datetime = created_at


class OptimizationReport:
    def __init__(
        self,
        version: Version,
        report_id: str,
        recommendations: List[str],
        optimized_code: str,
        metrics_before: Dict[str, Any],
        metrics_after: Dict[str, Any],
        created_at: datetime,
    ) -> None:
        self.version: Version = version
        self.report_id: str = report_id
        self.recommendations: List[str] = recommendations
        self.optimized_code: str = optimized_code
        self.metrics_before: Dict[str, Any] = metrics_before
        self.metrics_after: Dict[str, Any] = metrics_after
        self.created_at: datetime = created_at


class TestConfiguration:
    def __init__(
        self, version: Version, runtime: str, iterations: int, parallelism: int, timeout: int
    ) -> None:
        self.version: Version = version
        self.runtime: str = runtime
        self.iterations: int = iterations
        self.parallelism: int = parallelism
        self.timeout: int = timeout


class TestRunStatus(Enum):
    PENDING = "pending"
    RUNNING = "running"
    COMPLETED = "completed"
    FAILED = "failed"


class TestRun:
    def __init__(
        self,
        test_configuration: TestConfiguration,
        run_id: str,
        started_at: datetime,
        ended_at: Optional[datetime] = None,
        status: TestRunStatus = TestRunStatus.PENDING,
    ) -> None:
        self.test_configuration: TestConfiguration = test_configuration
        self.run_id: str = run_id
        self.started_at: datetime = started_at
        self.ended_at: Optional[datetime] = ended_at
        self.status: TestRunStatus = status


class Metric:
    def __init__(
        self, test_run: TestRun, type: str, percentiles: Dict[str, float], timestamp: datetime
    ) -> None:
        self.test_run: TestRun = test_run
        self.type: str = type
        self.percentiles: Dict[str, float] = percentiles
        self.timestamp: datetime = timestamp


class TestProfile:
    def __init__(
        self,
        test_run: TestRun,
        profile_id: str,
        function_name: str,
        version_number: str,
        run_timestamp: datetime,
    ) -> None:
        self.test_run: TestRun = test_run
        self.profile_id: str = profile_id
        self.function_name: str = function_name
        self.version_number: str = version_number
        self.run_timestamp: datetime = run_timestamp


class Draft:
    def __init__(self, version: Version, content: str, last_updated: datetime) -> None:
        self.version: Version = version
        self.content: str = content
        self.last_updated: datetime = last_updated 
```

# Прототип интерфейса

Не так просто перенести резульат работы LLM в популярные платформы для прототипирований интерфейсов, такие как Figma. Однако, LLM отлично справляются с написанием frontend кода. Используя IDE Cursor и ИИ Claude 3.7 Sonnet от Anthropic, я сгенерировал прототип веб приложения. Для этого был использован следующий промпт:

> You are a senior frontend developer tasked with creating a wireframe for a new application your company is developing. Your Russian-speaking boss provided you with this product description:
> 
> Разрабатываемый программный продукт представляет собой программный комплекс для автоматизированного запуска и замера производительности serverless-функций на облачной инфраструктуре импортозамещения, включающий набор тестовых сценариев, модуль сбора метрик и инструмент сравнения показателей до и после оптимизации. В качестве пользовательского интерфейса реализуется веб-портал с визуализацией результатов испытаний и формулировкой рекомендаций по эффективному развертыванию и конфигурации функций.
> 
> Come up with a web interface for this application and prerpare a basic wireframe using a modern frontend development stack of your choice. Make sure to implement the home page, a page with in-depth testing and performance insights, and a page for configuring the testing. Use fake data for your graphs and charts and populate all the text fields with appropiate sample text. Use Russian as the main language for the interface and sample data. Place all your code inside the "wireframe" directory. Refer to the attached README.md file for some technical aspects of the supposed app. Then, prepare a Dockerfile for your application. Give this task all you have as your annual bonus is on the line.

Приложение находится в директории "wireframe". Приложение может быть запущено командой `docker-compose up --build`.

### Скриншоты

![Screenshot](assets/functions-page.png)

![Screenshot](assets/optimization-page.png)

![Screenshot](assets/test-page.png)

![Screenshot](assets/results-page.png)
