<?php
/**
 * States
 *
 * Returns a multi-dimensional array of countries and country states (or provinces / regions) and their respective codes.
 * 
 * Countries with an empty array have no states.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * The data contained within this file is derived from various open-source *
 * projects and libraries.                                                 *
 *                                                                         *
 * See the README.md file in this directory for credits and more.          *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * Note to contributors:                                                   *
 *                                                                         *
 * The data contained within this file is automatically generated. Do not  *
 * modify or submit pull requests on this file directly. If you've located *
 * an issue with any of the data contained within this file please open a  *
 * new issue at https://github.com/gocodebox/lifterlms/issues/new/choose.  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * @package LifterLMS/i18n
 *
 * @see llms_get_states()
 *
 * @since 5.0.0
 * @version 5.0.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AD' => array(
		'07' => __( 'Andorra la Vella', 'lifterlms' ),
		'02' => __( 'Canillo', 'lifterlms' ),
		'03' => __( 'Encamp', 'lifterlms' ),
		'08' => __( 'Escaldes-Engordany', 'lifterlms' ),
		'04' => __( 'La Massana', 'lifterlms' ),
		'05' => __( 'Ordino', 'lifterlms' ),
		'06' => __( 'Sant Julià de Lòria', 'lifterlms' ),
	),
	'AE' => array(
		'AZ' => __( 'Abu Dhabi Emirate', 'lifterlms' ),
		'AJ' => __( 'Ajman Emirate', 'lifterlms' ),
		'DU' => __( 'Dubai', 'lifterlms' ),
		'FU' => __( 'Fujairah', 'lifterlms' ),
		'RK' => __( 'Ras al-Khaimah', 'lifterlms' ),
		'SH' => __( 'Sharjah Emirate', 'lifterlms' ),
		'UQ' => __( 'Umm al-Quwain', 'lifterlms' ),
	),
	'AF' => array(
		'BDS' => __( 'Badakhshan', 'lifterlms' ),
		'BDG' => __( 'Badghis', 'lifterlms' ),
		'BGL' => __( 'Baghlan', 'lifterlms' ),
		'BAL' => __( 'Balkh', 'lifterlms' ),
		'BAM' => __( 'Bamyan', 'lifterlms' ),
		'DAY' => __( 'Daykundi', 'lifterlms' ),
		'FRA' => __( 'Farah', 'lifterlms' ),
		'FYB' => __( 'Faryab', 'lifterlms' ),
		'GHA' => __( 'Ghazni', 'lifterlms' ),
		'GHO' => __( 'Ghōr', 'lifterlms' ),
		'HEL' => __( 'Helmand', 'lifterlms' ),
		'HER' => __( 'Herat', 'lifterlms' ),
		'JOW' => __( 'Jowzjan', 'lifterlms' ),
		'KAB' => __( 'Kabul', 'lifterlms' ),
		'KAN' => __( 'Kandahar', 'lifterlms' ),
		'KAP' => __( 'Kapisa', 'lifterlms' ),
		'KHO' => __( 'Khost', 'lifterlms' ),
		'KNR' => __( 'Kunar', 'lifterlms' ),
		'KDZ' => __( 'Kunduz Province', 'lifterlms' ),
		'LAG' => __( 'Laghman', 'lifterlms' ),
		'LOG' => __( 'Logar', 'lifterlms' ),
		'NAN' => __( 'Nangarhar', 'lifterlms' ),
		'NIM' => __( 'Nimruz', 'lifterlms' ),
		'NUR' => __( 'Nuristan', 'lifterlms' ),
		'PIA' => __( 'Paktia', 'lifterlms' ),
		'PKA' => __( 'Paktika', 'lifterlms' ),
		'PAN' => __( 'Panjshir', 'lifterlms' ),
		'PAR' => __( 'Parwan', 'lifterlms' ),
		'SAM' => __( 'Samangan', 'lifterlms' ),
		'SAR' => __( 'Sar-e Pol', 'lifterlms' ),
		'TAK' => __( 'Takhar', 'lifterlms' ),
		'URU' => __( 'Urozgan', 'lifterlms' ),
		'ZAB' => __( 'Zabul', 'lifterlms' ),
	),
	'AG' => array(
		'10' => __( 'Barbuda', 'lifterlms' ),
		'11' => __( 'Redonda', 'lifterlms' ),
		'03' => __( 'Saint George Parish', 'lifterlms' ),
		'04' => __( 'Saint John Parish', 'lifterlms' ),
		'05' => __( 'Saint Mary Parish', 'lifterlms' ),
		'06' => __( 'Saint Paul Parish', 'lifterlms' ),
		'07' => __( 'Saint Peter Parish', 'lifterlms' ),
		'08' => __( 'Saint Philip Parish', 'lifterlms' ),
	),
	'AI' => array(),
	'AL' => array(
		'10' => __( 'Shkodër County', 'lifterlms' ),
		'11' => __( 'Tirana County', 'lifterlms' ),
		'12' => __( 'Vlorë County', 'lifterlms' ),
		'01' => __( 'Berat County', 'lifterlms' ),
		'BR' => __( 'Berat District', 'lifterlms' ),
		'BU' => __( 'Bulqizë District', 'lifterlms' ),
		'DL' => __( 'Delvinë District', 'lifterlms' ),
		'DV' => __( 'Devoll District', 'lifterlms' ),
		'09' => __( 'Dibër County', 'lifterlms' ),
		'DI' => __( 'Dibër District', 'lifterlms' ),
		'02' => __( 'Durrës County', 'lifterlms' ),
		'DR' => __( 'Durrës District', 'lifterlms' ),
		'03' => __( 'Elbasan County', 'lifterlms' ),
		'04' => __( 'Fier County', 'lifterlms' ),
		'FR' => __( 'Fier District', 'lifterlms' ),
		'05' => __( 'Gjirokastër County', 'lifterlms' ),
		'GJ' => __( 'Gjirokastër District', 'lifterlms' ),
		'GR' => __( 'Gramsh District', 'lifterlms' ),
		'HA' => __( 'Has District', 'lifterlms' ),
		'KA' => __( 'Kavajë District', 'lifterlms' ),
		'ER' => __( 'Kolonjë District', 'lifterlms' ),
		'06' => __( 'Korçë County', 'lifterlms' ),
		'KO' => __( 'Korçë District', 'lifterlms' ),
		'KR' => __( 'Krujë District', 'lifterlms' ),
		'07' => __( 'Kukës County', 'lifterlms' ),
		'KU' => __( 'Kukës District', 'lifterlms' ),
		'KB' => __( 'Kurbin District', 'lifterlms' ),
		'KC' => __( 'Kuçovë District', 'lifterlms' ),
		'08' => __( 'Lezhë County', 'lifterlms' ),
		'LE' => __( 'Lezhë District', 'lifterlms' ),
		'LB' => __( 'Librazhd District', 'lifterlms' ),
		'LU' => __( 'Lushnjë District', 'lifterlms' ),
		'MK' => __( 'Mallakastër District', 'lifterlms' ),
		'MM' => __( 'Malësi e Madhe District', 'lifterlms' ),
		'MT' => __( 'Mat District', 'lifterlms' ),
		'MR' => __( 'Mirditë District', 'lifterlms' ),
		'PQ' => __( 'Peqin District', 'lifterlms' ),
		'PG' => __( 'Pogradec District', 'lifterlms' ),
		'PU' => __( 'Pukë District', 'lifterlms' ),
		'PR' => __( 'Përmet District', 'lifterlms' ),
		'SR' => __( 'Sarandë District', 'lifterlms' ),
		'SH' => __( 'Shkodër District', 'lifterlms' ),
		'SK' => __( 'Skrapar District', 'lifterlms' ),
		'TE' => __( 'Tepelenë District', 'lifterlms' ),
		'TR' => __( 'Tirana District', 'lifterlms' ),
		'TP' => __( 'Tropojë District', 'lifterlms' ),
		'VL' => __( 'Vlorë District', 'lifterlms' ),
	),
	'AM' => array(
		'AG' => __( 'Aragatsotn Region', 'lifterlms' ),
		'AR' => __( 'Ararat Province', 'lifterlms' ),
		'AV' => __( 'Armavir Region', 'lifterlms' ),
		'GR' => __( 'Gegharkunik Province', 'lifterlms' ),
		'KT' => __( 'Kotayk Region', 'lifterlms' ),
		'LO' => __( 'Lori Region', 'lifterlms' ),
		'SH' => __( 'Shirak Region', 'lifterlms' ),
		'SU' => __( 'Syunik Province', 'lifterlms' ),
		'TV' => __( 'Tavush Region', 'lifterlms' ),
		'VD' => __( 'Vayots Dzor Region', 'lifterlms' ),
		'ER' => __( 'Yerevan', 'lifterlms' ),
	),
	'AO' => array(
		'BGO' => __( 'Bengo Province', 'lifterlms' ),
		'BGU' => __( 'Benguela Province', 'lifterlms' ),
		'BIE' => __( 'Bié Province', 'lifterlms' ),
		'CAB' => __( 'Cabinda Province', 'lifterlms' ),
		'CCU' => __( 'Cuando Cubango Province', 'lifterlms' ),
		'CNO' => __( 'Cuanza Norte Province', 'lifterlms' ),
		'CUS' => __( 'Cuanza Sul', 'lifterlms' ),
		'CNN' => __( 'Cunene Province', 'lifterlms' ),
		'HUA' => __( 'Huambo Province', 'lifterlms' ),
		'HUI' => __( 'Huíla Province', 'lifterlms' ),
		'LUA' => __( 'Luanda Province', 'lifterlms' ),
		'LNO' => __( 'Lunda Norte Province', 'lifterlms' ),
		'LSU' => __( 'Lunda Sul Province', 'lifterlms' ),
		'MAL' => __( 'Malanje Province', 'lifterlms' ),
		'MOX' => __( 'Moxico Province', 'lifterlms' ),
		'UIG' => __( 'Uíge Province', 'lifterlms' ),
		'ZAI' => __( 'Zaire Province', 'lifterlms' ),
	),
	'AQ' => array(),
	'AR' => array(
		'C' => __( 'Autonomous City Of Buenos Aires', 'lifterlms' ),
		'B' => __( 'Buenos Aires Province', 'lifterlms' ),
		'K' => __( 'Catamarca Province', 'lifterlms' ),
		'H' => __( 'Chaco Province', 'lifterlms' ),
		'U' => __( 'Chubut Province', 'lifterlms' ),
		'W' => __( 'Corrientes', 'lifterlms' ),
		'X' => __( 'Córdoba Province', 'lifterlms' ),
		'E' => __( 'Entre Ríos Province', 'lifterlms' ),
		'P' => __( 'Formosa Province', 'lifterlms' ),
		'Y' => __( 'Jujuy Province', 'lifterlms' ),
		'L' => __( 'La Pampa', 'lifterlms' ),
		'F' => __( 'La Rioja Province', 'lifterlms' ),
		'M' => __( 'Mendoza', 'lifterlms' ),
		'N' => __( 'Misiones Province', 'lifterlms' ),
		'Q' => __( 'Neuquén Province', 'lifterlms' ),
		'R' => __( 'Río Negro Province', 'lifterlms' ),
		'A' => __( 'Salta Province', 'lifterlms' ),
		'J' => __( 'San Juan Province', 'lifterlms' ),
		'D' => __( 'San Luis Province', 'lifterlms' ),
		'Z' => __( 'Santa Cruz Province', 'lifterlms' ),
		'S' => __( 'Santa Fe Province', 'lifterlms' ),
		'G' => __( 'Santiago del Estero Province', 'lifterlms' ),
		'V' => __( 'Tierra del Fuego Province', 'lifterlms' ),
		'T' => __( 'Tucumán Province', 'lifterlms' ),
	),
	'AS' => array(),
	'AT' => array(
		'1' => __( 'Burgenland', 'lifterlms' ),
		'2' => __( 'Carinthia', 'lifterlms' ),
		'3' => __( 'Lower Austria', 'lifterlms' ),
		'4' => __( 'Upper Austria', 'lifterlms' ),
		'5' => __( 'Salzburg', 'lifterlms' ),
		'6' => __( 'Styria', 'lifterlms' ),
		'7' => __( 'Tyrol', 'lifterlms' ),
		'8' => __( 'Vorarlberg', 'lifterlms' ),
		'9' => __( 'Vienna', 'lifterlms' ),
	),
	'AU' => array(
		'ACT' => __( 'Australian Capital Territory', 'lifterlms' ),
		'NSW' => __( 'New South Wales', 'lifterlms' ),
		'NT'  => __( 'Northern Territory', 'lifterlms' ),
		'QLD' => __( 'Queensland', 'lifterlms' ),
		'SA'  => __( 'South Australia', 'lifterlms' ),
		'TAS' => __( 'Tasmania', 'lifterlms' ),
		'VIC' => __( 'Victoria', 'lifterlms' ),
		'WA'  => __( 'Western Australia', 'lifterlms' ),
	),
	'AW' => array(),
	'AX' => array(),
	'AZ' => array(
		'ABS' => __( 'Absheron District', 'lifterlms' ),
		'AGM' => __( 'Agdam District', 'lifterlms' ),
		'AGS' => __( 'Agdash District', 'lifterlms' ),
		'AGC' => __( 'Aghjabadi District', 'lifterlms' ),
		'AGA' => __( 'Agstafa District', 'lifterlms' ),
		'AGU' => __( 'Agsu District', 'lifterlms' ),
		'AST' => __( 'Astara District', 'lifterlms' ),
		'BAB' => __( 'Babek District', 'lifterlms' ),
		'BA'  => __( 'Baku', 'lifterlms' ),
		'BAL' => __( 'Balakan District', 'lifterlms' ),
		'BAR' => __( 'Barda District', 'lifterlms' ),
		'BEY' => __( 'Beylagan District', 'lifterlms' ),
		'BIL' => __( 'Bilasuvar District', 'lifterlms' ),
		'DAS' => __( 'Dashkasan District', 'lifterlms' ),
		'FUZ' => __( 'Fizuli District', 'lifterlms' ),
		'GA'  => __( 'Ganja', 'lifterlms' ),
		'QOB' => __( 'Gobustan District', 'lifterlms' ),
		'GOR' => __( 'Goranboy District', 'lifterlms' ),
		'GOY' => __( 'Goychay', 'lifterlms' ),
		'GYG' => __( 'Goygol District', 'lifterlms' ),
		'GAD' => __( 'Gədəbəy', 'lifterlms' ),
		'HAC' => __( 'Hajigabul District', 'lifterlms' ),
		'IMI' => __( 'Imishli District', 'lifterlms' ),
		'ISM' => __( 'Ismailli District', 'lifterlms' ),
		'CAB' => __( 'Jabrayil District', 'lifterlms' ),
		'CAL' => __( 'Jalilabad District', 'lifterlms' ),
		'CUL' => __( 'Julfa District', 'lifterlms' ),
		'KAL' => __( 'Kalbajar District', 'lifterlms' ),
		'KAN' => __( 'Kangarli District', 'lifterlms' ),
		'XAC' => __( 'Khachmaz District', 'lifterlms' ),
		'XIZ' => __( 'Khizi District', 'lifterlms' ),
		'XCI' => __( 'Khojali District', 'lifterlms' ),
		'KUR' => __( 'Kurdamir District', 'lifterlms' ),
		'LAC' => __( 'Lachin District', 'lifterlms' ),
		'LAN' => __( 'Lankaran', 'lifterlms' ),
		'LA'  => __( 'Lankaran District', 'lifterlms' ),
		'LER' => __( 'Lerik District', 'lifterlms' ),
		'XVD' => __( 'Martuni', 'lifterlms' ),
		'MAS' => __( 'Masally District', 'lifterlms' ),
		'MI'  => __( 'Mingachevir', 'lifterlms' ),
		'NX'  => __( 'Nakhchivan Autonomous Republic', 'lifterlms' ),
		'NEF' => __( 'Neftchala District', 'lifterlms' ),
		'OGU' => __( 'Oghuz District', 'lifterlms' ),
		'ORD' => __( 'Ordubad District', 'lifterlms' ),
		'QAB' => __( 'Qabala District', 'lifterlms' ),
		'QAX' => __( 'Qakh District', 'lifterlms' ),
		'QAZ' => __( 'Qazakh District', 'lifterlms' ),
		'QBA' => __( 'Quba District', 'lifterlms' ),
		'QBI' => __( 'Qubadli District', 'lifterlms' ),
		'QUS' => __( 'Qusar District', 'lifterlms' ),
		'SAT' => __( 'Saatly District', 'lifterlms' ),
		'SAB' => __( 'Sabirabad District', 'lifterlms' ),
		'SAD' => __( 'Sadarak District', 'lifterlms' ),
		'SAL' => __( 'Salyan District', 'lifterlms' ),
		'SMX' => __( 'Samukh District', 'lifterlms' ),
		'SBN' => __( 'Shabran District', 'lifterlms' ),
		'SAH' => __( 'Shahbuz District', 'lifterlms' ),
		'SA'  => __( 'Shaki', 'lifterlms' ),
		'SAK' => __( 'Shaki District', 'lifterlms' ),
		'SMI' => __( 'Shamakhi District', 'lifterlms' ),
		'SKR' => __( 'Shamkir District', 'lifterlms' ),
		'SAR' => __( 'Sharur District', 'lifterlms' ),
		'SR'  => __( 'Shirvan', 'lifterlms' ),
		'SUS' => __( 'Shusha District', 'lifterlms' ),
		'SIY' => __( 'Siazan District', 'lifterlms' ),
		'SM'  => __( 'Sumqayit', 'lifterlms' ),
		'TAR' => __( 'Tartar District', 'lifterlms' ),
		'TOV' => __( 'Tovuz District', 'lifterlms' ),
		'UCA' => __( 'Ujar District', 'lifterlms' ),
		'YAR' => __( 'Yardymli District', 'lifterlms' ),
		'YE'  => __( 'Yevlakh', 'lifterlms' ),
		'YEV' => __( 'Yevlakh District', 'lifterlms' ),
		'ZAN' => __( 'Zangilan District', 'lifterlms' ),
		'ZAQ' => __( 'Zaqatala District', 'lifterlms' ),
		'ZAR' => __( 'Zardab District', 'lifterlms' ),
	),
	'BA' => array(
		'10'  => __( 'Canton 10', 'lifterlms' ),
		'05'  => __( 'Bosnian Podrinje Canton', 'lifterlms' ),
		'BRC' => __( 'Brčko District', 'lifterlms' ),
		'06'  => __( 'Central Bosnia Canton', 'lifterlms' ),
		'BIH' => __( 'Federation of Bosnia and Herzegovina', 'lifterlms' ),
		'07'  => __( 'Herzegovina-Neretva Canton', 'lifterlms' ),
		'02'  => __( 'Posavina Canton', 'lifterlms' ),
		'SRP' => __( 'Republika Srpska', 'lifterlms' ),
		'09'  => __( 'Sarajevo Canton', 'lifterlms' ),
		'03'  => __( 'Tuzla Canton', 'lifterlms' ),
		'01'  => __( 'Una-Sana Canton', 'lifterlms' ),
		'08'  => __( 'West Herzegovina Canton', 'lifterlms' ),
		'04'  => __( 'Zenica-Doboj Canton', 'lifterlms' ),
	),
	'BB' => array(
		'10' => __( 'Saint Philip', 'lifterlms' ),
		'11' => __( 'Saint Thomas', 'lifterlms' ),
		'01' => __( 'Christ Church', 'lifterlms' ),
		'02' => __( 'Saint Andrew', 'lifterlms' ),
		'03' => __( 'Saint George', 'lifterlms' ),
		'04' => __( 'Saint James', 'lifterlms' ),
		'05' => __( 'Saint John', 'lifterlms' ),
		'06' => __( 'Saint Joseph', 'lifterlms' ),
		'07' => __( 'Saint Lucy', 'lifterlms' ),
		'08' => __( 'Saint Michael', 'lifterlms' ),
		'09' => __( 'Saint Peter', 'lifterlms' ),
	),
	'BD' => array(
		'10' => __( 'Chittagong District', 'lifterlms' ),
		'11' => __( 'Cox\'s Bazar District', 'lifterlms' ),
		'12' => __( 'Chuadanga District', 'lifterlms' ),
		'13' => __( 'Dhaka District', 'lifterlms' ),
		'14' => __( 'Dinajpur District', 'lifterlms' ),
		'15' => __( 'Faridpur District', 'lifterlms' ),
		'16' => __( 'Feni District', 'lifterlms' ),
		'17' => __( 'Gopalganj District', 'lifterlms' ),
		'18' => __( 'Gazipur District', 'lifterlms' ),
		'19' => __( 'Gaibandha District', 'lifterlms' ),
		'20' => __( 'Habiganj District', 'lifterlms' ),
		'21' => __( 'Jamalpur District', 'lifterlms' ),
		'22' => __( 'Jessore District', 'lifterlms' ),
		'23' => __( 'Jhenaidah District', 'lifterlms' ),
		'24' => __( 'Joypurhat District', 'lifterlms' ),
		'25' => __( 'Jhalokati District', 'lifterlms' ),
		'26' => __( 'Kishoreganj District', 'lifterlms' ),
		'27' => __( 'Khulna District', 'lifterlms' ),
		'28' => __( 'Kurigram District', 'lifterlms' ),
		'29' => __( 'Khagrachari District', 'lifterlms' ),
		'30' => __( 'Kushtia District', 'lifterlms' ),
		'31' => __( 'Lakshmipur District', 'lifterlms' ),
		'32' => __( 'Lalmonirhat District', 'lifterlms' ),
		'33' => __( 'Bahadia', 'lifterlms' ),
		'34' => __( 'Mymensingh District', 'lifterlms' ),
		'35' => __( 'Munshiganj District', 'lifterlms' ),
		'36' => __( 'Madaripur District', 'lifterlms' ),
		'38' => __( 'Moulvibazar District', 'lifterlms' ),
		'39' => __( 'Meherpur District', 'lifterlms' ),
		'40' => __( 'Narayanganj District', 'lifterlms' ),
		'41' => __( 'Netrokona District', 'lifterlms' ),
		'43' => __( 'Narail District', 'lifterlms' ),
		'44' => __( 'Natore District', 'lifterlms' ),
		'45' => __( 'Chapai Nawabganj District', 'lifterlms' ),
		'46' => __( 'Nilphamari District', 'lifterlms' ),
		'47' => __( 'Noakhali District', 'lifterlms' ),
		'48' => __( 'Naogaon District', 'lifterlms' ),
		'49' => __( 'Pabna District', 'lifterlms' ),
		'50' => __( 'Pirojpur District', 'lifterlms' ),
		'51' => __( 'Patuakhali District', 'lifterlms' ),
		'52' => __( 'Panchagarh District', 'lifterlms' ),
		'53' => __( 'Rajbari District', 'lifterlms' ),
		'54' => __( 'Rajshahi District', 'lifterlms' ),
		'55' => __( 'Rangpur District', 'lifterlms' ),
		'56' => __( 'Rangamati Hill District', 'lifterlms' ),
		'57' => __( 'Sherpur District', 'lifterlms' ),
		'58' => __( 'Satkhira District', 'lifterlms' ),
		'59' => __( 'Sirajganj District', 'lifterlms' ),
		'60' => __( 'Sylhet District', 'lifterlms' ),
		'61' => __( 'Sunamganj District', 'lifterlms' ),
		'62' => __( 'Shariatpur District', 'lifterlms' ),
		'63' => __( 'Tangail District', 'lifterlms' ),
		'64' => __( 'Thakurgaon District', 'lifterlms' ),
		'05' => __( 'Bagerhat District', 'lifterlms' ),
		'01' => __( 'Bandarban District', 'lifterlms' ),
		'02' => __( 'Barguna District', 'lifterlms' ),
		'06' => __( 'Barisal District', 'lifterlms' ),
		'A'  => __( 'Barisal Division', 'lifterlms' ),
		'07' => __( 'Bhola District', 'lifterlms' ),
		'03' => __( 'Bogra District', 'lifterlms' ),
		'04' => __( 'Brahmanbaria District', 'lifterlms' ),
		'09' => __( 'Chandpur District', 'lifterlms' ),
		'B'  => __( 'Chittagong Division', 'lifterlms' ),
		'08' => __( 'Comilla District', 'lifterlms' ),
		'C'  => __( 'Dhaka Division', 'lifterlms' ),
		'D'  => __( 'Khulna Division', 'lifterlms' ),
		'H'  => __( 'Mymensingh Division', 'lifterlms' ),
		'E'  => __( 'Rajshahi Division', 'lifterlms' ),
		'F'  => __( 'Rangpur Division', 'lifterlms' ),
		'G'  => __( 'Sylhet Division', 'lifterlms' ),
	),
	'BE' => array(
		'VAN' => __( 'Antwerp', 'lifterlms' ),
		'BRU' => __( 'Brussels-Capital Region', 'lifterlms' ),
		'VOV' => __( 'East Flanders', 'lifterlms' ),
		'VLG' => __( 'Flanders', 'lifterlms' ),
		'VBR' => __( 'Flemish Brabant', 'lifterlms' ),
		'WHT' => __( 'Hainaut', 'lifterlms' ),
		'VLI' => __( 'Limburg', 'lifterlms' ),
		'WLG' => __( 'Liège', 'lifterlms' ),
		'WLX' => __( 'Luxembourg', 'lifterlms' ),
		'WNA' => __( 'Namur', 'lifterlms' ),
		'WAL' => __( 'Wallonia', 'lifterlms' ),
		'WBR' => __( 'Walloon Brabant', 'lifterlms' ),
		'VWV' => __( 'West Flanders', 'lifterlms' ),
	),
	'BF' => array(
		'10'  => __( 'Nord Region, Burkina Faso', 'lifterlms' ),
		'11'  => __( 'Plateau-Central Region', 'lifterlms' ),
		'12'  => __( 'Sahel Region', 'lifterlms' ),
		'13'  => __( 'Sud-Ouest Region', 'lifterlms' ),
		'BAL' => __( 'Balé Province', 'lifterlms' ),
		'BAM' => __( 'Bam Province', 'lifterlms' ),
		'BAN' => __( 'Banwa Province', 'lifterlms' ),
		'BAZ' => __( 'Bazèga Province', 'lifterlms' ),
		'01'  => __( 'Boucle du Mouhoun Region', 'lifterlms' ),
		'BGR' => __( 'Bougouriba Province', 'lifterlms' ),
		'BLG' => __( 'Boulgou', 'lifterlms' ),
		'02'  => __( 'Cascades Region', 'lifterlms' ),
		'03'  => __( 'Centre', 'lifterlms' ),
		'04'  => __( 'Centre-Est Region', 'lifterlms' ),
		'05'  => __( 'Centre-Nord Region', 'lifterlms' ),
		'06'  => __( 'Centre-Ouest Region', 'lifterlms' ),
		'07'  => __( 'Centre-Sud Region', 'lifterlms' ),
		'COM' => __( 'Comoé Province', 'lifterlms' ),
		'08'  => __( 'Est Region', 'lifterlms' ),
		'GAN' => __( 'Ganzourgou Province', 'lifterlms' ),
		'GNA' => __( 'Gnagna Province', 'lifterlms' ),
		'GOU' => __( 'Gourma Province', 'lifterlms' ),
		'09'  => __( 'Hauts-Bassins Region', 'lifterlms' ),
		'HOU' => __( 'Houet Province', 'lifterlms' ),
		'IOB' => __( 'Ioba Province', 'lifterlms' ),
		'KAD' => __( 'Kadiogo Province', 'lifterlms' ),
		'KMD' => __( 'Komondjari Province', 'lifterlms' ),
		'KMP' => __( 'Kompienga Province', 'lifterlms' ),
		'KOS' => __( 'Kossi Province', 'lifterlms' ),
		'KOP' => __( 'Koulpélogo Province', 'lifterlms' ),
		'KOT' => __( 'Kouritenga Province', 'lifterlms' ),
		'KOW' => __( 'Kourwéogo Province', 'lifterlms' ),
		'KEN' => __( 'Kénédougou Province', 'lifterlms' ),
		'LOR' => __( 'Loroum Province', 'lifterlms' ),
		'LER' => __( 'Léraba Province', 'lifterlms' ),
		'MOU' => __( 'Mouhoun', 'lifterlms' ),
		'NAO' => __( 'Nahouri Province', 'lifterlms' ),
		'NAM' => __( 'Namentenga Province', 'lifterlms' ),
		'NAY' => __( 'Nayala Province', 'lifterlms' ),
		'NOU' => __( 'Noumbiel Province', 'lifterlms' ),
		'OUB' => __( 'Oubritenga Province', 'lifterlms' ),
		'OUD' => __( 'Oudalan Province', 'lifterlms' ),
		'PAS' => __( 'Passoré Province', 'lifterlms' ),
		'PON' => __( 'Poni Province', 'lifterlms' ),
		'SNG' => __( 'Sanguié Province', 'lifterlms' ),
		'SMT' => __( 'Sanmatenga Province', 'lifterlms' ),
		'SIS' => __( 'Sissili Province', 'lifterlms' ),
		'SOM' => __( 'Soum Province', 'lifterlms' ),
		'SOR' => __( 'Sourou Province', 'lifterlms' ),
		'SEN' => __( 'Séno Province', 'lifterlms' ),
		'TAP' => __( 'Tapoa Province', 'lifterlms' ),
		'TUI' => __( 'Tuy Province', 'lifterlms' ),
		'YAG' => __( 'Yagha Province', 'lifterlms' ),
		'YAT' => __( 'Yatenga Province', 'lifterlms' ),
		'ZIR' => __( 'Ziro Province', 'lifterlms' ),
		'ZON' => __( 'Zondoma Province', 'lifterlms' ),
		'ZOU' => __( 'Zoundwéogo Province', 'lifterlms' ),
	),
	'BG' => array(
		'10' => __( 'Kyustendil Province', 'lifterlms' ),
		'11' => __( 'Lovech Province', 'lifterlms' ),
		'12' => __( 'Montana Province', 'lifterlms' ),
		'13' => __( 'Pazardzhik Province', 'lifterlms' ),
		'14' => __( 'Pernik Province', 'lifterlms' ),
		'15' => __( 'Pleven Province', 'lifterlms' ),
		'16' => __( 'Plovdiv Province', 'lifterlms' ),
		'17' => __( 'Razgrad Province', 'lifterlms' ),
		'18' => __( 'Ruse Province', 'lifterlms' ),
		'19' => __( 'Silistra Province', 'lifterlms' ),
		'20' => __( 'Sliven Province', 'lifterlms' ),
		'21' => __( 'Smolyan Province', 'lifterlms' ),
		'22' => __( 'Sofia City Province', 'lifterlms' ),
		'23' => __( 'Sofia Province', 'lifterlms' ),
		'24' => __( 'Stara Zagora Province', 'lifterlms' ),
		'25' => __( 'Targovishte Province', 'lifterlms' ),
		'26' => __( 'Haskovo Province', 'lifterlms' ),
		'27' => __( 'Shumen', 'lifterlms' ),
		'28' => __( 'Yambol Province', 'lifterlms' ),
		'01' => __( 'Blagoevgrad Province', 'lifterlms' ),
		'02' => __( 'Burgas Province', 'lifterlms' ),
		'08' => __( 'Dobrich Province', 'lifterlms' ),
		'07' => __( 'Gabrovo Province', 'lifterlms' ),
		'09' => __( 'Kardzhali Province', 'lifterlms' ),
		'03' => __( 'Varna Province', 'lifterlms' ),
		'04' => __( 'Veliko Tarnovo Province', 'lifterlms' ),
		'05' => __( 'Vidin Province', 'lifterlms' ),
		'06' => __( 'Vratsa Province', 'lifterlms' ),
	),
	'BH' => array(
		'13' => __( 'Capital Governorate', 'lifterlms' ),
		'14' => __( 'Southern Governorate', 'lifterlms' ),
		'15' => __( 'Muharraq Governorate', 'lifterlms' ),
		'16' => __( 'Central Governorate', 'lifterlms' ),
		'17' => __( 'Northern Governorate', 'lifterlms' ),
	),
	'BI' => array(
		'BB' => __( 'Bubanza Province', 'lifterlms' ),
		'BM' => __( 'Bujumbura Mairie Province', 'lifterlms' ),
		'BL' => __( 'Bujumbura Rural Province', 'lifterlms' ),
		'BR' => __( 'Bururi Province', 'lifterlms' ),
		'CA' => __( 'Cankuzo Province', 'lifterlms' ),
		'CI' => __( 'Cibitoke Province', 'lifterlms' ),
		'GI' => __( 'Gitega Province', 'lifterlms' ),
		'KR' => __( 'Karuzi Province', 'lifterlms' ),
		'KY' => __( 'Kayanza Province', 'lifterlms' ),
		'KI' => __( 'Kirundo Province', 'lifterlms' ),
		'MA' => __( 'Makamba Province', 'lifterlms' ),
		'MU' => __( 'Muramvya Province', 'lifterlms' ),
		'MY' => __( 'Muyinga Province', 'lifterlms' ),
		'MW' => __( 'Mwaro Province', 'lifterlms' ),
		'NG' => __( 'Ngozi Province', 'lifterlms' ),
		'RM' => __( 'Rumonge Province', 'lifterlms' ),
		'RT' => __( 'Rutana Province', 'lifterlms' ),
		'RY' => __( 'Ruyigi Province', 'lifterlms' ),
	),
	'BJ' => array(
		'AL' => __( 'Alibori Department', 'lifterlms' ),
		'AK' => __( 'Atakora Department', 'lifterlms' ),
		'AQ' => __( 'Atlantique Department', 'lifterlms' ),
		'BO' => __( 'Borgou Department', 'lifterlms' ),
		'CO' => __( 'Collines Department', 'lifterlms' ),
		'DO' => __( 'Donga Department', 'lifterlms' ),
		'KO' => __( 'Kouffo Department', 'lifterlms' ),
		'LI' => __( 'Littoral Department', 'lifterlms' ),
		'MO' => __( 'Mono Department', 'lifterlms' ),
		'OU' => __( 'Ouémé Department', 'lifterlms' ),
		'PL' => __( 'Plateau Department', 'lifterlms' ),
		'ZO' => __( 'Zou Department', 'lifterlms' ),
	),
	'BL' => array(),
	'BM' => array(
		'DEV' => __( 'Devonshire Parish', 'lifterlms' ),
		'HAM' => __( 'Hamilton Municipality', 'lifterlms' ),
		'HA'  => __( 'Hamilton Parish', 'lifterlms' ),
		'PAG' => __( 'Paget Parish', 'lifterlms' ),
		'PEM' => __( 'Pembroke Parish', 'lifterlms' ),
		'SG'  => __( 'Saint George\'s Municipality', 'lifterlms' ),
		'SGE' => __( 'Saint George\'s Parish', 'lifterlms' ),
		'SAN' => __( 'Sandys Parish', 'lifterlms' ),
		'SMI' => __( 'Smith\'s Parish,', 'lifterlms' ),
		'SOU' => __( 'Southampton Parish', 'lifterlms' ),
		'WAR' => __( 'Warwick Parish', 'lifterlms' ),
	),
	'BN' => array(
		'BE' => __( 'Belait District', 'lifterlms' ),
		'BM' => __( 'Brunei-Muara District', 'lifterlms' ),
		'TE' => __( 'Temburong District', 'lifterlms' ),
		'TU' => __( 'Tutong District', 'lifterlms' ),
	),
	'BO' => array(
		'B' => __( 'Beni Department', 'lifterlms' ),
		'H' => __( 'Chuquisaca Department', 'lifterlms' ),
		'C' => __( 'Cochabamba Department', 'lifterlms' ),
		'L' => __( 'La Paz Department', 'lifterlms' ),
		'O' => __( 'Oruro Department', 'lifterlms' ),
		'N' => __( 'Pando Department', 'lifterlms' ),
		'P' => __( 'Potosí Department', 'lifterlms' ),
		'S' => __( 'Santa Cruz Department', 'lifterlms' ),
		'T' => __( 'Tarija Department', 'lifterlms' ),
	),
	'BQ' => array(),
	'BR' => array(
		'AC' => __( 'Acre', 'lifterlms' ),
		'AL' => __( 'Alagoas', 'lifterlms' ),
		'AP' => __( 'Amapá', 'lifterlms' ),
		'AM' => __( 'Amazonas', 'lifterlms' ),
		'BA' => __( 'Bahia', 'lifterlms' ),
		'CE' => __( 'Ceará', 'lifterlms' ),
		'ES' => __( 'Espírito Santo', 'lifterlms' ),
		'DF' => __( 'Federal District', 'lifterlms' ),
		'GO' => __( 'Goiás', 'lifterlms' ),
		'MA' => __( 'Maranhão', 'lifterlms' ),
		'MT' => __( 'Mato Grosso', 'lifterlms' ),
		'MS' => __( 'Mato Grosso do Sul', 'lifterlms' ),
		'MG' => __( 'Minas Gerais', 'lifterlms' ),
		'PR' => __( 'Paraná', 'lifterlms' ),
		'PB' => __( 'Paraíba', 'lifterlms' ),
		'PA' => __( 'Pará', 'lifterlms' ),
		'PE' => __( 'Pernambuco', 'lifterlms' ),
		'PI' => __( 'Piauí', 'lifterlms' ),
		'RN' => __( 'Rio Grande do Norte', 'lifterlms' ),
		'RS' => __( 'Rio Grande do Sul', 'lifterlms' ),
		'RJ' => __( 'Rio de Janeiro', 'lifterlms' ),
		'RO' => __( 'Rondônia', 'lifterlms' ),
		'RR' => __( 'Roraima', 'lifterlms' ),
		'SC' => __( 'Santa Catarina', 'lifterlms' ),
		'SE' => __( 'Sergipe', 'lifterlms' ),
		'SP' => __( 'São Paulo', 'lifterlms' ),
		'TO' => __( 'Tocantins', 'lifterlms' ),
	),
	'BS' => array(
		'AK' => __( 'Acklins', 'lifterlms' ),
		'AC' => __( 'Acklins and Crooked Islands', 'lifterlms' ),
		'BY' => __( 'Berry Islands', 'lifterlms' ),
		'BI' => __( 'Bimini', 'lifterlms' ),
		'BP' => __( 'Black Point', 'lifterlms' ),
		'CI' => __( 'Cat Island', 'lifterlms' ),
		'CO' => __( 'Central Abaco', 'lifterlms' ),
		'CS' => __( 'Central Andros', 'lifterlms' ),
		'CE' => __( 'Central Eleuthera', 'lifterlms' ),
		'CK' => __( 'Crooked Island', 'lifterlms' ),
		'EG' => __( 'East Grand Bahama', 'lifterlms' ),
		'EX' => __( 'Exuma', 'lifterlms' ),
		'FP' => __( 'Freeport', 'lifterlms' ),
		'FC' => __( 'Fresh Creek', 'lifterlms' ),
		'GH' => __( 'Governor\'s Harbour', 'lifterlms' ),
		'GC' => __( 'Grand Cay', 'lifterlms' ),
		'GT' => __( 'Green Turtle Cay', 'lifterlms' ),
		'HI' => __( 'Harbour Island', 'lifterlms' ),
		'HR' => __( 'High Rock', 'lifterlms' ),
		'HT' => __( 'Hope Town', 'lifterlms' ),
		'IN' => __( 'Inagua', 'lifterlms' ),
		'KB' => __( 'Kemps Bay', 'lifterlms' ),
		'LI' => __( 'Long Island', 'lifterlms' ),
		'MC' => __( 'Mangrove Cay', 'lifterlms' ),
		'MH' => __( 'Marsh Harbour', 'lifterlms' ),
		'MG' => __( 'Mayaguana District', 'lifterlms' ),
		'NP' => __( 'New Providence', 'lifterlms' ),
		'NB' => __( 'Nichollstown and Berry Islands', 'lifterlms' ),
		'NO' => __( 'North Abaco', 'lifterlms' ),
		'NS' => __( 'North Andros', 'lifterlms' ),
		'NE' => __( 'North Eleuthera', 'lifterlms' ),
		'RI' => __( 'Ragged Island', 'lifterlms' ),
		'RS' => __( 'Rock Sound', 'lifterlms' ),
		'RC' => __( 'Rum Cay District', 'lifterlms' ),
		'SS' => __( 'San Salvador Island', 'lifterlms' ),
		'SR' => __( 'San Salvador and Rum Cay', 'lifterlms' ),
		'SP' => __( 'Sandy Point', 'lifterlms' ),
		'SO' => __( 'South Abaco', 'lifterlms' ),
		'SA' => __( 'South Andros', 'lifterlms' ),
		'SE' => __( 'South Eleuthera', 'lifterlms' ),
		'SW' => __( 'Spanish Wells', 'lifterlms' ),
		'WG' => __( 'West Grand Bahama', 'lifterlms' ),
	),
	'BT' => array(
		'11' => __( 'Paro District', 'lifterlms' ),
		'12' => __( 'Chukha District', 'lifterlms' ),
		'13' => __( 'Haa District', 'lifterlms' ),
		'14' => __( 'Samtse District', 'lifterlms' ),
		'15' => __( 'Thimphu District', 'lifterlms' ),
		'21' => __( 'Tsirang District', 'lifterlms' ),
		'22' => __( 'Dagana District', 'lifterlms' ),
		'23' => __( 'Punakha District', 'lifterlms' ),
		'24' => __( 'Wangdue Phodrang District', 'lifterlms' ),
		'31' => __( 'Sarpang District', 'lifterlms' ),
		'32' => __( 'Trongsa District', 'lifterlms' ),
		'33' => __( 'Bumthang District', 'lifterlms' ),
		'34' => __( 'Zhemgang District', 'lifterlms' ),
		'41' => __( 'Trashigang District', 'lifterlms' ),
		'42' => __( 'Mongar District', 'lifterlms' ),
		'43' => __( 'Pemagatshel District', 'lifterlms' ),
		'44' => __( 'Lhuntse District', 'lifterlms' ),
		'45' => __( 'Samdrup Jongkhar District', 'lifterlms' ),
		'GA' => __( 'Gasa District', 'lifterlms' ),
	),
	'BV' => array(),
	'BW' => array(
		'CE' => __( 'Central District', 'lifterlms' ),
		'GH' => __( 'Ghanzi District', 'lifterlms' ),
		'KG' => __( 'Kgalagadi District', 'lifterlms' ),
		'KL' => __( 'Kgatleng District', 'lifterlms' ),
		'KW' => __( 'Kweneng District', 'lifterlms' ),
		'NG' => __( 'Ngamiland', 'lifterlms' ),
		'NE' => __( 'North-East District', 'lifterlms' ),
		'NW' => __( 'North-West District', 'lifterlms' ),
		'SE' => __( 'South-East District', 'lifterlms' ),
		'SO' => __( 'Southern District', 'lifterlms' ),
	),
	'BY' => array(
		'BR' => __( 'Brest Region', 'lifterlms' ),
		'HO' => __( 'Gomel Region', 'lifterlms' ),
		'HR' => __( 'Grodno Region', 'lifterlms' ),
		'HM' => __( 'Minsk', 'lifterlms' ),
		'MI' => __( 'Minsk Region', 'lifterlms' ),
		'MA' => __( 'Mogilev Region', 'lifterlms' ),
		'VI' => __( 'Vitebsk Region', 'lifterlms' ),
	),
	'BZ' => array(
		'BZ'  => __( 'Belize District', 'lifterlms' ),
		'CY'  => __( 'Cayo District', 'lifterlms' ),
		'CZL' => __( 'Corozal District', 'lifterlms' ),
		'OW'  => __( 'Orange Walk District', 'lifterlms' ),
		'SC'  => __( 'Stann Creek District', 'lifterlms' ),
		'TOL' => __( 'Toledo District', 'lifterlms' ),
	),
	'CA' => array(
		'AB' => __( 'Alberta', 'lifterlms' ),
		'BC' => __( 'British Columbia', 'lifterlms' ),
		'MB' => __( 'Manitoba', 'lifterlms' ),
		'NB' => __( 'New Brunswick', 'lifterlms' ),
		'NL' => __( 'Newfoundland and Labrador', 'lifterlms' ),
		'NT' => __( 'Northwest Territories', 'lifterlms' ),
		'NS' => __( 'Nova Scotia', 'lifterlms' ),
		'NU' => __( 'Nunavut', 'lifterlms' ),
		'ON' => __( 'Ontario', 'lifterlms' ),
		'PE' => __( 'Prince Edward Island', 'lifterlms' ),
		'QC' => __( 'Quebec', 'lifterlms' ),
		'SK' => __( 'Saskatchewan', 'lifterlms' ),
		'YT' => __( 'Yukon', 'lifterlms' ),
	),
	'CC' => array(),
	'CD' => array(
		'BN' => __( 'Bandundu Province', 'lifterlms' ),
		'BC' => __( 'Bas-Congo province', 'lifterlms' ),
		'BU' => __( 'Bas-Uele', 'lifterlms' ),
		'HK' => __( 'Haut-Katanga Province', 'lifterlms' ),
		'HL' => __( 'Haut-Lomami District', 'lifterlms' ),
		'HU' => __( 'Haut-Uele', 'lifterlms' ),
		'IT' => __( 'Ituri Interim Administration', 'lifterlms' ),
		'KS' => __( 'Kasaï District', 'lifterlms' ),
		'KW' => __( 'Kasaï-Occidental', 'lifterlms' ),
		'KE' => __( 'Kasaï-Oriental', 'lifterlms' ),
		'KA' => __( 'Katanga Province', 'lifterlms' ),
		'KN' => __( 'Kinshasa', 'lifterlms' ),
		'KG' => __( 'Kwango District', 'lifterlms' ),
		'KL' => __( 'Kwilu District', 'lifterlms' ),
		'LO' => __( 'Lomami Province', 'lifterlms' ),
		'MN' => __( 'Mai-Ndombe Province', 'lifterlms' ),
		'MA' => __( 'Maniema', 'lifterlms' ),
		'MO' => __( 'Mongala District', 'lifterlms' ),
		'NU' => __( 'Nord-Ubangi District', 'lifterlms' ),
		'NK' => __( 'North Kivu', 'lifterlms' ),
		'OR' => __( 'Orientale Province', 'lifterlms' ),
		'SA' => __( 'Sankuru District', 'lifterlms' ),
		'SK' => __( 'South Kivu', 'lifterlms' ),
		'SU' => __( 'Sud-Ubangi', 'lifterlms' ),
		'TA' => __( 'Tanganyika Province', 'lifterlms' ),
		'TO' => __( 'Tshopo District', 'lifterlms' ),
		'TU' => __( 'Tshuapa District', 'lifterlms' ),
		'EQ' => __( 'Équateur', 'lifterlms' ),
	),
	'CF' => array(
		'BB'  => __( 'Bamingui-Bangoran Prefecture', 'lifterlms' ),
		'BGF' => __( 'Bangui', 'lifterlms' ),
		'BK'  => __( 'Basse-Kotto Prefecture', 'lifterlms' ),
		'HM'  => __( 'Haut-Mbomou Prefecture', 'lifterlms' ),
		'HK'  => __( 'Haute-Kotto Prefecture', 'lifterlms' ),
		'KG'  => __( 'Kémo Prefecture', 'lifterlms' ),
		'LB'  => __( 'Lobaye Prefecture', 'lifterlms' ),
		'HS'  => __( 'Mambéré-Kadéï', 'lifterlms' ),
		'MB'  => __( 'Mbomou Prefecture', 'lifterlms' ),
		'KB'  => __( 'Nana-Grébizi Economic Prefecture', 'lifterlms' ),
		'NM'  => __( 'Nana-Mambéré Prefecture', 'lifterlms' ),
		'MP'  => __( 'Ombella-M\'Poko Prefecture', 'lifterlms' ),
		'UK'  => __( 'Ouaka Prefecture', 'lifterlms' ),
		'AC'  => __( 'Ouham Prefecture', 'lifterlms' ),
		'OP'  => __( 'Ouham-Pendé Prefecture', 'lifterlms' ),
		'SE'  => __( 'Sangha-Mbaéré', 'lifterlms' ),
		'VK'  => __( 'Vakaga Prefecture', 'lifterlms' ),
	),
	'CG' => array(
		'2'   => __( 'Lékoumou Department', 'lifterlms' ),
		'5'   => __( 'Kouilou Department', 'lifterlms' ),
		'7'   => __( 'Likouala Department', 'lifterlms' ),
		'8'   => __( 'Cuvette Department', 'lifterlms' ),
		'9'   => __( 'Niari Department', 'lifterlms' ),
		'11'  => __( 'Bouenza Department', 'lifterlms' ),
		'12'  => __( 'Pool Department', 'lifterlms' ),
		'13'  => __( 'Sangha Department', 'lifterlms' ),
		'14'  => __( 'Plateaux Department', 'lifterlms' ),
		'15'  => __( 'Cuvette-Ouest Department', 'lifterlms' ),
		'16'  => __( 'Pointe-Noire', 'lifterlms' ),
		'BZV' => __( 'Brazzaville', 'lifterlms' ),
	),
	'CH' => array(
		'AG' => __( 'Aargau', 'lifterlms' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'lifterlms' ),
		'AI' => __( 'Appenzell Innerrhoden', 'lifterlms' ),
		'BL' => __( 'Basel-Landschaft', 'lifterlms' ),
		'FR' => __( 'Canton of Fribourg', 'lifterlms' ),
		'GE' => __( 'Canton of Geneva', 'lifterlms' ),
		'JU' => __( 'Canton of Jura', 'lifterlms' ),
		'LU' => __( 'Canton of Lucerne', 'lifterlms' ),
		'NE' => __( 'Canton of Neuchâtel', 'lifterlms' ),
		'SH' => __( 'Canton of Schaffhausen', 'lifterlms' ),
		'SO' => __( 'Canton of Solothurn', 'lifterlms' ),
		'SG' => __( 'Canton of St. Gallen', 'lifterlms' ),
		'VS' => __( 'Canton of Valais', 'lifterlms' ),
		'VD' => __( 'Canton of Vaud', 'lifterlms' ),
		'ZG' => __( 'Canton of Zug', 'lifterlms' ),
		'GL' => __( 'Glarus', 'lifterlms' ),
		'GR' => __( 'Graubünden', 'lifterlms' ),
		'NW' => __( 'Nidwalden', 'lifterlms' ),
		'OW' => __( 'Obwalden', 'lifterlms' ),
		'SZ' => __( 'Schwyz', 'lifterlms' ),
		'TG' => __( 'Thurgau', 'lifterlms' ),
		'TI' => __( 'Ticino', 'lifterlms' ),
		'UR' => __( 'Uri', 'lifterlms' ),
		'BE' => __( 'canton of Bern', 'lifterlms' ),
		'ZH' => __( 'canton of Zürich', 'lifterlms' ),
	),
	'CI' => array(
		'10' => __( 'Denguélé Region', 'lifterlms' ),
		'11' => __( 'N\'zi-Comoé', 'lifterlms' ),
		'12' => __( 'Marahoué Region', 'lifterlms' ),
		'13' => __( 'Sud-Comoé', 'lifterlms' ),
		'14' => __( 'Worodougou', 'lifterlms' ),
		'15' => __( 'Sud-Bandama', 'lifterlms' ),
		'16' => __( 'Agnéby', 'lifterlms' ),
		'17' => __( 'Bafing Region', 'lifterlms' ),
		'18' => __( 'Fromager', 'lifterlms' ),
		'19' => __( 'Moyen-Cavally', 'lifterlms' ),
		'AB' => __( 'Abidjan', 'lifterlms' ),
		'BS' => __( 'Bas-Sassandra District', 'lifterlms' ),
		'09' => __( 'Bas-Sassandra Region', 'lifterlms' ),
		'CM' => __( 'Comoé District', 'lifterlms' ),
		'DN' => __( 'Denguélé District', 'lifterlms' ),
		'06' => __( 'Dix-Huit Montagnes', 'lifterlms' ),
		'GD' => __( 'Gôh-Djiboua District', 'lifterlms' ),
		'02' => __( 'Haut-Sassandra', 'lifterlms' ),
		'LC' => __( 'Lacs District', 'lifterlms' ),
		'07' => __( 'Lacs Region', 'lifterlms' ),
		'LG' => __( 'Lagunes District', 'lifterlms' ),
		'01' => __( 'Lagunes region', 'lifterlms' ),
		'MG' => __( 'Montagnes District', 'lifterlms' ),
		'05' => __( 'Moyen-Comoé', 'lifterlms' ),
		'SM' => __( 'Sassandra-Marahoué District', 'lifterlms' ),
		'03' => __( 'Savanes Region', 'lifterlms' ),
		'VB' => __( 'Vallée du Bandama District', 'lifterlms' ),
		'04' => __( 'Vallée du Bandama Region', 'lifterlms' ),
		'WR' => __( 'Woroba District', 'lifterlms' ),
		'YM' => __( 'Yamoussoukro', 'lifterlms' ),
		'ZZ' => __( 'Zanzan Region', 'lifterlms' ),
	),
	'CK' => array(),
	'CL' => array(
		'AN' => __( 'Antofagasta Region', 'lifterlms' ),
		'AR' => __( 'Araucanía Region', 'lifterlms' ),
		'AP' => __( 'Arica y Parinacota Region', 'lifterlms' ),
		'AT' => __( 'Atacama Region', 'lifterlms' ),
		'AI' => __( 'Aysén Region', 'lifterlms' ),
		'BI' => __( 'Bío Bío Region', 'lifterlms' ),
		'CO' => __( 'Coquimbo Region', 'lifterlms' ),
		'LL' => __( 'Los Lagos Region', 'lifterlms' ),
		'LR' => __( 'Los Ríos Region', 'lifterlms' ),
		'MA' => __( 'Magellan and the Chilean Antarctic Region', 'lifterlms' ),
		'ML' => __( 'Maule Region', 'lifterlms' ),
		'LI' => __( 'O\'Higgins', 'lifterlms' ),
		'RM' => __( 'Santiago Metropolitan Region', 'lifterlms' ),
		'TA' => __( 'Tarapacá Region', 'lifterlms' ),
		'VS' => __( 'Valparaíso', 'lifterlms' ),
		'NB' => __( 'Ñuble Region', 'lifterlms' ),
	),
	'CM' => array(
		'AD' => __( 'Adamawa', 'lifterlms' ),
		'CE' => __( 'Centre', 'lifterlms' ),
		'ES' => __( 'East', 'lifterlms' ),
		'EN' => __( 'Far North', 'lifterlms' ),
		'LT' => __( 'Littoral', 'lifterlms' ),
		'NO' => __( 'North', 'lifterlms' ),
		'NW' => __( 'Northwest', 'lifterlms' ),
		'SU' => __( 'South', 'lifterlms' ),
		'SW' => __( 'Southwest', 'lifterlms' ),
		'OU' => __( 'West', 'lifterlms' ),
	),
	'CN' => array(
		'AH'     => __( 'Anhui', 'lifterlms' ),
		'BJ'     => __( 'Beijing', 'lifterlms' ),
		'CQ'     => __( 'Chongqing', 'lifterlms' ),
		'FJ'     => __( 'Fujian', 'lifterlms' ),
		'GS'     => __( 'Gansu', 'lifterlms' ),
		'GD'     => __( 'Guangdong', 'lifterlms' ),
		'GX'     => __( 'Guangxi Zhuang Autonomous Region', 'lifterlms' ),
		'GZ'     => __( 'Guizhou', 'lifterlms' ),
		'HI'     => __( 'Hainan', 'lifterlms' ),
		'HE'     => __( 'Hebei', 'lifterlms' ),
		'HL'     => __( 'Heilongjiang', 'lifterlms' ),
		'HA'     => __( 'Henan', 'lifterlms' ),
		'HK'     => __( 'Hong Kong', 'lifterlms' ),
		'HB'     => __( 'Hubei', 'lifterlms' ),
		'HN'     => __( 'Hunan', 'lifterlms' ),
		'NM'     => __( 'Inner Mongolia', 'lifterlms' ),
		'JS'     => __( 'Jiangsu', 'lifterlms' ),
		'JX'     => __( 'Jiangxi', 'lifterlms' ),
		'JL'     => __( 'Jilin', 'lifterlms' ),
		'TW-KEE' => __( 'Keelung', 'lifterlms' ),
		'LN'     => __( 'Liaoning', 'lifterlms' ),
		'MO'     => __( 'Macau', 'lifterlms' ),
		'NX'     => __( 'Ningxia Hui Autonomous Region', 'lifterlms' ),
		'QH'     => __( 'Qinghai', 'lifterlms' ),
		'SN'     => __( 'Shaanxi', 'lifterlms' ),
		'SD'     => __( 'Shandong', 'lifterlms' ),
		'SH'     => __( 'Shanghai', 'lifterlms' ),
		'SX'     => __( 'Shanxi', 'lifterlms' ),
		'SC'     => __( 'Sichuan', 'lifterlms' ),
		'TW'     => __( 'Taiwan Province, People\'s Republic of China', 'lifterlms' ),
		'XZ'     => __( 'Tibet Autonomous Region', 'lifterlms' ),
		'XJ'     => __( 'Xinjiang', 'lifterlms' ),
		'YN'     => __( 'Yunnan', 'lifterlms' ),
		'ZJ'     => __( 'Zhejiang', 'lifterlms' ),
	),
	'CO' => array(
		'AMA' => __( 'Amazonas Department', 'lifterlms' ),
		'ANT' => __( 'Antioquia Department', 'lifterlms' ),
		'ARA' => __( 'Arauca Department', 'lifterlms' ),
		'SAP' => __( 'Archipelago of Saint Andréws, Providence and Saint Catalina', 'lifterlms' ),
		'ATL' => __( 'Atlántico Department', 'lifterlms' ),
		'BOL' => __( 'Bolívar Department', 'lifterlms' ),
		'BOY' => __( 'Boyacá Department', 'lifterlms' ),
		'CAL' => __( 'Caldas Department', 'lifterlms' ),
		'CAQ' => __( 'Caquetá Department', 'lifterlms' ),
		'CAS' => __( 'Casanare Department', 'lifterlms' ),
		'CAU' => __( 'Cauca Department', 'lifterlms' ),
		'CES' => __( 'Cesar Department', 'lifterlms' ),
		'CHO' => __( 'Chocó Department', 'lifterlms' ),
		'CUN' => __( 'Cundinamarca Department', 'lifterlms' ),
		'COR' => __( 'Córdoba Department', 'lifterlms' ),
		'GUA' => __( 'Guainía Department', 'lifterlms' ),
		'GUV' => __( 'Guaviare Department', 'lifterlms' ),
		'HUI' => __( 'Huila Department', 'lifterlms' ),
		'LAG' => __( 'La Guajira Department', 'lifterlms' ),
		'MAG' => __( 'Magdalena Department', 'lifterlms' ),
		'MET' => __( 'Meta', 'lifterlms' ),
		'NAR' => __( 'Nariño Department', 'lifterlms' ),
		'NSA' => __( 'Norte de Santander Department', 'lifterlms' ),
		'PUT' => __( 'Putumayo Department', 'lifterlms' ),
		'QUI' => __( 'Quindío Department', 'lifterlms' ),
		'RIS' => __( 'Risaralda Department', 'lifterlms' ),
		'SAN' => __( 'Santander Department', 'lifterlms' ),
		'SUC' => __( 'Sucre Department', 'lifterlms' ),
		'TOL' => __( 'Tolima Department', 'lifterlms' ),
		'VAC' => __( 'Valle del Cauca Department', 'lifterlms' ),
		'VAU' => __( 'Vaupés Department', 'lifterlms' ),
		'VID' => __( 'Vichada Department', 'lifterlms' ),
	),
	'CR' => array(
		'A'  => __( 'Alajuela Province', 'lifterlms' ),
		'G'  => __( 'Guanacaste Province', 'lifterlms' ),
		'H'  => __( 'Heredia Province', 'lifterlms' ),
		'L'  => __( 'Limón Province', 'lifterlms' ),
		'C'  => __( 'Provincia de Cartago', 'lifterlms' ),
		'P'  => __( 'Puntarenas Province', 'lifterlms' ),
		'SJ' => __( 'San José Province', 'lifterlms' ),
	),
	'CU' => array(
		'10' => __( 'Las Tunas Province', 'lifterlms' ),
		'11' => __( 'Holguín Province', 'lifterlms' ),
		'12' => __( 'Granma Province', 'lifterlms' ),
		'13' => __( 'Santiago de Cuba Province', 'lifterlms' ),
		'14' => __( 'Guantánamo Province', 'lifterlms' ),
		'15' => __( 'Artemisa Province', 'lifterlms' ),
		'16' => __( 'Mayabeque Province', 'lifterlms' ),
		'99' => __( 'Isla de la Juventud', 'lifterlms' ),
		'09' => __( 'Camagüey Province', 'lifterlms' ),
		'08' => __( 'Ciego de Ávila Province', 'lifterlms' ),
		'06' => __( 'Cienfuegos Province', 'lifterlms' ),
		'03' => __( 'Havana Province', 'lifterlms' ),
		'04' => __( 'Matanzas Province', 'lifterlms' ),
		'01' => __( 'Pinar del Río Province', 'lifterlms' ),
		'07' => __( 'Sancti Spíritus Province', 'lifterlms' ),
		'05' => __( 'Villa Clara Province', 'lifterlms' ),
	),
	'CV' => array(
		'B'  => __( 'Barlavento Islands', 'lifterlms' ),
		'BV' => __( 'Boa Vista', 'lifterlms' ),
		'BR' => __( 'Brava', 'lifterlms' ),
		'MA' => __( 'Maio Municipality', 'lifterlms' ),
		'MO' => __( 'Mosteiros', 'lifterlms' ),
		'PA' => __( 'Paul', 'lifterlms' ),
		'PN' => __( 'Porto Novo', 'lifterlms' ),
		'PR' => __( 'Praia', 'lifterlms' ),
		'RB' => __( 'Ribeira Brava Municipality', 'lifterlms' ),
		'RG' => __( 'Ribeira Grande', 'lifterlms' ),
		'RS' => __( 'Ribeira Grande de Santiago', 'lifterlms' ),
		'SL' => __( 'Sal', 'lifterlms' ),
		'CA' => __( 'Santa Catarina', 'lifterlms' ),
		'CF' => __( 'Santa Catarina do Fogo', 'lifterlms' ),
		'CR' => __( 'Santa Cruz', 'lifterlms' ),
		'S'  => __( 'Sotavento Islands', 'lifterlms' ),
		'SD' => __( 'São Domingos', 'lifterlms' ),
		'SF' => __( 'São Filipe', 'lifterlms' ),
		'SO' => __( 'São Lourenço dos Órgãos', 'lifterlms' ),
		'SM' => __( 'São Miguel', 'lifterlms' ),
		'SV' => __( 'São Vicente', 'lifterlms' ),
		'TA' => __( 'Tarrafal', 'lifterlms' ),
		'TS' => __( 'Tarrafal de São Nicolau', 'lifterlms' ),
	),
	'CW' => array(),
	'CX' => array(),
	'CY' => array(
		'04' => __( 'Famagusta District', 'lifterlms' ),
		'06' => __( 'Kyrenia District', 'lifterlms' ),
		'03' => __( 'Larnaca District', 'lifterlms' ),
		'02' => __( 'Limassol District', 'lifterlms' ),
		'01' => __( 'Nicosia District', 'lifterlms' ),
		'05' => __( 'Paphos District', 'lifterlms' ),
	),
	'CZ' => array(
		'10'  => __( 'Prague', 'lifterlms' ),
		'20'  => __( 'Central Bohemian Region', 'lifterlms' ),
		'31'  => __( 'South Bohemian Region', 'lifterlms' ),
		'32'  => __( 'Plzeň Region', 'lifterlms' ),
		'41'  => __( 'Karlovy Vary Region', 'lifterlms' ),
		'42'  => __( 'Ústí nad Labem Region', 'lifterlms' ),
		'51'  => __( 'Liberec Region', 'lifterlms' ),
		'52'  => __( 'Hradec Králové Region', 'lifterlms' ),
		'53'  => __( 'Pardubice Region', 'lifterlms' ),
		'63'  => __( 'Vysočina Region', 'lifterlms' ),
		'64'  => __( 'South Moravian Region', 'lifterlms' ),
		'71'  => __( 'Olomouc Region', 'lifterlms' ),
		'72'  => __( 'Zlín Region', 'lifterlms' ),
		'80'  => __( 'Moravian-Silesian Region', 'lifterlms' ),
		'101' => __( 'Prague 1', 'lifterlms' ),
		'102' => __( 'Prague 2', 'lifterlms' ),
		'103' => __( 'Prague 3', 'lifterlms' ),
		'104' => __( 'Prague 4', 'lifterlms' ),
		'105' => __( 'Prague 5', 'lifterlms' ),
		'106' => __( 'Prague 6', 'lifterlms' ),
		'107' => __( 'Prague 7', 'lifterlms' ),
		'108' => __( 'Prague 8', 'lifterlms' ),
		'109' => __( 'Prague 9', 'lifterlms' ),
		'110' => __( 'Prague 10', 'lifterlms' ),
		'111' => __( 'Prague 11', 'lifterlms' ),
		'112' => __( 'Prague 12', 'lifterlms' ),
		'113' => __( 'Prague 13', 'lifterlms' ),
		'114' => __( 'Prague 14', 'lifterlms' ),
		'115' => __( 'Prague 15', 'lifterlms' ),
		'116' => __( 'Prague 16', 'lifterlms' ),
		'120' => __( 'Horní Počernice', 'lifterlms' ),
		'121' => __( 'Prague 21', 'lifterlms' ),
		'201' => __( 'Benešov District', 'lifterlms' ),
		'202' => __( 'Beroun District', 'lifterlms' ),
		'203' => __( 'Kladno District', 'lifterlms' ),
		'204' => __( 'Kolín District', 'lifterlms' ),
		'206' => __( 'Mělník District', 'lifterlms' ),
		'207' => __( 'Mladá Boleslav District', 'lifterlms' ),
		'208' => __( 'Nymburk District', 'lifterlms' ),
		'209' => __( 'Prague-East District', 'lifterlms' ),
		'311' => __( 'České Budějovice District', 'lifterlms' ),
		'312' => __( 'Český Krumlov District', 'lifterlms' ),
		'313' => __( 'Jindřichův Hradec District', 'lifterlms' ),
		'314' => __( 'Písek District', 'lifterlms' ),
		'315' => __( 'Prachatice District', 'lifterlms' ),
		'316' => __( 'Strakonice District', 'lifterlms' ),
		'317' => __( 'Tábor District', 'lifterlms' ),
		'321' => __( 'Domažlice District', 'lifterlms' ),
		'322' => __( 'Klatovy District', 'lifterlms' ),
		'323' => __( 'Plzeň-City District', 'lifterlms' ),
		'324' => __( 'Plzeň-South District', 'lifterlms' ),
		'325' => __( 'Plzeň-North District', 'lifterlms' ),
		'326' => __( 'Rokycany District', 'lifterlms' ),
		'327' => __( 'Tachov District', 'lifterlms' ),
		'411' => __( 'Cheb District', 'lifterlms' ),
		'412' => __( 'Karlovy Vary District', 'lifterlms' ),
		'413' => __( 'Sokolov District', 'lifterlms' ),
		'421' => __( 'Děčín District', 'lifterlms' ),
		'422' => __( 'Chomutov District', 'lifterlms' ),
		'423' => __( 'Litoměřice District', 'lifterlms' ),
		'424' => __( 'Louny District', 'lifterlms' ),
		'425' => __( 'Most District', 'lifterlms' ),
		'426' => __( 'Teplice District', 'lifterlms' ),
		'427' => __( 'Ústí nad Labem District', 'lifterlms' ),
		'511' => __( 'Česká Lípa District', 'lifterlms' ),
		'512' => __( 'Jablonec nad Nisou District', 'lifterlms' ),
		'513' => __( 'Liberec District', 'lifterlms' ),
		'514' => __( 'Semily District', 'lifterlms' ),
		'521' => __( 'Hradec Králové District', 'lifterlms' ),
		'522' => __( 'Jičín District', 'lifterlms' ),
		'523' => __( 'Náchod District', 'lifterlms' ),
		'524' => __( 'Rychnov nad Kněžnou District', 'lifterlms' ),
		'525' => __( 'Trutnov District', 'lifterlms' ),
		'531' => __( 'Chrudim District', 'lifterlms' ),
		'532' => __( 'Pardubice District', 'lifterlms' ),
		'533' => __( 'Svitavy District', 'lifterlms' ),
		'534' => __( 'Ústí nad Orlicí District', 'lifterlms' ),
		'631' => __( 'Havlíčkův Brod District', 'lifterlms' ),
		'632' => __( 'Jihlava District', 'lifterlms' ),
		'633' => __( 'Pelhřimov District', 'lifterlms' ),
		'634' => __( 'Třebíč District', 'lifterlms' ),
		'635' => __( 'Žďár nad Sázavou District', 'lifterlms' ),
		'641' => __( 'Blansko District', 'lifterlms' ),
		'642' => __( 'Brno-City District', 'lifterlms' ),
		'643' => __( 'Brno-Country District', 'lifterlms' ),
		'644' => __( 'Břeclav District', 'lifterlms' ),
		'645' => __( 'Hodonín District', 'lifterlms' ),
		'646' => __( 'Vyškov District', 'lifterlms' ),
		'647' => __( 'Znojmo District', 'lifterlms' ),
		'711' => __( 'Jeseník District', 'lifterlms' ),
		'712' => __( 'Olomouc District', 'lifterlms' ),
		'713' => __( 'Prostějov District', 'lifterlms' ),
		'714' => __( 'Přerov District', 'lifterlms' ),
		'715' => __( 'Šumperk District', 'lifterlms' ),
		'721' => __( 'Kroměříž District', 'lifterlms' ),
		'722' => __( 'Uherské Hradiště District', 'lifterlms' ),
		'723' => __( 'Vsetín District', 'lifterlms' ),
		'724' => __( 'Zlín District', 'lifterlms' ),
		'801' => __( 'Bruntál District', 'lifterlms' ),
		'802' => __( 'Frýdek-Místek District', 'lifterlms' ),
		'803' => __( 'Karviná District', 'lifterlms' ),
		'804' => __( 'Nový Jičín District', 'lifterlms' ),
		'805' => __( 'Opava District', 'lifterlms' ),
		'806' => __( 'Ostrava-City District', 'lifterlms' ),
		'20A' => __( 'Prague-West District', 'lifterlms' ),
		'20B' => __( 'Příbram District', 'lifterlms' ),
		'20C' => __( 'Rakovník District', 'lifterlms' ),
	),
	'DE' => array(
		'BW' => __( 'Baden-Württemberg', 'lifterlms' ),
		'BY' => __( 'Bavaria', 'lifterlms' ),
		'BE' => __( 'Berlin', 'lifterlms' ),
		'BB' => __( 'Brandenburg', 'lifterlms' ),
		'HB' => __( 'Bremen', 'lifterlms' ),
		'HH' => __( 'Hamburg', 'lifterlms' ),
		'HE' => __( 'Hesse', 'lifterlms' ),
		'NI' => __( 'Lower Saxony', 'lifterlms' ),
		'MV' => __( 'Mecklenburg-Vorpommern', 'lifterlms' ),
		'NW' => __( 'North Rhine-Westphalia', 'lifterlms' ),
		'RP' => __( 'Rhineland-Palatinate', 'lifterlms' ),
		'SL' => __( 'Saarland', 'lifterlms' ),
		'SN' => __( 'Saxony', 'lifterlms' ),
		'ST' => __( 'Saxony-Anhalt', 'lifterlms' ),
		'SH' => __( 'Schleswig-Holstein', 'lifterlms' ),
		'TH' => __( 'Thuringia', 'lifterlms' ),
	),
	'DJ' => array(
		'AS' => __( 'Ali Sabieh Region', 'lifterlms' ),
		'AR' => __( 'Arta Region', 'lifterlms' ),
		'DI' => __( 'Dikhil Region', 'lifterlms' ),
		'DJ' => __( 'Djibouti', 'lifterlms' ),
		'OB' => __( 'Obock Region', 'lifterlms' ),
		'TA' => __( 'Tadjourah Region', 'lifterlms' ),
	),
	'DK' => array(
		'81' => __( 'North Denmark Region', 'lifterlms' ),
		'82' => __( 'Central Denmark Region', 'lifterlms' ),
		'83' => __( 'Region of Southern Denmark', 'lifterlms' ),
		'84' => __( 'Capital Region of Denmark', 'lifterlms' ),
		'85' => __( 'Region Zealand', 'lifterlms' ),
	),
	'DM' => array(
		'10' => __( 'Saint Paul Parish', 'lifterlms' ),
		'11' => __( 'Saint Peter Parish', 'lifterlms' ),
		'02' => __( 'Saint Andrew Parish', 'lifterlms' ),
		'03' => __( 'Saint David Parish', 'lifterlms' ),
		'04' => __( 'Saint George Parish', 'lifterlms' ),
		'05' => __( 'Saint John Parish', 'lifterlms' ),
		'06' => __( 'Saint Joseph Parish', 'lifterlms' ),
		'07' => __( 'Saint Luke Parish', 'lifterlms' ),
		'08' => __( 'Saint Mark Parish', 'lifterlms' ),
		'09' => __( 'Saint Patrick Parish', 'lifterlms' ),
	),
	'DO' => array(
		'10' => __( 'Independencia', 'lifterlms' ),
		'11' => __( 'La Altagracia Province', 'lifterlms' ),
		'12' => __( 'La Romana Province', 'lifterlms' ),
		'13' => __( 'La Vega Province', 'lifterlms' ),
		'14' => __( 'María Trinidad Sánchez Province', 'lifterlms' ),
		'15' => __( 'Monte Cristi Province', 'lifterlms' ),
		'16' => __( 'Pedernales Province', 'lifterlms' ),
		'17' => __( 'Peravia Province', 'lifterlms' ),
		'18' => __( 'Puerto Plata Province', 'lifterlms' ),
		'19' => __( 'Hermanas Mirabal Province', 'lifterlms' ),
		'20' => __( 'Samaná Province', 'lifterlms' ),
		'21' => __( 'San Cristóbal Province', 'lifterlms' ),
		'22' => __( 'San Juan Province', 'lifterlms' ),
		'23' => __( 'San Pedro de Macorís', 'lifterlms' ),
		'24' => __( 'Sánchez Ramírez Province', 'lifterlms' ),
		'25' => __( 'Santiago Province', 'lifterlms' ),
		'26' => __( 'Santiago Rodríguez Province', 'lifterlms' ),
		'27' => __( 'Valverde Province', 'lifterlms' ),
		'28' => __( 'Monseñor Nouel Province', 'lifterlms' ),
		'29' => __( 'Monte Plata Province', 'lifterlms' ),
		'30' => __( 'Hato Mayor Province', 'lifterlms' ),
		'31' => __( 'San José de Ocoa Province', 'lifterlms' ),
		'32' => __( 'Santo Domingo Province', 'lifterlms' ),
		'02' => __( 'Azua Province', 'lifterlms' ),
		'03' => __( 'Baoruco Province', 'lifterlms' ),
		'04' => __( 'Barahona Province', 'lifterlms' ),
		'05' => __( 'Dajabón Province', 'lifterlms' ),
		'01' => __( 'Distrito Nacional', 'lifterlms' ),
		'06' => __( 'Duarte Province', 'lifterlms' ),
		'08' => __( 'El Seibo Province', 'lifterlms' ),
		'09' => __( 'Espaillat Province', 'lifterlms' ),
	),
	'DZ' => array(
		'10' => __( 'Bouïra', 'lifterlms' ),
		'11' => __( 'Tamanghasset', 'lifterlms' ),
		'12' => __( 'Tébessa', 'lifterlms' ),
		'13' => __( 'Tlemcen', 'lifterlms' ),
		'14' => __( 'Tiaret', 'lifterlms' ),
		'15' => __( 'Tizi Ouzou', 'lifterlms' ),
		'16' => __( 'Algiers', 'lifterlms' ),
		'17' => __( 'Djelfa', 'lifterlms' ),
		'18' => __( 'Jijel', 'lifterlms' ),
		'19' => __( 'Sétif', 'lifterlms' ),
		'20' => __( 'Saïda', 'lifterlms' ),
		'21' => __( 'Skikda', 'lifterlms' ),
		'22' => __( 'Sidi Bel Abbès', 'lifterlms' ),
		'23' => __( 'Annaba', 'lifterlms' ),
		'24' => __( 'Guelma', 'lifterlms' ),
		'25' => __( 'Constantine', 'lifterlms' ),
		'26' => __( 'Médéa', 'lifterlms' ),
		'27' => __( 'Mostaganem', 'lifterlms' ),
		'28' => __( 'M\'Sila', 'lifterlms' ),
		'29' => __( 'Mascara', 'lifterlms' ),
		'30' => __( 'Ouargla', 'lifterlms' ),
		'31' => __( 'Oran', 'lifterlms' ),
		'32' => __( 'El Bayadh', 'lifterlms' ),
		'33' => __( 'Illizi', 'lifterlms' ),
		'34' => __( 'Bordj Bou Arréridj', 'lifterlms' ),
		'35' => __( 'Boumerdès', 'lifterlms' ),
		'36' => __( 'El Tarf', 'lifterlms' ),
		'37' => __( 'Tindouf', 'lifterlms' ),
		'38' => __( 'Tissemsilt', 'lifterlms' ),
		'39' => __( 'El Oued', 'lifterlms' ),
		'40' => __( 'Khenchela', 'lifterlms' ),
		'41' => __( 'Souk Ahras', 'lifterlms' ),
		'42' => __( 'Tipasa', 'lifterlms' ),
		'43' => __( 'Mila', 'lifterlms' ),
		'44' => __( 'Aïn Defla', 'lifterlms' ),
		'45' => __( 'Naama', 'lifterlms' ),
		'46' => __( 'Aïn Témouchent', 'lifterlms' ),
		'47' => __( 'Ghardaïa', 'lifterlms' ),
		'48' => __( 'Relizane', 'lifterlms' ),
		'49' => __( 'El M\'ghair', 'lifterlms' ),
		'50' => __( 'El Menia', 'lifterlms' ),
		'51' => __( 'Ouled Djellal', 'lifterlms' ),
		'52' => __( 'Bordj Baji Mokhtar', 'lifterlms' ),
		'53' => __( 'Béni Abbès', 'lifterlms' ),
		'54' => __( 'Timimoun', 'lifterlms' ),
		'55' => __( 'Touggourt', 'lifterlms' ),
		'56' => __( 'Djanet', 'lifterlms' ),
		'57' => __( 'In Salah', 'lifterlms' ),
		'58' => __( 'In Guezzam', 'lifterlms' ),
		'01' => __( 'Adrar', 'lifterlms' ),
		'05' => __( 'Batna', 'lifterlms' ),
		'07' => __( 'Biskra', 'lifterlms' ),
		'09' => __( 'Blida', 'lifterlms' ),
		'08' => __( 'Béchar', 'lifterlms' ),
		'06' => __( 'Béjaïa', 'lifterlms' ),
		'02' => __( 'Chlef', 'lifterlms' ),
		'03' => __( 'Laghouat', 'lifterlms' ),
		'04' => __( 'Oum El Bouaghi', 'lifterlms' ),
	),
	'EC' => array(
		'A'  => __( 'Azuay Province', 'lifterlms' ),
		'B'  => __( 'Bolívar Province', 'lifterlms' ),
		'C'  => __( 'Carchi Province', 'lifterlms' ),
		'F'  => __( 'Cañar Province', 'lifterlms' ),
		'H'  => __( 'Chimborazo Province', 'lifterlms' ),
		'X'  => __( 'Cotopaxi Province', 'lifterlms' ),
		'O'  => __( 'El Oro Province', 'lifterlms' ),
		'E'  => __( 'Esmeraldas', 'lifterlms' ),
		'W'  => __( 'Galápagos Province', 'lifterlms' ),
		'G'  => __( 'Guayas Province', 'lifterlms' ),
		'I'  => __( 'Imbabura Province', 'lifterlms' ),
		'R'  => __( 'Los Ríos Province', 'lifterlms' ),
		'M'  => __( 'Manabí Province', 'lifterlms' ),
		'S'  => __( 'Morona-Santiago Province', 'lifterlms' ),
		'N'  => __( 'Napo Province', 'lifterlms' ),
		'D'  => __( 'Orellana Province', 'lifterlms' ),
		'Y'  => __( 'Pastaza Province', 'lifterlms' ),
		'P'  => __( 'Pichincha Province', 'lifterlms' ),
		'SE' => __( 'Santa Elena Province', 'lifterlms' ),
		'SD' => __( 'Santo Domingo de los Tsáchilas Province', 'lifterlms' ),
		'U'  => __( 'Sucumbíos Province', 'lifterlms' ),
		'T'  => __( 'Tungurahua Province', 'lifterlms' ),
		'Z'  => __( 'Zamora-Chinchipe Province', 'lifterlms' ),
	),
	'EE' => array(
		'37' => __( 'Harju County', 'lifterlms' ),
		'39' => __( 'Hiiu County', 'lifterlms' ),
		'44' => __( 'Ida-Viru County', 'lifterlms' ),
		'49' => __( 'Jõgeva County', 'lifterlms' ),
		'51' => __( 'Järva County', 'lifterlms' ),
		'57' => __( 'Lääne County', 'lifterlms' ),
		'59' => __( 'Lääne-Viru County', 'lifterlms' ),
		'65' => __( 'Põlva County', 'lifterlms' ),
		'67' => __( 'Pärnu County', 'lifterlms' ),
		'70' => __( 'Rapla County', 'lifterlms' ),
		'74' => __( 'Saare County', 'lifterlms' ),
		'78' => __( 'Tartu County', 'lifterlms' ),
		'82' => __( 'Valga County', 'lifterlms' ),
		'84' => __( 'Viljandi County', 'lifterlms' ),
		'86' => __( 'Võru County', 'lifterlms' ),
	),
	'EG' => array(
		'ALX' => __( 'Alexandria Governorate', 'lifterlms' ),
		'ASN' => __( 'Aswan Governorate', 'lifterlms' ),
		'AST' => __( 'Asyut Governorate', 'lifterlms' ),
		'BH'  => __( 'Beheira Governorate', 'lifterlms' ),
		'BNS' => __( 'Beni Suef Governorate', 'lifterlms' ),
		'C'   => __( 'Cairo Governorate', 'lifterlms' ),
		'DK'  => __( 'Dakahlia Governorate', 'lifterlms' ),
		'DT'  => __( 'Damietta Governorate', 'lifterlms' ),
		'FYM' => __( 'Faiyum Governorate', 'lifterlms' ),
		'GH'  => __( 'Gharbia Governorate', 'lifterlms' ),
		'GZ'  => __( 'Giza Governorate', 'lifterlms' ),
		'IS'  => __( 'Ismailia Governorate', 'lifterlms' ),
		'KFS' => __( 'Kafr el-Sheikh Governorate', 'lifterlms' ),
		'LX'  => __( 'Luxor Governorate', 'lifterlms' ),
		'MT'  => __( 'Matrouh Governorate', 'lifterlms' ),
		'MN'  => __( 'Minya Governorate', 'lifterlms' ),
		'MNF' => __( 'Monufia Governorate', 'lifterlms' ),
		'WAD' => __( 'New Valley Governorate', 'lifterlms' ),
		'SIN' => __( 'North Sinai Governorate', 'lifterlms' ),
		'PTS' => __( 'Port Said Governorate', 'lifterlms' ),
		'KB'  => __( 'Qalyubia Governorate', 'lifterlms' ),
		'KN'  => __( 'Qena Governorate', 'lifterlms' ),
		'BA'  => __( 'Red Sea Governorate', 'lifterlms' ),
		'SHG' => __( 'Sohag Governorate', 'lifterlms' ),
		'JS'  => __( 'South Sinai Governorate', 'lifterlms' ),
		'SUZ' => __( 'Suez Governorate', 'lifterlms' ),
	),
	'EH' => array(),
	'ER' => array(
		'AN' => __( 'Anseba Region', 'lifterlms' ),
		'DU' => __( 'Debub Region', 'lifterlms' ),
		'GB' => __( 'Gash-Barka Region', 'lifterlms' ),
		'MA' => __( 'Maekel Region', 'lifterlms' ),
		'SK' => __( 'Northern Red Sea Region', 'lifterlms' ),
		'DK' => __( 'Southern Red Sea Region', 'lifterlms' ),
	),
	'ES' => array(
		'AN' => __( 'Andalusia', 'lifterlms' ),
		'AR' => __( 'Aragon', 'lifterlms' ),
		'AS' => __( 'Asturias', 'lifterlms' ),
		'PM' => __( 'Balearic Islands', 'lifterlms' ),
		'PV' => __( 'Basque Country', 'lifterlms' ),
		'BU' => __( 'Burgos Province', 'lifterlms' ),
		'CN' => __( 'Canary Islands', 'lifterlms' ),
		'CB' => __( 'Cantabria', 'lifterlms' ),
		'CL' => __( 'Castile and León', 'lifterlms' ),
		'CM' => __( 'Castilla La Mancha', 'lifterlms' ),
		'CT' => __( 'Catalonia', 'lifterlms' ),
		'CE' => __( 'Ceuta', 'lifterlms' ),
		'EX' => __( 'Extremadura', 'lifterlms' ),
		'GA' => __( 'Galicia', 'lifterlms' ),
		'RI' => __( 'La Rioja', 'lifterlms' ),
		'LE' => __( 'Léon', 'lifterlms' ),
		'MD' => __( 'Madrid', 'lifterlms' ),
		'ML' => __( 'Melilla', 'lifterlms' ),
		'MC' => __( 'Murcia', 'lifterlms' ),
		'NC' => __( 'Navarra', 'lifterlms' ),
		'P'  => __( 'Palencia Province', 'lifterlms' ),
		'SA' => __( 'Salamanca Province', 'lifterlms' ),
		'SG' => __( 'Segovia Province', 'lifterlms' ),
		'SO' => __( 'Soria Province', 'lifterlms' ),
		'VC' => __( 'Valencia', 'lifterlms' ),
		'VA' => __( 'Valladolid Province', 'lifterlms' ),
		'ZA' => __( 'Zamora Province', 'lifterlms' ),
		'AV' => __( 'Ávila', 'lifterlms' ),
	),
	'ET' => array(
		'AA' => __( 'Addis Ababa', 'lifterlms' ),
		'AF' => __( 'Afar Region', 'lifterlms' ),
		'AM' => __( 'Amhara Region', 'lifterlms' ),
		'BE' => __( 'Benishangul-Gumuz Region', 'lifterlms' ),
		'DD' => __( 'Dire Dawa', 'lifterlms' ),
		'GA' => __( 'Gambela Region', 'lifterlms' ),
		'HA' => __( 'Harari Region', 'lifterlms' ),
		'OR' => __( 'Oromia Region', 'lifterlms' ),
		'SO' => __( 'Somali Region', 'lifterlms' ),
		'SN' => __( 'Southern Nations, Nationalities, and Peoples\' Region', 'lifterlms' ),
		'TI' => __( 'Tigray Region', 'lifterlms' ),
	),
	'FI' => array(
		'11' => __( 'Pirkanmaa', 'lifterlms' ),
		'12' => __( 'Ostrobothnia', 'lifterlms' ),
		'13' => __( 'North Karelia', 'lifterlms' ),
		'14' => __( 'Northern Ostrobothnia', 'lifterlms' ),
		'15' => __( 'Northern Savonia', 'lifterlms' ),
		'16' => __( 'Päijänne Tavastia', 'lifterlms' ),
		'17' => __( 'Satakunta', 'lifterlms' ),
		'18' => __( 'Uusimaa', 'lifterlms' ),
		'19' => __( 'Finland Proper', 'lifterlms' ),
		'08' => __( 'Central Finland', 'lifterlms' ),
		'07' => __( 'Central Ostrobothnia', 'lifterlms' ),
		'IS' => __( 'Eastern Finland Province', 'lifterlms' ),
		'05' => __( 'Kainuu', 'lifterlms' ),
		'09' => __( 'Kymenlaakso', 'lifterlms' ),
		'LL' => __( 'Lapland', 'lifterlms' ),
		'OL' => __( 'Oulu Province', 'lifterlms' ),
		'02' => __( 'South Karelia', 'lifterlms' ),
		'03' => __( 'Southern Ostrobothnia', 'lifterlms' ),
		'04' => __( 'Southern Savonia', 'lifterlms' ),
		'06' => __( 'Tavastia Proper', 'lifterlms' ),
		'01' => __( 'Åland Islands', 'lifterlms' ),
	),
	'FJ' => array(
		'10' => __( 'Namosi', 'lifterlms' ),
		'11' => __( 'Ra', 'lifterlms' ),
		'12' => __( 'Rewa', 'lifterlms' ),
		'13' => __( 'Serua', 'lifterlms' ),
		'14' => __( 'Tailevu', 'lifterlms' ),
		'01' => __( 'Ba', 'lifterlms' ),
		'02' => __( 'Bua', 'lifterlms' ),
		'03' => __( 'Cakaudrove', 'lifterlms' ),
		'C'  => __( 'Central Division', 'lifterlms' ),
		'E'  => __( 'Eastern Division', 'lifterlms' ),
		'04' => __( 'Kadavu', 'lifterlms' ),
		'05' => __( 'Lau', 'lifterlms' ),
		'06' => __( 'Lomaiviti', 'lifterlms' ),
		'07' => __( 'Macuata', 'lifterlms' ),
		'08' => __( 'Nadroga-Navosa', 'lifterlms' ),
		'09' => __( 'Naitasiri', 'lifterlms' ),
		'N'  => __( 'Northern Division', 'lifterlms' ),
		'R'  => __( 'Rotuma', 'lifterlms' ),
		'W'  => __( 'Western Division', 'lifterlms' ),
	),
	'FK' => array(),
	'FM' => array(
		'TRK' => __( 'Chuuk State', 'lifterlms' ),
		'KSA' => __( 'Kosrae State', 'lifterlms' ),
		'PNI' => __( 'Pohnpei State', 'lifterlms' ),
		'YAP' => __( 'Yap State', 'lifterlms' ),
	),
	'FO' => array(),
	'FR' => array(
		'75'    => __( 'Paris', 'lifterlms' ),
		'WF-AL' => __( 'Alo', 'lifterlms' ),
		'A'     => __( 'Alsace', 'lifterlms' ),
		'B'     => __( 'Aquitaine', 'lifterlms' ),
		'C'     => __( 'Auvergne', 'lifterlms' ),
		'ARA'   => __( 'Auvergne-Rhône-Alpes', 'lifterlms' ),
		'BFC'   => __( 'Bourgogne-Franche-Comté', 'lifterlms' ),
		'BRE'   => __( 'Brittany', 'lifterlms' ),
		'D'     => __( 'Burgundy', 'lifterlms' ),
		'CVL'   => __( 'Centre-Val de Loire', 'lifterlms' ),
		'G'     => __( 'Champagne-Ardenne', 'lifterlms' ),
		'COR'   => __( 'Corsica', 'lifterlms' ),
		'I'     => __( 'Franche-Comté', 'lifterlms' ),
		'GF'    => __( 'French Guiana', 'lifterlms' ),
		'PF'    => __( 'French Polynesia', 'lifterlms' ),
		'GES'   => __( 'Grand Est', 'lifterlms' ),
		'GP'    => __( 'Guadeloupe', 'lifterlms' ),
		'HDF'   => __( 'Hauts-de-France', 'lifterlms' ),
		'K'     => __( 'Languedoc-Roussillon', 'lifterlms' ),
		'L'     => __( 'Limousin', 'lifterlms' ),
		'M'     => __( 'Lorraine', 'lifterlms' ),
		'P'     => __( 'Lower Normandy', 'lifterlms' ),
		'MQ'    => __( 'Martinique', 'lifterlms' ),
		'YT'    => __( 'Mayotte', 'lifterlms' ),
		'O'     => __( 'Nord-Pas-de-Calais', 'lifterlms' ),
		'NOR'   => __( 'Normandy', 'lifterlms' ),
		'NAQ'   => __( 'Nouvelle-Aquitaine', 'lifterlms' ),
		'OCC'   => __( 'Occitania', 'lifterlms' ),
		'PDL'   => __( 'Pays de la Loire', 'lifterlms' ),
		'S'     => __( 'Picardy', 'lifterlms' ),
		'T'     => __( 'Poitou-Charentes', 'lifterlms' ),
		'PAC'   => __( 'Provence-Alpes-Côte d\'Azur', 'lifterlms' ),
		'V'     => __( 'Rhône-Alpes', 'lifterlms' ),
		'RE'    => __( 'Réunion', 'lifterlms' ),
		'BL'    => __( 'Saint Barthélemy', 'lifterlms' ),
		'MF'    => __( 'Saint Martin', 'lifterlms' ),
		'PM'    => __( 'Saint Pierre and Miquelon', 'lifterlms' ),
		'WF-SG' => __( 'Sigave', 'lifterlms' ),
		'Q'     => __( 'Upper Normandy', 'lifterlms' ),
		'WF-UV' => __( 'Uvea', 'lifterlms' ),
		'WF'    => __( 'Wallis and Futuna', 'lifterlms' ),
		'IDF'   => __( 'Île-de-France', 'lifterlms' ),
	),
	'GA' => array(
		'1' => __( 'Estuaire Province', 'lifterlms' ),
		'2' => __( 'Haut-Ogooué Province', 'lifterlms' ),
		'3' => __( 'Moyen-Ogooué Province', 'lifterlms' ),
		'4' => __( 'Ngounié Province', 'lifterlms' ),
		'5' => __( 'Nyanga Province', 'lifterlms' ),
		'6' => __( 'Ogooué-Ivindo Province', 'lifterlms' ),
		'7' => __( 'Ogooué-Lolo Province', 'lifterlms' ),
		'8' => __( 'Ogooué-Maritime Province', 'lifterlms' ),
		'9' => __( 'Woleu-Ntem Province', 'lifterlms' ),
	),
	'GB' => array(
		'ABE'   => __( 'Aberdeen', 'lifterlms' ),
		'ABD'   => __( 'Aberdeenshire', 'lifterlms' ),
		'ANS'   => __( 'Angus', 'lifterlms' ),
		'ANT'   => __( 'Antrim', 'lifterlms' ),
		'ANN'   => __( 'Antrim and Newtownabbey', 'lifterlms' ),
		'ARD'   => __( 'Ards', 'lifterlms' ),
		'AND'   => __( 'Ards and North Down', 'lifterlms' ),
		'AGB'   => __( 'Argyll and Bute', 'lifterlms' ),
		'ARM'   => __( 'Armagh City and District Council', 'lifterlms' ),
		'ABC'   => __( 'Armagh, Banbridge and Craigavon', 'lifterlms' ),
		'SH-AC' => __( 'Ascension Island', 'lifterlms' ),
		'BLA'   => __( 'Ballymena Borough', 'lifterlms' ),
		'BLY'   => __( 'Ballymoney', 'lifterlms' ),
		'BNB'   => __( 'Banbridge', 'lifterlms' ),
		'BNS'   => __( 'Barnsley', 'lifterlms' ),
		'BAS'   => __( 'Bath and North East Somerset', 'lifterlms' ),
		'BDF'   => __( 'Bedford', 'lifterlms' ),
		'BFS'   => __( 'Belfast district', 'lifterlms' ),
		'BIR'   => __( 'Birmingham', 'lifterlms' ),
		'BBD'   => __( 'Blackburn with Darwen', 'lifterlms' ),
		'BPL'   => __( 'Blackpool', 'lifterlms' ),
		'BGW'   => __( 'Blaenau Gwent County Borough', 'lifterlms' ),
		'BOL'   => __( 'Bolton', 'lifterlms' ),
		'BMH'   => __( 'Bournemouth', 'lifterlms' ),
		'BRC'   => __( 'Bracknell Forest', 'lifterlms' ),
		'BRD'   => __( 'Bradford', 'lifterlms' ),
		'BGE'   => __( 'Bridgend County Borough', 'lifterlms' ),
		'BNH'   => __( 'Brighton and Hove', 'lifterlms' ),
		'BKM'   => __( 'Buckinghamshire', 'lifterlms' ),
		'BUR'   => __( 'Bury', 'lifterlms' ),
		'CAY'   => __( 'Caerphilly County Borough', 'lifterlms' ),
		'CLD'   => __( 'Calderdale', 'lifterlms' ),
		'CAM'   => __( 'Cambridgeshire', 'lifterlms' ),
		'CMN'   => __( 'Carmarthenshire', 'lifterlms' ),
		'CKF'   => __( 'Carrickfergus Borough Council', 'lifterlms' ),
		'CSR'   => __( 'Castlereagh', 'lifterlms' ),
		'CCG'   => __( 'Causeway Coast and Glens', 'lifterlms' ),
		'CBF'   => __( 'Central Bedfordshire', 'lifterlms' ),
		'CGN'   => __( 'Ceredigion', 'lifterlms' ),
		'CHE'   => __( 'Cheshire East', 'lifterlms' ),
		'CHW'   => __( 'Cheshire West and Chester', 'lifterlms' ),
		'CRF'   => __( 'City and County of Cardiff', 'lifterlms' ),
		'SWA'   => __( 'City and County of Swansea', 'lifterlms' ),
		'BST'   => __( 'City of Bristol', 'lifterlms' ),
		'DER'   => __( 'City of Derby', 'lifterlms' ),
		'KHL'   => __( 'City of Kingston upon Hull', 'lifterlms' ),
		'LCE'   => __( 'City of Leicester', 'lifterlms' ),
		'LND'   => __( 'City of London', 'lifterlms' ),
		'NGM'   => __( 'City of Nottingham', 'lifterlms' ),
		'PTE'   => __( 'City of Peterborough', 'lifterlms' ),
		'PLY'   => __( 'City of Plymouth', 'lifterlms' ),
		'POR'   => __( 'City of Portsmouth', 'lifterlms' ),
		'STH'   => __( 'City of Southampton', 'lifterlms' ),
		'STE'   => __( 'City of Stoke-on-Trent', 'lifterlms' ),
		'SND'   => __( 'City of Sunderland', 'lifterlms' ),
		'WSM'   => __( 'City of Westminster', 'lifterlms' ),
		'WLV'   => __( 'City of Wolverhampton', 'lifterlms' ),
		'YOR'   => __( 'City of York', 'lifterlms' ),
		'CLK'   => __( 'Clackmannanshire', 'lifterlms' ),
		'CLR'   => __( 'Coleraine Borough Council', 'lifterlms' ),
		'CWY'   => __( 'Conwy County Borough', 'lifterlms' ),
		'CKT'   => __( 'Cookstown District Council', 'lifterlms' ),
		'CON'   => __( 'Cornwall', 'lifterlms' ),
		'DUR'   => __( 'County Durham', 'lifterlms' ),
		'COV'   => __( 'Coventry', 'lifterlms' ),
		'CGV'   => __( 'Craigavon Borough Council', 'lifterlms' ),
		'CMA'   => __( 'Cumbria', 'lifterlms' ),
		'DAL'   => __( 'Darlington', 'lifterlms' ),
		'DEN'   => __( 'Denbighshire', 'lifterlms' ),
		'DBY'   => __( 'Derbyshire', 'lifterlms' ),
		'DRY'   => __( 'Derry City Council', 'lifterlms' ),
		'DRS'   => __( 'Derry City and Strabane', 'lifterlms' ),
		'DEV'   => __( 'Devon', 'lifterlms' ),
		'DNC'   => __( 'Doncaster', 'lifterlms' ),
		'DOR'   => __( 'Dorset', 'lifterlms' ),
		'DOW'   => __( 'Down District Council', 'lifterlms' ),
		'DUD'   => __( 'Dudley', 'lifterlms' ),
		'DGY'   => __( 'Dumfries and Galloway', 'lifterlms' ),
		'DND'   => __( 'Dundee', 'lifterlms' ),
		'DGN'   => __( 'Dungannon and South Tyrone Borough Council', 'lifterlms' ),
		'EAY'   => __( 'East Ayrshire', 'lifterlms' ),
		'EDU'   => __( 'East Dunbartonshire', 'lifterlms' ),
		'ELN'   => __( 'East Lothian', 'lifterlms' ),
		'ERW'   => __( 'East Renfrewshire', 'lifterlms' ),
		'ERY'   => __( 'East Riding of Yorkshire', 'lifterlms' ),
		'ESX'   => __( 'East Sussex', 'lifterlms' ),
		'EDH'   => __( 'Edinburgh', 'lifterlms' ),
		'ENG'   => __( 'England', 'lifterlms' ),
		'ESS'   => __( 'Essex', 'lifterlms' ),
		'FAL'   => __( 'Falkirk', 'lifterlms' ),
		'FER'   => __( 'Fermanagh District Council', 'lifterlms' ),
		'FMO'   => __( 'Fermanagh and Omagh', 'lifterlms' ),
		'FIF'   => __( 'Fife', 'lifterlms' ),
		'FLN'   => __( 'Flintshire', 'lifterlms' ),
		'GAT'   => __( 'Gateshead', 'lifterlms' ),
		'GLG'   => __( 'Glasgow', 'lifterlms' ),
		'GLS'   => __( 'Gloucestershire', 'lifterlms' ),
		'GWN'   => __( 'Gwynedd', 'lifterlms' ),
		'HAL'   => __( 'Halton', 'lifterlms' ),
		'HAM'   => __( 'Hampshire', 'lifterlms' ),
		'HPL'   => __( 'Hartlepool', 'lifterlms' ),
		'HEF'   => __( 'Herefordshire', 'lifterlms' ),
		'HRT'   => __( 'Hertfordshire', 'lifterlms' ),
		'HLD'   => __( 'Highland', 'lifterlms' ),
		'IVC'   => __( 'Inverclyde', 'lifterlms' ),
		'IOW'   => __( 'Isle of Wight', 'lifterlms' ),
		'IOS'   => __( 'Isles of Scilly', 'lifterlms' ),
		'KEN'   => __( 'Kent', 'lifterlms' ),
		'KIR'   => __( 'Kirklees', 'lifterlms' ),
		'KWL'   => __( 'Knowsley', 'lifterlms' ),
		'LAN'   => __( 'Lancashire', 'lifterlms' ),
		'LRN'   => __( 'Larne Borough Council', 'lifterlms' ),
		'LDS'   => __( 'Leeds', 'lifterlms' ),
		'LEC'   => __( 'Leicestershire', 'lifterlms' ),
		'LMV'   => __( 'Limavady Borough Council', 'lifterlms' ),
		'LIN'   => __( 'Lincolnshire', 'lifterlms' ),
		'LSB'   => __( 'Lisburn City Council', 'lifterlms' ),
		'LBC'   => __( 'Lisburn and Castlereagh', 'lifterlms' ),
		'LIV'   => __( 'Liverpool', 'lifterlms' ),
		'BDG'   => __( 'London Borough of Barking and Dagenham', 'lifterlms' ),
		'BNE'   => __( 'London Borough of Barnet', 'lifterlms' ),
		'BEX'   => __( 'London Borough of Bexley', 'lifterlms' ),
		'BEN'   => __( 'London Borough of Brent', 'lifterlms' ),
		'BRY'   => __( 'London Borough of Bromley', 'lifterlms' ),
		'CMD'   => __( 'London Borough of Camden', 'lifterlms' ),
		'CRY'   => __( 'London Borough of Croydon', 'lifterlms' ),
		'EAL'   => __( 'London Borough of Ealing', 'lifterlms' ),
		'ENF'   => __( 'London Borough of Enfield', 'lifterlms' ),
		'HCK'   => __( 'London Borough of Hackney', 'lifterlms' ),
		'HMF'   => __( 'London Borough of Hammersmith and Fulham', 'lifterlms' ),
		'HRY'   => __( 'London Borough of Haringey', 'lifterlms' ),
		'HRW'   => __( 'London Borough of Harrow', 'lifterlms' ),
		'HAV'   => __( 'London Borough of Havering', 'lifterlms' ),
		'HIL'   => __( 'London Borough of Hillingdon', 'lifterlms' ),
		'HNS'   => __( 'London Borough of Hounslow', 'lifterlms' ),
		'ISL'   => __( 'London Borough of Islington', 'lifterlms' ),
		'LBH'   => __( 'London Borough of Lambeth', 'lifterlms' ),
		'LEW'   => __( 'London Borough of Lewisham', 'lifterlms' ),
		'MRT'   => __( 'London Borough of Merton', 'lifterlms' ),
		'NWM'   => __( 'London Borough of Newham', 'lifterlms' ),
		'RDB'   => __( 'London Borough of Redbridge', 'lifterlms' ),
		'RIC'   => __( 'London Borough of Richmond upon Thames', 'lifterlms' ),
		'SWK'   => __( 'London Borough of Southwark', 'lifterlms' ),
		'STN'   => __( 'London Borough of Sutton', 'lifterlms' ),
		'TWH'   => __( 'London Borough of Tower Hamlets', 'lifterlms' ),
		'WFT'   => __( 'London Borough of Waltham Forest', 'lifterlms' ),
		'WND'   => __( 'London Borough of Wandsworth', 'lifterlms' ),
		'MFT'   => __( 'Magherafelt District Council', 'lifterlms' ),
		'MAN'   => __( 'Manchester', 'lifterlms' ),
		'MDW'   => __( 'Medway', 'lifterlms' ),
		'MTY'   => __( 'Merthyr Tydfil County Borough', 'lifterlms' ),
		'WGN'   => __( 'Metropolitan Borough of Wigan', 'lifterlms' ),
		'MUL'   => __( 'Mid Ulster', 'lifterlms' ),
		'MEA'   => __( 'Mid and East Antrim', 'lifterlms' ),
		'MDB'   => __( 'Middlesbrough', 'lifterlms' ),
		'MLN'   => __( 'Midlothian', 'lifterlms' ),
		'MIK'   => __( 'Milton Keynes', 'lifterlms' ),
		'MON'   => __( 'Monmouthshire', 'lifterlms' ),
		'MRY'   => __( 'Moray', 'lifterlms' ),
		'MYL'   => __( 'Moyle District Council', 'lifterlms' ),
		'NTL'   => __( 'Neath Port Talbot County Borough', 'lifterlms' ),
		'NET'   => __( 'Newcastle upon Tyne', 'lifterlms' ),
		'NWP'   => __( 'Newport', 'lifterlms' ),
		'NYM'   => __( 'Newry and Mourne District Council', 'lifterlms' ),
		'NMD'   => __( 'Newry, Mourne and Down', 'lifterlms' ),
		'NTA'   => __( 'Newtownabbey Borough Council', 'lifterlms' ),
		'NFK'   => __( 'Norfolk', 'lifterlms' ),
		'NAY'   => __( 'North Ayrshire', 'lifterlms' ),
		'NDN'   => __( 'North Down Borough Council', 'lifterlms' ),
		'NEL'   => __( 'North East Lincolnshire', 'lifterlms' ),
		'NLK'   => __( 'North Lanarkshire', 'lifterlms' ),
		'NLN'   => __( 'North Lincolnshire', 'lifterlms' ),
		'NSM'   => __( 'North Somerset', 'lifterlms' ),
		'NTY'   => __( 'North Tyneside', 'lifterlms' ),
		'NYK'   => __( 'North Yorkshire', 'lifterlms' ),
		'NTH'   => __( 'Northamptonshire', 'lifterlms' ),
		'NIR'   => __( 'Northern Ireland', 'lifterlms' ),
		'NBL'   => __( 'Northumberland', 'lifterlms' ),
		'NTT'   => __( 'Nottinghamshire', 'lifterlms' ),
		'OLD'   => __( 'Oldham', 'lifterlms' ),
		'OMH'   => __( 'Omagh District Council', 'lifterlms' ),
		'ORK'   => __( 'Orkney Islands', 'lifterlms' ),
		'ELS'   => __( 'Outer Hebrides', 'lifterlms' ),
		'OXF'   => __( 'Oxfordshire', 'lifterlms' ),
		'PEM'   => __( 'Pembrokeshire', 'lifterlms' ),
		'PKN'   => __( 'Perth and Kinross', 'lifterlms' ),
		'POL'   => __( 'Poole', 'lifterlms' ),
		'POW'   => __( 'Powys', 'lifterlms' ),
		'RDG'   => __( 'Reading', 'lifterlms' ),
		'RCC'   => __( 'Redcar and Cleveland', 'lifterlms' ),
		'RFW'   => __( 'Renfrewshire', 'lifterlms' ),
		'RCT'   => __( 'Rhondda Cynon Taf', 'lifterlms' ),
		'RCH'   => __( 'Rochdale', 'lifterlms' ),
		'ROT'   => __( 'Rotherham', 'lifterlms' ),
		'GRE'   => __( 'Royal Borough of Greenwich', 'lifterlms' ),
		'KEC'   => __( 'Royal Borough of Kensington and Chelsea', 'lifterlms' ),
		'KTT'   => __( 'Royal Borough of Kingston upon Thames', 'lifterlms' ),
		'RUT'   => __( 'Rutland', 'lifterlms' ),
		'SH-HL' => __( 'Saint Helena', 'lifterlms' ),
		'SLF'   => __( 'Salford', 'lifterlms' ),
		'SAW'   => __( 'Sandwell', 'lifterlms' ),
		'SCT'   => __( 'Scotland', 'lifterlms' ),
		'SCB'   => __( 'Scottish Borders', 'lifterlms' ),
		'SFT'   => __( 'Sefton', 'lifterlms' ),
		'SHF'   => __( 'Sheffield', 'lifterlms' ),
		'ZET'   => __( 'Shetland Islands', 'lifterlms' ),
		'SHR'   => __( 'Shropshire', 'lifterlms' ),
		'SLG'   => __( 'Slough', 'lifterlms' ),
		'SOL'   => __( 'Solihull', 'lifterlms' ),
		'SOM'   => __( 'Somerset', 'lifterlms' ),
		'SAY'   => __( 'South Ayrshire', 'lifterlms' ),
		'SGC'   => __( 'South Gloucestershire', 'lifterlms' ),
		'SLK'   => __( 'South Lanarkshire', 'lifterlms' ),
		'STY'   => __( 'South Tyneside', 'lifterlms' ),
		'SOS'   => __( 'Southend-on-Sea', 'lifterlms' ),
		'SHN'   => __( 'St Helens', 'lifterlms' ),
		'STS'   => __( 'Staffordshire', 'lifterlms' ),
		'STG'   => __( 'Stirling', 'lifterlms' ),
		'SKP'   => __( 'Stockport', 'lifterlms' ),
		'STT'   => __( 'Stockton-on-Tees', 'lifterlms' ),
		'STB'   => __( 'Strabane District Council', 'lifterlms' ),
		'SFK'   => __( 'Suffolk', 'lifterlms' ),
		'SRY'   => __( 'Surrey', 'lifterlms' ),
		'SWD'   => __( 'Swindon', 'lifterlms' ),
		'TAM'   => __( 'Tameside', 'lifterlms' ),
		'TFW'   => __( 'Telford and Wrekin', 'lifterlms' ),
		'THR'   => __( 'Thurrock', 'lifterlms' ),
		'TOB'   => __( 'Torbay', 'lifterlms' ),
		'TOF'   => __( 'Torfaen', 'lifterlms' ),
		'TRF'   => __( 'Trafford', 'lifterlms' ),
		'UKM'   => __( 'United Kingdom', 'lifterlms' ),
		'VGL'   => __( 'Vale of Glamorgan', 'lifterlms' ),
		'WKF'   => __( 'Wakefield', 'lifterlms' ),
		'WLS'   => __( 'Wales', 'lifterlms' ),
		'WLL'   => __( 'Walsall', 'lifterlms' ),
		'WRT'   => __( 'Warrington', 'lifterlms' ),
		'WAR'   => __( 'Warwickshire', 'lifterlms' ),
		'WBK'   => __( 'West Berkshire', 'lifterlms' ),
		'WDU'   => __( 'West Dunbartonshire', 'lifterlms' ),
		'WLN'   => __( 'West Lothian', 'lifterlms' ),
		'WSX'   => __( 'West Sussex', 'lifterlms' ),
		'WIL'   => __( 'Wiltshire', 'lifterlms' ),
		'WNM'   => __( 'Windsor and Maidenhead', 'lifterlms' ),
		'WRL'   => __( 'Wirral', 'lifterlms' ),
		'WOK'   => __( 'Wokingham', 'lifterlms' ),
		'WOR'   => __( 'Worcestershire', 'lifterlms' ),
		'WRX'   => __( 'Wrexham County Borough', 'lifterlms' ),
	),
	'GD' => array(
		'10' => __( 'Carriacou and Petite Martinique', 'lifterlms' ),
		'01' => __( 'Saint Andrew Parish', 'lifterlms' ),
		'02' => __( 'Saint David Parish', 'lifterlms' ),
		'03' => __( 'Saint George Parish', 'lifterlms' ),
		'04' => __( 'Saint John Parish', 'lifterlms' ),
		'05' => __( 'Saint Mark Parish', 'lifterlms' ),
		'06' => __( 'Saint Patrick Parish', 'lifterlms' ),
	),
	'GE' => array(
		'29' => __( 'Khelvachauri Municipality', 'lifterlms' ),
		'50' => __( 'Senaki Municipality', 'lifterlms' ),
		'AJ' => __( 'Adjara', 'lifterlms' ),
		'AB' => __( 'Autonomous Republic of Abkhazia', 'lifterlms' ),
		'GU' => __( 'Guria', 'lifterlms' ),
		'IM' => __( 'Imereti', 'lifterlms' ),
		'KA' => __( 'Kakheti', 'lifterlms' ),
		'KK' => __( 'Kvemo Kartli', 'lifterlms' ),
		'MM' => __( 'Mtskheta-Mtianeti', 'lifterlms' ),
		'RL' => __( 'Racha-Lechkhumi and Kvemo Svaneti', 'lifterlms' ),
		'SZ' => __( 'Samegrelo-Zemo Svaneti', 'lifterlms' ),
		'SJ' => __( 'Samtskhe-Javakheti', 'lifterlms' ),
		'SK' => __( 'Shida Kartli', 'lifterlms' ),
		'TB' => __( 'Tbilisi', 'lifterlms' ),
	),
	'GF' => array(),
	'GG' => array(),
	'GH' => array(
		'AH' => __( 'Ashanti Region', 'lifterlms' ),
		'BA' => __( 'Brong-Ahafo Region', 'lifterlms' ),
		'CP' => __( 'Central Region', 'lifterlms' ),
		'EP' => __( 'Eastern Region', 'lifterlms' ),
		'AA' => __( 'Greater Accra Region', 'lifterlms' ),
		'NP' => __( 'Northern Region', 'lifterlms' ),
		'UE' => __( 'Upper East Region', 'lifterlms' ),
		'UW' => __( 'Upper West Region', 'lifterlms' ),
		'TV' => __( 'Volta Region', 'lifterlms' ),
		'WP' => __( 'Western Region', 'lifterlms' ),
	),
	'GI' => array(),
	'GL' => array(),
	'GM' => array(
		'B' => __( 'Banjul', 'lifterlms' ),
		'M' => __( 'Central River Division', 'lifterlms' ),
		'L' => __( 'Lower River Division', 'lifterlms' ),
		'N' => __( 'North Bank Division', 'lifterlms' ),
		'U' => __( 'Upper River Division', 'lifterlms' ),
		'W' => __( 'West Coast Division', 'lifterlms' ),
	),
	'GN' => array(
		'BE' => __( 'Beyla Prefecture', 'lifterlms' ),
		'BF' => __( 'Boffa Prefecture', 'lifterlms' ),
		'BK' => __( 'Boké Prefecture', 'lifterlms' ),
		'B'  => __( 'Boké Region', 'lifterlms' ),
		'C'  => __( 'Conakry', 'lifterlms' ),
		'CO' => __( 'Coyah Prefecture', 'lifterlms' ),
		'DB' => __( 'Dabola Prefecture', 'lifterlms' ),
		'DL' => __( 'Dalaba Prefecture', 'lifterlms' ),
		'DI' => __( 'Dinguiraye Prefecture', 'lifterlms' ),
		'DU' => __( 'Dubréka Prefecture', 'lifterlms' ),
		'FA' => __( 'Faranah Prefecture', 'lifterlms' ),
		'FO' => __( 'Forécariah Prefecture', 'lifterlms' ),
		'FR' => __( 'Fria Prefecture', 'lifterlms' ),
		'GA' => __( 'Gaoual Prefecture', 'lifterlms' ),
		'GU' => __( 'Guéckédou Prefecture', 'lifterlms' ),
		'KA' => __( 'Kankan Prefecture', 'lifterlms' ),
		'K'  => __( 'Kankan Region', 'lifterlms' ),
		'KD' => __( 'Kindia Prefecture', 'lifterlms' ),
		'D'  => __( 'Kindia Region', 'lifterlms' ),
		'KS' => __( 'Kissidougou Prefecture', 'lifterlms' ),
		'KB' => __( 'Koubia Prefecture', 'lifterlms' ),
		'KN' => __( 'Koundara Prefecture', 'lifterlms' ),
		'KO' => __( 'Kouroussa Prefecture', 'lifterlms' ),
		'KE' => __( 'Kérouané Prefecture', 'lifterlms' ),
		'LA' => __( 'Labé Prefecture', 'lifterlms' ),
		'L'  => __( 'Labé Region', 'lifterlms' ),
		'LO' => __( 'Lola Prefecture', 'lifterlms' ),
		'LE' => __( 'Lélouma Prefecture', 'lifterlms' ),
		'MC' => __( 'Macenta Prefecture', 'lifterlms' ),
		'ML' => __( 'Mali Prefecture', 'lifterlms' ),
		'MM' => __( 'Mamou Prefecture', 'lifterlms' ),
		'M'  => __( 'Mamou Region', 'lifterlms' ),
		'MD' => __( 'Mandiana Prefecture', 'lifterlms' ),
		'NZ' => __( 'Nzérékoré Prefecture', 'lifterlms' ),
		'N'  => __( 'Nzérékoré Region', 'lifterlms' ),
		'PI' => __( 'Pita Prefecture', 'lifterlms' ),
		'SI' => __( 'Siguiri Prefecture', 'lifterlms' ),
		'TO' => __( 'Tougué Prefecture', 'lifterlms' ),
		'TE' => __( 'Télimélé Prefecture', 'lifterlms' ),
		'YO' => __( 'Yomou Prefecture', 'lifterlms' ),
	),
	'GP' => array(),
	'GQ' => array(
		'AN' => __( 'Annobón Province', 'lifterlms' ),
		'BN' => __( 'Bioko Norte Province', 'lifterlms' ),
		'BS' => __( 'Bioko Sur Province', 'lifterlms' ),
		'CS' => __( 'Centro Sur Province', 'lifterlms' ),
		'I'  => __( 'Insular Region', 'lifterlms' ),
		'KN' => __( 'Kié-Ntem Province', 'lifterlms' ),
		'LI' => __( 'Litoral Province', 'lifterlms' ),
		'C'  => __( 'Río Muni', 'lifterlms' ),
		'WN' => __( 'Wele-Nzas Province', 'lifterlms' ),
	),
	'GR' => array(
		'11' => __( 'Argolis Regional Unit', 'lifterlms' ),
		'12' => __( 'Arcadia Prefecture', 'lifterlms' ),
		'13' => __( 'Achaea Regional Unit', 'lifterlms' ),
		'15' => __( 'Corinthia Regional Unit', 'lifterlms' ),
		'16' => __( 'Laconia', 'lifterlms' ),
		'22' => __( 'Corfu Prefecture', 'lifterlms' ),
		'23' => __( 'Kefalonia Prefecture', 'lifterlms' ),
		'24' => __( 'Lefkada Regional Unit', 'lifterlms' ),
		'33' => __( 'Ioannina Regional Unit', 'lifterlms' ),
		'34' => __( 'Preveza Prefecture', 'lifterlms' ),
		'41' => __( 'Karditsa Regional Unit', 'lifterlms' ),
		'42' => __( 'Larissa Prefecture', 'lifterlms' ),
		'51' => __( 'Grevena Prefecture', 'lifterlms' ),
		'52' => __( 'Drama Regional Unit', 'lifterlms' ),
		'53' => __( 'Imathia Regional Unit', 'lifterlms' ),
		'54' => __( 'Thessaloniki Regional Unit', 'lifterlms' ),
		'56' => __( 'Kastoria Regional Unit', 'lifterlms' ),
		'57' => __( 'Kilkis Regional Unit', 'lifterlms' ),
		'58' => __( 'Kozani Prefecture', 'lifterlms' ),
		'59' => __( 'Pella Regional Unit', 'lifterlms' ),
		'62' => __( 'Serres Prefecture', 'lifterlms' ),
		'94' => __( 'Chania Regional Unit', 'lifterlms' ),
		'01' => __( 'Aetolia-Acarnania Regional Unit', 'lifterlms' ),
		'I'  => __( 'Attica Region', 'lifterlms' ),
		'03' => __( 'Boeotia Regional Unit', 'lifterlms' ),
		'H'  => __( 'Central Greece Region', 'lifterlms' ),
		'B'  => __( 'Central Macedonia', 'lifterlms' ),
		'M'  => __( 'Crete Region', 'lifterlms' ),
		'A2' => __( 'East Attica Regional Unit', 'lifterlms' ),
		'A'  => __( 'East Macedonia and Thrace', 'lifterlms' ),
		'D'  => __( 'Epirus Region', 'lifterlms' ),
		'04' => __( 'Euboea', 'lifterlms' ),
		'F'  => __( 'Ionian Islands Region', 'lifterlms' ),
		'J'  => __( 'Peloponnese Region', 'lifterlms' ),
		'06' => __( 'Phthiotis Prefecture', 'lifterlms' ),
		'L'  => __( 'South Aegean', 'lifterlms' ),
		'G'  => __( 'West Greece Region', 'lifterlms' ),
		'C'  => __( 'West Macedonia Region', 'lifterlms' ),
	),
	'GS' => array(),
	'GT' => array(
		'AV' => __( 'Alta Verapaz Department', 'lifterlms' ),
		'BV' => __( 'Baja Verapaz Department', 'lifterlms' ),
		'CM' => __( 'Chimaltenango Department', 'lifterlms' ),
		'CQ' => __( 'Chiquimula Department', 'lifterlms' ),
		'PR' => __( 'El Progreso Department', 'lifterlms' ),
		'ES' => __( 'Escuintla Department', 'lifterlms' ),
		'GU' => __( 'Guatemala Department', 'lifterlms' ),
		'HU' => __( 'Huehuetenango Department', 'lifterlms' ),
		'IZ' => __( 'Izabal Department', 'lifterlms' ),
		'JA' => __( 'Jalapa Department', 'lifterlms' ),
		'JU' => __( 'Jutiapa Department', 'lifterlms' ),
		'PE' => __( 'Petén Department', 'lifterlms' ),
		'QZ' => __( 'Quetzaltenango Department', 'lifterlms' ),
		'QC' => __( 'Quiché Department', 'lifterlms' ),
		'RE' => __( 'Retalhuleu Department', 'lifterlms' ),
		'SA' => __( 'Sacatepéquez Department', 'lifterlms' ),
		'SM' => __( 'San Marcos Department', 'lifterlms' ),
		'SR' => __( 'Santa Rosa Department', 'lifterlms' ),
		'SO' => __( 'Sololá Department', 'lifterlms' ),
		'SU' => __( 'Suchitepéquez Department', 'lifterlms' ),
		'TO' => __( 'Totonicapán Department', 'lifterlms' ),
	),
	'GU' => array(),
	'GW' => array(
		'BA' => __( 'Bafatá', 'lifterlms' ),
		'BM' => __( 'Biombo Region', 'lifterlms' ),
		'BL' => __( 'Bolama Region', 'lifterlms' ),
		'CA' => __( 'Cacheu Region', 'lifterlms' ),
		'GA' => __( 'Gabú Region', 'lifterlms' ),
		'L'  => __( 'Leste Province', 'lifterlms' ),
		'N'  => __( 'Norte Province', 'lifterlms' ),
		'OI' => __( 'Oio Region', 'lifterlms' ),
		'QU' => __( 'Quinara Region', 'lifterlms' ),
		'S'  => __( 'Sul Province', 'lifterlms' ),
		'TO' => __( 'Tombali Region', 'lifterlms' ),
	),
	'GY' => array(
		'BA' => __( 'Barima-Waini', 'lifterlms' ),
		'CU' => __( 'Cuyuni-Mazaruni', 'lifterlms' ),
		'DE' => __( 'Demerara-Mahaica', 'lifterlms' ),
		'EB' => __( 'East Berbice-Corentyne', 'lifterlms' ),
		'ES' => __( 'Essequibo Islands-West Demerara', 'lifterlms' ),
		'MA' => __( 'Mahaica-Berbice', 'lifterlms' ),
		'PM' => __( 'Pomeroon-Supenaam', 'lifterlms' ),
		'PT' => __( 'Potaro-Siparuni', 'lifterlms' ),
		'UD' => __( 'Upper Demerara-Berbice', 'lifterlms' ),
		'UT' => __( 'Upper Takutu-Upper Essequibo', 'lifterlms' ),
	),
	'HK' => array(
		'HCW' => __( 'Central and Western District', 'lifterlms' ),
		'HEA' => __( 'Eastern', 'lifterlms' ),
		'NIS' => __( 'Islands District', 'lifterlms' ),
		'KKC' => __( 'Kowloon City', 'lifterlms' ),
		'NKT' => __( 'Kwai Tsing', 'lifterlms' ),
		'KKT' => __( 'Kwun Tong', 'lifterlms' ),
		'NNO' => __( 'North', 'lifterlms' ),
		'NSK' => __( 'Sai Kung District', 'lifterlms' ),
		'NST' => __( 'Sha Tin', 'lifterlms' ),
		'KSS' => __( 'Sham Shui Po', 'lifterlms' ),
		'HSO' => __( 'Southern', 'lifterlms' ),
		'NTP' => __( 'Tai Po District', 'lifterlms' ),
		'NTW' => __( 'Tsuen Wan District', 'lifterlms' ),
		'NTM' => __( 'Tuen Mun', 'lifterlms' ),
		'HWC' => __( 'Wan Chai', 'lifterlms' ),
		'KWT' => __( 'Wong Tai Sin', 'lifterlms' ),
		'KYT' => __( 'Yau Tsim Mong', 'lifterlms' ),
		'NYL' => __( 'Yuen Long District', 'lifterlms' ),
	),
	'HM' => array(),
	'HN' => array(
		'AT' => __( 'Atlántida Department', 'lifterlms' ),
		'IB' => __( 'Bay Islands Department', 'lifterlms' ),
		'CH' => __( 'Choluteca Department', 'lifterlms' ),
		'CL' => __( 'Colón Department', 'lifterlms' ),
		'CM' => __( 'Comayagua Department', 'lifterlms' ),
		'CP' => __( 'Copán Department', 'lifterlms' ),
		'CR' => __( 'Cortés Department', 'lifterlms' ),
		'EP' => __( 'El Paraíso Department', 'lifterlms' ),
		'FM' => __( 'Francisco Morazán Department', 'lifterlms' ),
		'GD' => __( 'Gracias a Dios Department', 'lifterlms' ),
		'IN' => __( 'Intibucá Department', 'lifterlms' ),
		'LP' => __( 'La Paz Department', 'lifterlms' ),
		'LE' => __( 'Lempira Department', 'lifterlms' ),
		'OC' => __( 'Ocotepeque Department', 'lifterlms' ),
		'OL' => __( 'Olancho Department', 'lifterlms' ),
		'SB' => __( 'Santa Bárbara Department', 'lifterlms' ),
		'VA' => __( 'Valle Department', 'lifterlms' ),
		'YO' => __( 'Yoro Department', 'lifterlms' ),
	),
	'HR' => array(
		'10' => __( 'Virovitica-Podravina County', 'lifterlms' ),
		'11' => __( 'Požega-Slavonia County', 'lifterlms' ),
		'12' => __( 'Brod-Posavina County', 'lifterlms' ),
		'13' => __( 'Zadar County', 'lifterlms' ),
		'14' => __( 'Osijek-Baranja County', 'lifterlms' ),
		'15' => __( 'Šibenik-Knin County', 'lifterlms' ),
		'16' => __( 'Vukovar-Syrmia County', 'lifterlms' ),
		'17' => __( 'Split-Dalmatia County', 'lifterlms' ),
		'18' => __( 'Istria County', 'lifterlms' ),
		'19' => __( 'Dubrovnik-Neretva County', 'lifterlms' ),
		'20' => __( 'Međimurje County', 'lifterlms' ),
		'21' => __( 'Zagreb', 'lifterlms' ),
		'07' => __( 'Bjelovar-Bilogora County', 'lifterlms' ),
		'06' => __( 'Koprivnica-Križevci County', 'lifterlms' ),
		'02' => __( 'Krapina-Zagorje County', 'lifterlms' ),
		'09' => __( 'Lika-Senj County', 'lifterlms' ),
		'08' => __( 'Primorje-Gorski Kotar County', 'lifterlms' ),
		'03' => __( 'Sisak-Moslavina County', 'lifterlms' ),
		'05' => __( 'Varaždin County', 'lifterlms' ),
		'01' => __( 'Zagreb County', 'lifterlms' ),
	),
	'HT' => array(
		'AR' => __( 'Artibonite', 'lifterlms' ),
		'CE' => __( 'Centre', 'lifterlms' ),
		'GA' => __( 'Grand\'Anse', 'lifterlms' ),
		'NI' => __( 'Nippes', 'lifterlms' ),
		'ND' => __( 'Nord', 'lifterlms' ),
		'NE' => __( 'Nord-Est', 'lifterlms' ),
		'NO' => __( 'Nord-Ouest', 'lifterlms' ),
		'OU' => __( 'Ouest', 'lifterlms' ),
		'SD' => __( 'Sud', 'lifterlms' ),
		'SE' => __( 'Sud-Est', 'lifterlms' ),
	),
	'HU' => array(
		'BA' => __( 'Baranya County', 'lifterlms' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén County', 'lifterlms' ),
		'BU' => __( 'Budapest', 'lifterlms' ),
		'BK' => __( 'Bács-Kiskun County', 'lifterlms' ),
		'BE' => __( 'Békés County', 'lifterlms' ),
		'BC' => __( 'Békéscsaba', 'lifterlms' ),
		'CS' => __( 'Csongrád County', 'lifterlms' ),
		'DE' => __( 'Debrecen', 'lifterlms' ),
		'DU' => __( 'Dunaújváros', 'lifterlms' ),
		'EG' => __( 'Eger', 'lifterlms' ),
		'FE' => __( 'Fejér County', 'lifterlms' ),
		'GY' => __( 'Győr', 'lifterlms' ),
		'GS' => __( 'Győr-Moson-Sopron County', 'lifterlms' ),
		'HB' => __( 'Hajdú-Bihar County', 'lifterlms' ),
		'HE' => __( 'Heves County', 'lifterlms' ),
		'HV' => __( 'Hódmezővásárhely', 'lifterlms' ),
		'JN' => __( 'Jász-Nagykun-Szolnok County', 'lifterlms' ),
		'KV' => __( 'Kaposvár', 'lifterlms' ),
		'KM' => __( 'Kecskemét', 'lifterlms' ),
		'MI' => __( 'Miskolc', 'lifterlms' ),
		'NK' => __( 'Nagykanizsa', 'lifterlms' ),
		'NY' => __( 'Nyíregyháza', 'lifterlms' ),
		'NO' => __( 'Nógrád County', 'lifterlms' ),
		'PE' => __( 'Pest County', 'lifterlms' ),
		'PS' => __( 'Pécs', 'lifterlms' ),
		'ST' => __( 'Salgótarján', 'lifterlms' ),
		'SO' => __( 'Somogy County', 'lifterlms' ),
		'SN' => __( 'Sopron', 'lifterlms' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg County', 'lifterlms' ),
		'SD' => __( 'Szeged', 'lifterlms' ),
		'SS' => __( 'Szekszárd', 'lifterlms' ),
		'SK' => __( 'Szolnok', 'lifterlms' ),
		'SH' => __( 'Szombathely', 'lifterlms' ),
		'SF' => __( 'Székesfehérvár', 'lifterlms' ),
		'TB' => __( 'Tatabánya', 'lifterlms' ),
		'TO' => __( 'Tolna County', 'lifterlms' ),
		'VA' => __( 'Vas County', 'lifterlms' ),
		'VM' => __( 'Veszprém', 'lifterlms' ),
		'VE' => __( 'Veszprém County', 'lifterlms' ),
		'ZA' => __( 'Zala County', 'lifterlms' ),
		'ZE' => __( 'Zalaegerszeg', 'lifterlms' ),
		'ER' => __( 'Érd', 'lifterlms' ),
	),
	'ID' => array(
		'AC' => __( 'Aceh', 'lifterlms' ),
		'BA' => __( 'Bali', 'lifterlms' ),
		'BB' => __( 'Bangka Belitung Islands', 'lifterlms' ),
		'BT' => __( 'Banten', 'lifterlms' ),
		'BE' => __( 'Bengkulu', 'lifterlms' ),
		'JT' => __( 'Central Java', 'lifterlms' ),
		'KT' => __( 'Central Kalimantan', 'lifterlms' ),
		'ST' => __( 'Central Sulawesi', 'lifterlms' ),
		'JI' => __( 'East Java', 'lifterlms' ),
		'KI' => __( 'East Kalimantan', 'lifterlms' ),
		'NT' => __( 'East Nusa Tenggara', 'lifterlms' ),
		'GO' => __( 'Gorontalo', 'lifterlms' ),
		'JK' => __( 'Jakarta', 'lifterlms' ),
		'JA' => __( 'Jambi', 'lifterlms' ),
		'KA' => __( 'Kalimantan', 'lifterlms' ),
		'LA' => __( 'Lampung', 'lifterlms' ),
		'NU' => __( 'Lesser Sunda Islands', 'lifterlms' ),
		'MA' => __( 'Maluku', 'lifterlms' ),
		'ML' => __( 'Maluku Islands', 'lifterlms' ),
		'KU' => __( 'North Kalimantan', 'lifterlms' ),
		'MU' => __( 'North Maluku', 'lifterlms' ),
		'SA' => __( 'North Sulawesi', 'lifterlms' ),
		'SU' => __( 'North Sumatra', 'lifterlms' ),
		'PA' => __( 'Papua', 'lifterlms' ),
		'RI' => __( 'Riau', 'lifterlms' ),
		'KR' => __( 'Riau Islands', 'lifterlms' ),
		'KS' => __( 'South Kalimantan', 'lifterlms' ),
		'SN' => __( 'South Sulawesi', 'lifterlms' ),
		'SS' => __( 'South Sumatra', 'lifterlms' ),
		'SG' => __( 'Southeast Sulawesi', 'lifterlms' ),
		'YO' => __( 'Special Region of Yogyakarta', 'lifterlms' ),
		'SL' => __( 'Sulawesi', 'lifterlms' ),
		'SM' => __( 'Sumatra', 'lifterlms' ),
		'JB' => __( 'West Java', 'lifterlms' ),
		'NB' => __( 'West Nusa Tenggara', 'lifterlms' ),
		'PB' => __( 'West Papua', 'lifterlms' ),
		'SR' => __( 'West Sulawesi', 'lifterlms' ),
		'SB' => __( 'West Sumatra', 'lifterlms' ),
	),
	'IE' => array(
		'C'  => __( 'Connacht', 'lifterlms' ),
		'CW' => __( 'County Carlow', 'lifterlms' ),
		'CN' => __( 'County Cavan', 'lifterlms' ),
		'CE' => __( 'County Clare', 'lifterlms' ),
		'CO' => __( 'County Cork', 'lifterlms' ),
		'DL' => __( 'County Donegal', 'lifterlms' ),
		'D'  => __( 'County Dublin', 'lifterlms' ),
		'G'  => __( 'County Galway', 'lifterlms' ),
		'KY' => __( 'County Kerry', 'lifterlms' ),
		'KE' => __( 'County Kildare', 'lifterlms' ),
		'KK' => __( 'County Kilkenny', 'lifterlms' ),
		'LS' => __( 'County Laois', 'lifterlms' ),
		'LK' => __( 'County Limerick', 'lifterlms' ),
		'LD' => __( 'County Longford', 'lifterlms' ),
		'LH' => __( 'County Louth', 'lifterlms' ),
		'MO' => __( 'County Mayo', 'lifterlms' ),
		'MH' => __( 'County Meath', 'lifterlms' ),
		'MN' => __( 'County Monaghan', 'lifterlms' ),
		'OY' => __( 'County Offaly', 'lifterlms' ),
		'RN' => __( 'County Roscommon', 'lifterlms' ),
		'SO' => __( 'County Sligo', 'lifterlms' ),
		'TA' => __( 'County Tipperary', 'lifterlms' ),
		'WD' => __( 'County Waterford', 'lifterlms' ),
		'WH' => __( 'County Westmeath', 'lifterlms' ),
		'WX' => __( 'County Wexford', 'lifterlms' ),
		'WW' => __( 'County Wicklow', 'lifterlms' ),
		'L'  => __( 'Leinster', 'lifterlms' ),
		'M'  => __( 'Munster', 'lifterlms' ),
		'U'  => __( 'Ulster', 'lifterlms' ),
	),
	'IL' => array(
		'M'  => __( 'Central District', 'lifterlms' ),
		'HA' => __( 'Haifa District', 'lifterlms' ),
		'JM' => __( 'Jerusalem District', 'lifterlms' ),
		'Z'  => __( 'Northern District', 'lifterlms' ),
		'D'  => __( 'Southern District', 'lifterlms' ),
		'TA' => __( 'Tel Aviv District', 'lifterlms' ),
	),
	'IM' => array(),
	'IN' => array(
		'AN' => __( 'Andaman and Nicobar Islands', 'lifterlms' ),
		'AP' => __( 'Andhra Pradesh', 'lifterlms' ),
		'AR' => __( 'Arunachal Pradesh', 'lifterlms' ),
		'AS' => __( 'Assam', 'lifterlms' ),
		'BR' => __( 'Bihar', 'lifterlms' ),
		'CH' => __( 'Chandigarh', 'lifterlms' ),
		'CT' => __( 'Chhattisgarh', 'lifterlms' ),
		'DH' => __( 'Dadra and Nagar Haveli and Daman and Diu', 'lifterlms' ),
		'DL' => __( 'Delhi', 'lifterlms' ),
		'GA' => __( 'Goa', 'lifterlms' ),
		'GJ' => __( 'Gujarat', 'lifterlms' ),
		'HR' => __( 'Haryana', 'lifterlms' ),
		'HP' => __( 'Himachal Pradesh', 'lifterlms' ),
		'JK' => __( 'Jammu and Kashmir', 'lifterlms' ),
		'JH' => __( 'Jharkhand', 'lifterlms' ),
		'KA' => __( 'Karnataka', 'lifterlms' ),
		'KL' => __( 'Kerala', 'lifterlms' ),
		'LA' => __( 'Ladakh', 'lifterlms' ),
		'LD' => __( 'Lakshadweep', 'lifterlms' ),
		'MP' => __( 'Madhya Pradesh', 'lifterlms' ),
		'MH' => __( 'Maharashtra', 'lifterlms' ),
		'MN' => __( 'Manipur', 'lifterlms' ),
		'ML' => __( 'Meghalaya', 'lifterlms' ),
		'MZ' => __( 'Mizoram', 'lifterlms' ),
		'NL' => __( 'Nagaland', 'lifterlms' ),
		'OR' => __( 'Odisha', 'lifterlms' ),
		'PY' => __( 'Puducherry', 'lifterlms' ),
		'PB' => __( 'Punjab', 'lifterlms' ),
		'RJ' => __( 'Rajasthan', 'lifterlms' ),
		'SK' => __( 'Sikkim', 'lifterlms' ),
		'TN' => __( 'Tamil Nadu', 'lifterlms' ),
		'TG' => __( 'Telangana', 'lifterlms' ),
		'TR' => __( 'Tripura', 'lifterlms' ),
		'UP' => __( 'Uttar Pradesh', 'lifterlms' ),
		'UT' => __( 'Uttarakhand', 'lifterlms' ),
		'WB' => __( 'West Bengal', 'lifterlms' ),
	),
	'IO' => array(),
	'IQ' => array(
		'AN' => __( 'Al Anbar Governorate', 'lifterlms' ),
		'MU' => __( 'Al Muthanna Governorate', 'lifterlms' ),
		'QA' => __( 'Al-Qādisiyyah Governorate', 'lifterlms' ),
		'BB' => __( 'Babylon Governorate', 'lifterlms' ),
		'BG' => __( 'Baghdad Governorate', 'lifterlms' ),
		'BA' => __( 'Basra Governorate', 'lifterlms' ),
		'DQ' => __( 'Dhi Qar Governorate', 'lifterlms' ),
		'DI' => __( 'Diyala Governorate', 'lifterlms' ),
		'DA' => __( 'Dohuk Governorate', 'lifterlms' ),
		'AR' => __( 'Erbil Governorate', 'lifterlms' ),
		'KA' => __( 'Karbala Governorate', 'lifterlms' ),
		'KI' => __( 'Kirkuk Governorate', 'lifterlms' ),
		'MA' => __( 'Maysan Governorate', 'lifterlms' ),
		'NA' => __( 'Najaf Governorate', 'lifterlms' ),
		'NI' => __( 'Nineveh Governorate', 'lifterlms' ),
		'SD' => __( 'Saladin Governorate', 'lifterlms' ),
		'SU' => __( 'Sulaymaniyah Governorate', 'lifterlms' ),
		'WA' => __( 'Wasit Governorate', 'lifterlms' ),
	),
	'IR' => array(
		'10' => __( 'Isfahan Province', 'lifterlms' ),
		'11' => __( 'Sistan and Baluchestan', 'lifterlms' ),
		'12' => __( 'Kurdistan Province', 'lifterlms' ),
		'13' => __( 'Hamadan Province', 'lifterlms' ),
		'14' => __( 'Chaharmahal and Bakhtiari Province', 'lifterlms' ),
		'15' => __( 'Lorestan Province', 'lifterlms' ),
		'16' => __( 'Ilam Province', 'lifterlms' ),
		'17' => __( 'Kohgiluyeh and Boyer-Ahmad Province', 'lifterlms' ),
		'18' => __( 'Bushehr Province', 'lifterlms' ),
		'19' => __( 'Zanjan Province', 'lifterlms' ),
		'20' => __( 'Semnan Province', 'lifterlms' ),
		'21' => __( 'Yazd Province', 'lifterlms' ),
		'22' => __( 'Hormozgan Province', 'lifterlms' ),
		'23' => __( 'Tehran Province', 'lifterlms' ),
		'24' => __( 'Ardabil Province', 'lifterlms' ),
		'25' => __( 'Qom Province', 'lifterlms' ),
		'26' => __( 'Qazvin Province', 'lifterlms' ),
		'27' => __( 'Golestan Province', 'lifterlms' ),
		'28' => __( 'North Khorasan Province', 'lifterlms' ),
		'29' => __( 'South Khorasan Province', 'lifterlms' ),
		'30' => __( 'Alborz Province', 'lifterlms' ),
		'03' => __( 'East Azerbaijan Province', 'lifterlms' ),
		'07' => __( 'Fars Province', 'lifterlms' ),
		'01' => __( 'Gilan Province', 'lifterlms' ),
		'08' => __( 'Kerman Province', 'lifterlms' ),
		'05' => __( 'Kermanshah Province', 'lifterlms' ),
		'06' => __( 'Khuzestan Province', 'lifterlms' ),
		'00' => __( 'Markazi Province', 'lifterlms' ),
		'02' => __( 'Mazandaran Province', 'lifterlms' ),
		'09' => __( 'Razavi Khorasan Province', 'lifterlms' ),
		'04' => __( 'West Azarbaijan Province', 'lifterlms' ),
	),
	'IS' => array(
		'1' => __( 'Capital Region', 'lifterlms' ),
		'2' => __( 'Southern Peninsula Region', 'lifterlms' ),
		'3' => __( 'Western Region', 'lifterlms' ),
		'4' => __( 'Westfjords', 'lifterlms' ),
		'5' => __( 'Northwestern Region', 'lifterlms' ),
		'6' => __( 'Northeastern Region', 'lifterlms' ),
		'7' => __( 'Eastern Region', 'lifterlms' ),
		'8' => __( 'Southern Region', 'lifterlms' ),
	),
	'IT' => array(
		'AG' => __( 'Agrigento', 'lifterlms' ),
		'AL' => __( 'Alessandria', 'lifterlms' ),
		'AN' => __( 'Ancona', 'lifterlms' ),
		'AP' => __( 'Ascoli Piceno', 'lifterlms' ),
		'AT' => __( 'Asti', 'lifterlms' ),
		'AV' => __( 'Avellino', 'lifterlms' ),
		'BA' => __( 'Bari', 'lifterlms' ),
		'BT' => __( 'Barletta-Andria-Trani', 'lifterlms' ),
		'BL' => __( 'Belluno', 'lifterlms' ),
		'BN' => __( 'Benevento Province', 'lifterlms' ),
		'BG' => __( 'Bergamo', 'lifterlms' ),
		'BI' => __( 'Biella', 'lifterlms' ),
		'BO' => __( 'Bologna', 'lifterlms' ),
		'BS' => __( 'Brescia', 'lifterlms' ),
		'BR' => __( 'Brindisi', 'lifterlms' ),
		'CA' => __( 'Cagliari', 'lifterlms' ),
		'CL' => __( 'Caltanissetta', 'lifterlms' ),
		'CB' => __( 'Campobasso', 'lifterlms' ),
		'CI' => __( 'Carbonia-Iglesias', 'lifterlms' ),
		'CE' => __( 'Caserta', 'lifterlms' ),
		'CT' => __( 'Catania', 'lifterlms' ),
		'CZ' => __( 'Catanzaro', 'lifterlms' ),
		'CH' => __( 'Chieti', 'lifterlms' ),
		'CO' => __( 'Como', 'lifterlms' ),
		'CS' => __( 'Cosenza', 'lifterlms' ),
		'CR' => __( 'Cremona', 'lifterlms' ),
		'KR' => __( 'Crotone', 'lifterlms' ),
		'CN' => __( 'Cuneo', 'lifterlms' ),
		'EN' => __( 'Enna', 'lifterlms' ),
		'FM' => __( 'Fermo', 'lifterlms' ),
		'FE' => __( 'Ferrara', 'lifterlms' ),
		'FI' => __( 'Florence', 'lifterlms' ),
		'FG' => __( 'Foggia', 'lifterlms' ),
		'FC' => __( 'Forlì-Cesena', 'lifterlms' ),
		'FR' => __( 'Frosinone', 'lifterlms' ),
		'GE' => __( 'Genoa', 'lifterlms' ),
		'GO' => __( 'Gorizia', 'lifterlms' ),
		'GR' => __( 'Grosseto', 'lifterlms' ),
		'IM' => __( 'Imperia', 'lifterlms' ),
		'IS' => __( 'Isernia', 'lifterlms' ),
		'AQ' => __( 'L\'Aquila', 'lifterlms' ),
		'SP' => __( 'La Spezia', 'lifterlms' ),
		'LT' => __( 'Latina', 'lifterlms' ),
		'LE' => __( 'Lecce', 'lifterlms' ),
		'LC' => __( 'Lecco', 'lifterlms' ),
		'LI' => __( 'Livorno', 'lifterlms' ),
		'LO' => __( 'Lodi', 'lifterlms' ),
		'LU' => __( 'Lucca', 'lifterlms' ),
		'MC' => __( 'Macerata', 'lifterlms' ),
		'MN' => __( 'Mantua', 'lifterlms' ),
		'MS' => __( 'Massa and Carrara', 'lifterlms' ),
		'MT' => __( 'Matera', 'lifterlms' ),
		'VS' => __( 'Medio Campidano', 'lifterlms' ),
		'ME' => __( 'Messina', 'lifterlms' ),
		'MI' => __( 'Milan', 'lifterlms' ),
		'MO' => __( 'Modena', 'lifterlms' ),
		'MB' => __( 'Monza and Brianza', 'lifterlms' ),
		'NA' => __( 'Naples', 'lifterlms' ),
		'NO' => __( 'Novara', 'lifterlms' ),
		'NU' => __( 'Nuoro', 'lifterlms' ),
		'OG' => __( 'Ogliastra', 'lifterlms' ),
		'OT' => __( 'Olbia-Tempio', 'lifterlms' ),
		'OR' => __( 'Oristano', 'lifterlms' ),
		'PD' => __( 'Padua', 'lifterlms' ),
		'PA' => __( 'Palermo', 'lifterlms' ),
		'PR' => __( 'Parma', 'lifterlms' ),
		'PV' => __( 'Pavia', 'lifterlms' ),
		'PG' => __( 'Perugia', 'lifterlms' ),
		'PU' => __( 'Pesaro and Urbino Province', 'lifterlms' ),
		'PE' => __( 'Pescara', 'lifterlms' ),
		'PC' => __( 'Piacenza', 'lifterlms' ),
		'PI' => __( 'Pisa', 'lifterlms' ),
		'PT' => __( 'Pistoia', 'lifterlms' ),
		'PN' => __( 'Pordenone', 'lifterlms' ),
		'PZ' => __( 'Potenza', 'lifterlms' ),
		'PO' => __( 'Prato', 'lifterlms' ),
		'RG' => __( 'Ragusa', 'lifterlms' ),
		'RA' => __( 'Ravenna', 'lifterlms' ),
		'RC' => __( 'Reggio Calabria', 'lifterlms' ),
		'RE' => __( 'Reggio Emilia', 'lifterlms' ),
		'RI' => __( 'Rieti', 'lifterlms' ),
		'RN' => __( 'Rimini', 'lifterlms' ),
		'RM' => __( 'Rome', 'lifterlms' ),
		'RO' => __( 'Rovigo', 'lifterlms' ),
		'SA' => __( 'Salerno', 'lifterlms' ),
		'SS' => __( 'Sassari', 'lifterlms' ),
		'SV' => __( 'Savona', 'lifterlms' ),
		'SI' => __( 'Siena', 'lifterlms' ),
		'SR' => __( 'Siracusa', 'lifterlms' ),
		'SO' => __( 'Sondrio', 'lifterlms' ),
		'BZ' => __( 'South Tyrol', 'lifterlms' ),
		'TA' => __( 'Taranto', 'lifterlms' ),
		'TE' => __( 'Teramo', 'lifterlms' ),
		'TR' => __( 'Terni', 'lifterlms' ),
		'TP' => __( 'Trapani', 'lifterlms' ),
		'TN' => __( 'Trentino', 'lifterlms' ),
		'TV' => __( 'Treviso', 'lifterlms' ),
		'TS' => __( 'Trieste', 'lifterlms' ),
		'TO' => __( 'Turin', 'lifterlms' ),
		'UD' => __( 'Udine', 'lifterlms' ),
		'VA' => __( 'Varese', 'lifterlms' ),
		'VE' => __( 'Venice', 'lifterlms' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'lifterlms' ),
		'VC' => __( 'Vercelli', 'lifterlms' ),
		'VR' => __( 'Verona', 'lifterlms' ),
		'VV' => __( 'Vibo Valentia', 'lifterlms' ),
		'VI' => __( 'Vicenza', 'lifterlms' ),
		'VT' => __( 'Viterbo', 'lifterlms' ),
	),
	'JE' => array(),
	'JM' => array(
		'10' => __( 'Westmoreland Parish', 'lifterlms' ),
		'11' => __( 'Saint Elizabeth Parish', 'lifterlms' ),
		'12' => __( 'Manchester Parish', 'lifterlms' ),
		'13' => __( 'Clarendon Parish', 'lifterlms' ),
		'14' => __( 'Saint Catherine Parish', 'lifterlms' ),
		'09' => __( 'Hanover Parish', 'lifterlms' ),
		'01' => __( 'Kingston Parish', 'lifterlms' ),
		'04' => __( 'Portland Parish', 'lifterlms' ),
		'02' => __( 'Saint Andrew', 'lifterlms' ),
		'06' => __( 'Saint Ann Parish', 'lifterlms' ),
		'08' => __( 'Saint James Parish', 'lifterlms' ),
		'05' => __( 'Saint Mary Parish', 'lifterlms' ),
		'03' => __( 'Saint Thomas Parish', 'lifterlms' ),
		'07' => __( 'Trelawny Parish', 'lifterlms' ),
	),
	'JO' => array(
		'AJ' => __( 'Ajloun Governorate', 'lifterlms' ),
		'AM' => __( 'Amman Governorate', 'lifterlms' ),
		'AQ' => __( 'Aqaba Governorate', 'lifterlms' ),
		'BA' => __( 'Balqa Governorate', 'lifterlms' ),
		'IR' => __( 'Irbid Governorate', 'lifterlms' ),
		'JA' => __( 'Jerash Governorate', 'lifterlms' ),
		'KA' => __( 'Karak Governorate', 'lifterlms' ),
		'MN' => __( 'Ma\'an Governorate', 'lifterlms' ),
		'MD' => __( 'Madaba Governorate', 'lifterlms' ),
		'MA' => __( 'Mafraq Governorate', 'lifterlms' ),
		'AT' => __( 'Tafilah Governorate', 'lifterlms' ),
		'AZ' => __( 'Zarqa Governorate', 'lifterlms' ),
	),
	'JP' => array(
		'10' => __( 'Gunma Prefecture', 'lifterlms' ),
		'11' => __( 'Saitama Prefecture', 'lifterlms' ),
		'12' => __( 'Chiba Prefecture', 'lifterlms' ),
		'13' => __( 'Tokyo', 'lifterlms' ),
		'14' => __( 'Kanagawa Prefecture', 'lifterlms' ),
		'15' => __( 'Niigata Prefecture', 'lifterlms' ),
		'16' => __( 'Toyama Prefecture', 'lifterlms' ),
		'17' => __( 'Ishikawa Prefecture', 'lifterlms' ),
		'18' => __( 'Fukui Prefecture', 'lifterlms' ),
		'19' => __( 'Yamanashi Prefecture', 'lifterlms' ),
		'20' => __( 'Nagano Prefecture', 'lifterlms' ),
		'21' => __( 'Gifu Prefecture', 'lifterlms' ),
		'22' => __( 'Shizuoka Prefecture', 'lifterlms' ),
		'23' => __( 'Aichi Prefecture', 'lifterlms' ),
		'24' => __( 'Mie Prefecture', 'lifterlms' ),
		'25' => __( 'Shiga Prefecture', 'lifterlms' ),
		'26' => __( 'Kyōto Prefecture', 'lifterlms' ),
		'27' => __( 'Ōsaka Prefecture', 'lifterlms' ),
		'28' => __( 'Hyōgo Prefecture', 'lifterlms' ),
		'29' => __( 'Nara Prefecture', 'lifterlms' ),
		'30' => __( 'Wakayama Prefecture', 'lifterlms' ),
		'31' => __( 'Tottori Prefecture', 'lifterlms' ),
		'32' => __( 'Shimane Prefecture', 'lifterlms' ),
		'33' => __( 'Okayama Prefecture', 'lifterlms' ),
		'34' => __( 'Hiroshima Prefecture', 'lifterlms' ),
		'35' => __( 'Yamaguchi Prefecture', 'lifterlms' ),
		'36' => __( 'Tokushima Prefecture', 'lifterlms' ),
		'37' => __( 'Kagawa Prefecture', 'lifterlms' ),
		'38' => __( 'Ehime Prefecture', 'lifterlms' ),
		'40' => __( 'Fukuoka Prefecture', 'lifterlms' ),
		'41' => __( 'Saga Prefecture', 'lifterlms' ),
		'42' => __( 'Nagasaki Prefecture', 'lifterlms' ),
		'43' => __( 'Kumamoto Prefecture', 'lifterlms' ),
		'44' => __( 'Ōita Prefecture', 'lifterlms' ),
		'45' => __( 'Miyazaki Prefecture', 'lifterlms' ),
		'46' => __( 'Kagoshima Prefecture', 'lifterlms' ),
		'47' => __( 'Okinawa Prefecture', 'lifterlms' ),
		'05' => __( 'Akita Prefecture', 'lifterlms' ),
		'02' => __( 'Aomori Prefecture', 'lifterlms' ),
		'07' => __( 'Fukushima Prefecture', 'lifterlms' ),
		'01' => __( 'Hokkaidō Prefecture', 'lifterlms' ),
		'08' => __( 'Ibaraki Prefecture', 'lifterlms' ),
		'03' => __( 'Iwate Prefecture', 'lifterlms' ),
		'04' => __( 'Miyagi Prefecture', 'lifterlms' ),
		'09' => __( 'Tochigi Prefecture', 'lifterlms' ),
		'06' => __( 'Yamagata Prefecture', 'lifterlms' ),
	),
	'KE' => array(
		'10'  => __( 'Kajiado County', 'lifterlms' ),
		'11'  => __( 'Kakamega County', 'lifterlms' ),
		'12'  => __( 'Kericho County', 'lifterlms' ),
		'13'  => __( 'Kiambu County', 'lifterlms' ),
		'14'  => __( 'Kilifi County', 'lifterlms' ),
		'15'  => __( 'Kirinyaga County', 'lifterlms' ),
		'16'  => __( 'Kisii County', 'lifterlms' ),
		'17'  => __( 'Kisumu County', 'lifterlms' ),
		'18'  => __( 'Kitui County', 'lifterlms' ),
		'19'  => __( 'Kwale County', 'lifterlms' ),
		'20'  => __( 'Laikipia County', 'lifterlms' ),
		'21'  => __( 'Lamu County', 'lifterlms' ),
		'22'  => __( 'Machakos County', 'lifterlms' ),
		'23'  => __( 'Makueni County', 'lifterlms' ),
		'24'  => __( 'Mandera County', 'lifterlms' ),
		'25'  => __( 'Marsabit County', 'lifterlms' ),
		'26'  => __( 'Meru County', 'lifterlms' ),
		'27'  => __( 'Migori County', 'lifterlms' ),
		'28'  => __( 'Mombasa County', 'lifterlms' ),
		'29'  => __( 'Muranga County', 'lifterlms' ),
		'31'  => __( 'Nakuru District', 'lifterlms' ),
		'32'  => __( 'Nandi District', 'lifterlms' ),
		'33'  => __( 'Narok County', 'lifterlms' ),
		'34'  => __( 'Nyamira District', 'lifterlms' ),
		'35'  => __( 'Nyandarua County', 'lifterlms' ),
		'36'  => __( 'Nyeri County', 'lifterlms' ),
		'37'  => __( 'Samburu County', 'lifterlms' ),
		'38'  => __( 'Siaya County', 'lifterlms' ),
		'39'  => __( 'Taita–Taveta County', 'lifterlms' ),
		'40'  => __( 'Tana River County', 'lifterlms' ),
		'41'  => __( 'Tharaka Nithi County', 'lifterlms' ),
		'42'  => __( 'Trans-Nzoia District', 'lifterlms' ),
		'43'  => __( 'Turkana County', 'lifterlms' ),
		'44'  => __( 'Uasin Gishu District', 'lifterlms' ),
		'45'  => __( 'Vihiga District', 'lifterlms' ),
		'46'  => __( 'Wajir County', 'lifterlms' ),
		'47'  => __( 'West Pokot County', 'lifterlms' ),
		'110' => __( 'Nairobi', 'lifterlms' ),
		'200' => __( 'Central Province', 'lifterlms' ),
		'300' => __( 'Coast Province', 'lifterlms' ),
		'400' => __( 'Eastern Province', 'lifterlms' ),
		'500' => __( 'North Eastern Province', 'lifterlms' ),
		'600' => __( 'Nyanza Province', 'lifterlms' ),
		'700' => __( 'Rift Valley Province', 'lifterlms' ),
		'800' => __( 'Western Province', 'lifterlms' ),
		'01'  => __( 'Baringo County', 'lifterlms' ),
		'02'  => __( 'Bomet County', 'lifterlms' ),
		'03'  => __( 'Bungoma County', 'lifterlms' ),
		'04'  => __( 'Busia County', 'lifterlms' ),
		'05'  => __( 'Elgeyo-Marakwet County', 'lifterlms' ),
		'06'  => __( 'Embu County', 'lifterlms' ),
		'07'  => __( 'Garissa County', 'lifterlms' ),
		'08'  => __( 'Homa Bay County', 'lifterlms' ),
		'09'  => __( 'Isiolo County', 'lifterlms' ),
	),
	'KG' => array(
		'B'  => __( 'Batken Region', 'lifterlms' ),
		'GB' => __( 'Bishkek', 'lifterlms' ),
		'C'  => __( 'Chuy Region', 'lifterlms' ),
		'Y'  => __( 'Issyk-Kul Region', 'lifterlms' ),
		'J'  => __( 'Jalal-Abad Region', 'lifterlms' ),
		'N'  => __( 'Naryn Region', 'lifterlms' ),
		'GO' => __( 'Osh', 'lifterlms' ),
		'O'  => __( 'Osh Region', 'lifterlms' ),
		'T'  => __( 'Talas Region', 'lifterlms' ),
	),
	'KH' => array(
		'1'  => __( 'Banteay Meanchey Province', 'lifterlms' ),
		'2'  => __( 'Battambang Province', 'lifterlms' ),
		'3'  => __( 'Kampong Cham Province', 'lifterlms' ),
		'4'  => __( 'Kampong Chhnang Province', 'lifterlms' ),
		'5'  => __( 'Kampong Speu Province', 'lifterlms' ),
		'7'  => __( 'Kampot Province', 'lifterlms' ),
		'8'  => __( 'Kandal Province', 'lifterlms' ),
		'9'  => __( 'Koh Kong Province', 'lifterlms' ),
		'10' => __( 'Kratié Province', 'lifterlms' ),
		'11' => __( 'Mondulkiri Province', 'lifterlms' ),
		'12' => __( 'Phnom Penh', 'lifterlms' ),
		'13' => __( 'Preah Vihear Province', 'lifterlms' ),
		'14' => __( 'Prey Veng Province', 'lifterlms' ),
		'15' => __( 'Pursat Province', 'lifterlms' ),
		'16' => __( 'Ratanakiri Province', 'lifterlms' ),
		'17' => __( 'Siem Reap Province', 'lifterlms' ),
		'18' => __( 'Sihanoukville Province', 'lifterlms' ),
		'19' => __( 'Stung Treng Province', 'lifterlms' ),
		'20' => __( 'Svay Rieng Province', 'lifterlms' ),
		'21' => __( 'Takéo Province', 'lifterlms' ),
		'22' => __( 'Oddar Meanchey Province', 'lifterlms' ),
		'23' => __( 'Kep Province', 'lifterlms' ),
		'24' => __( 'Pailin Province', 'lifterlms' ),
	),
	'KI' => array(
		'G' => __( 'Gilbert Islands', 'lifterlms' ),
		'L' => __( 'Line Islands', 'lifterlms' ),
		'P' => __( 'Phoenix Islands', 'lifterlms' ),
	),
	'KM' => array(
		'A' => __( 'Anjouan', 'lifterlms' ),
		'G' => __( 'Grande Comore', 'lifterlms' ),
		'M' => __( 'Mohéli', 'lifterlms' ),
	),
	'KN' => array(
		'10' => __( 'Saint Paul Charlestown Parish', 'lifterlms' ),
		'11' => __( 'Saint Peter Basseterre Parish', 'lifterlms' ),
		'12' => __( 'Saint Thomas Lowland Parish', 'lifterlms' ),
		'13' => __( 'Saint Thomas Middle Island Parish', 'lifterlms' ),
		'15' => __( 'Trinity Palmetto Point Parish', 'lifterlms' ),
		'01' => __( 'Christ Church Nichola Town Parish', 'lifterlms' ),
		'N'  => __( 'Nevis', 'lifterlms' ),
		'02' => __( 'Saint Anne Sandy Point Parish', 'lifterlms' ),
		'04' => __( 'Saint George Gingerland Parish', 'lifterlms' ),
		'05' => __( 'Saint James Windward Parish', 'lifterlms' ),
		'06' => __( 'Saint John Capisterre Parish', 'lifterlms' ),
		'07' => __( 'Saint John Figtree Parish', 'lifterlms' ),
		'K'  => __( 'Saint Kitts', 'lifterlms' ),
		'08' => __( 'Saint Mary Cayon Parish', 'lifterlms' ),
		'09' => __( 'Saint Paul Capisterre Parish', 'lifterlms' ),
	),
	'KP' => array(
		'10' => __( 'Ryanggang Province', 'lifterlms' ),
		'13' => __( 'Rason', 'lifterlms' ),
		'04' => __( 'Chagang Province', 'lifterlms' ),
		'07' => __( 'Kangwon Province', 'lifterlms' ),
		'09' => __( 'North Hamgyong Province', 'lifterlms' ),
		'06' => __( 'North Hwanghae Province', 'lifterlms' ),
		'03' => __( 'North Pyongan Province', 'lifterlms' ),
		'01' => __( 'Pyongyang', 'lifterlms' ),
		'08' => __( 'South Hamgyong Province', 'lifterlms' ),
		'05' => __( 'South Hwanghae Province', 'lifterlms' ),
		'02' => __( 'South Pyongan Province', 'lifterlms' ),
	),
	'KR' => array(
		'11' => __( 'Seoul', 'lifterlms' ),
		'26' => __( 'Busan', 'lifterlms' ),
		'27' => __( 'Daegu', 'lifterlms' ),
		'28' => __( 'Incheon', 'lifterlms' ),
		'29' => __( 'Gwangju', 'lifterlms' ),
		'30' => __( 'Daejeon', 'lifterlms' ),
		'31' => __( 'Ulsan', 'lifterlms' ),
		'41' => __( 'Gyeonggi Province', 'lifterlms' ),
		'42' => __( 'Gangwon Province', 'lifterlms' ),
		'43' => __( 'North Chungcheong Province', 'lifterlms' ),
		'44' => __( 'South Chungcheong Province', 'lifterlms' ),
		'45' => __( 'North Jeolla Province', 'lifterlms' ),
		'46' => __( 'South Jeolla Province', 'lifterlms' ),
		'47' => __( 'North Gyeongsang Province', 'lifterlms' ),
		'48' => __( 'South Gyeongsang Province', 'lifterlms' ),
		'49' => __( 'Jeju', 'lifterlms' ),
		'50' => __( 'Sejong City', 'lifterlms' ),
	),
	'KW' => array(
		'AH' => __( 'Al Ahmadi Governorate', 'lifterlms' ),
		'FA' => __( 'Al Farwaniyah Governorate', 'lifterlms' ),
		'JA' => __( 'Al Jahra Governorate', 'lifterlms' ),
		'KU' => __( 'Capital Governorate', 'lifterlms' ),
		'HA' => __( 'Hawalli Governorate', 'lifterlms' ),
		'MU' => __( 'Mubarak Al-Kabeer Governorate', 'lifterlms' ),
	),
	'KY' => array(),
	'KZ' => array(
		'AKM' => __( 'Akmola Region', 'lifterlms' ),
		'AKT' => __( 'Aktobe Region', 'lifterlms' ),
		'ALA' => __( 'Almaty', 'lifterlms' ),
		'ALM' => __( 'Almaty Region', 'lifterlms' ),
		'ATY' => __( 'Atyrau Region', 'lifterlms' ),
		'BAY' => __( 'Baikonur', 'lifterlms' ),
		'VOS' => __( 'East Kazakhstan Region', 'lifterlms' ),
		'ZHA' => __( 'Jambyl Region', 'lifterlms' ),
		'KAR' => __( 'Karaganda Region', 'lifterlms' ),
		'KUS' => __( 'Kostanay Region', 'lifterlms' ),
		'KZY' => __( 'Kyzylorda Region', 'lifterlms' ),
		'MAN' => __( 'Mangystau Region', 'lifterlms' ),
		'SEV' => __( 'North Kazakhstan Region', 'lifterlms' ),
		'AST' => __( 'Nur-Sultan', 'lifterlms' ),
		'PAV' => __( 'Pavlodar Region', 'lifterlms' ),
		'YUZ' => __( 'Turkestan Region', 'lifterlms' ),
		'ZAP' => __( 'West Kazakhstan Province', 'lifterlms' ),
	),
	'LA' => array(
		'AT' => __( 'Attapeu Province', 'lifterlms' ),
		'BK' => __( 'Bokeo Province', 'lifterlms' ),
		'BL' => __( 'Bolikhamsai Province', 'lifterlms' ),
		'CH' => __( 'Champasak Province', 'lifterlms' ),
		'HO' => __( 'Houaphanh Province', 'lifterlms' ),
		'KH' => __( 'Khammouane Province', 'lifterlms' ),
		'LM' => __( 'Luang Namtha Province', 'lifterlms' ),
		'LP' => __( 'Luang Prabang Province', 'lifterlms' ),
		'OU' => __( 'Oudomxay Province', 'lifterlms' ),
		'PH' => __( 'Phongsaly Province', 'lifterlms' ),
		'XA' => __( 'Sainyabuli Province', 'lifterlms' ),
		'SL' => __( 'Salavan Province', 'lifterlms' ),
		'SV' => __( 'Savannakhet Province', 'lifterlms' ),
		'XE' => __( 'Sekong Province', 'lifterlms' ),
		'VT' => __( 'Vientiane Prefecture', 'lifterlms' ),
		'VI' => __( 'Vientiane Province', 'lifterlms' ),
		'XN' => __( 'Xaisomboun', 'lifterlms' ),
		'XS' => __( 'Xaisomboun Province', 'lifterlms' ),
		'XI' => __( 'Xiangkhouang Province', 'lifterlms' ),
	),
	'LB' => array(
		'AK' => __( 'Akkar Governorate', 'lifterlms' ),
		'BH' => __( 'Baalbek-Hermel Governorate', 'lifterlms' ),
		'BA' => __( 'Beirut Governorate', 'lifterlms' ),
		'BI' => __( 'Beqaa Governorate', 'lifterlms' ),
		'JL' => __( 'Mount Lebanon Governorate', 'lifterlms' ),
		'NA' => __( 'Nabatieh Governorate', 'lifterlms' ),
		'AS' => __( 'North Governorate', 'lifterlms' ),
		'JA' => __( 'South Governorate', 'lifterlms' ),
	),
	'LC' => array(
		'10' => __( 'Soufrière Quarter', 'lifterlms' ),
		'11' => __( 'Vieux Fort Quarter', 'lifterlms' ),
		'12' => __( 'Canaries', 'lifterlms' ),
		'01' => __( 'Anse la Raye Quarter', 'lifterlms' ),
		'02' => __( 'Castries Quarter', 'lifterlms' ),
		'03' => __( 'Choiseul Quarter', 'lifterlms' ),
		'04' => __( 'Dauphin Quarter', 'lifterlms' ),
		'05' => __( 'Dennery Quarter', 'lifterlms' ),
		'06' => __( 'Gros Islet Quarter', 'lifterlms' ),
		'07' => __( 'Laborie Quarter', 'lifterlms' ),
		'08' => __( 'Micoud Quarter', 'lifterlms' ),
		'09' => __( 'Praslin Quarter', 'lifterlms' ),
	),
	'LI' => array(
		'10' => __( 'Triesenberg', 'lifterlms' ),
		'11' => __( 'Vaduz', 'lifterlms' ),
		'01' => __( 'Balzers', 'lifterlms' ),
		'02' => __( 'Eschen', 'lifterlms' ),
		'03' => __( 'Gamprin', 'lifterlms' ),
		'04' => __( 'Mauren', 'lifterlms' ),
		'05' => __( 'Planken', 'lifterlms' ),
		'06' => __( 'Ruggell', 'lifterlms' ),
		'07' => __( 'Schaan', 'lifterlms' ),
		'08' => __( 'Schellenberg', 'lifterlms' ),
		'09' => __( 'Triesen', 'lifterlms' ),
	),
	'LK' => array(
		'1'  => __( 'Western Province', 'lifterlms' ),
		'2'  => __( 'Central Province', 'lifterlms' ),
		'3'  => __( 'Southern Province', 'lifterlms' ),
		'4'  => __( 'Northern Province', 'lifterlms' ),
		'5'  => __( 'Eastern Province', 'lifterlms' ),
		'6'  => __( 'North Western Province', 'lifterlms' ),
		'7'  => __( 'North Central Province', 'lifterlms' ),
		'8'  => __( 'Uva Province', 'lifterlms' ),
		'9'  => __( 'Sabaragamuwa Province', 'lifterlms' ),
		'11' => __( 'Colombo District', 'lifterlms' ),
		'12' => __( 'Gampaha District', 'lifterlms' ),
		'13' => __( 'Kalutara District', 'lifterlms' ),
		'21' => __( 'Kandy District', 'lifterlms' ),
		'22' => __( 'Matale District', 'lifterlms' ),
		'23' => __( 'Nuwara Eliya District', 'lifterlms' ),
		'31' => __( 'Galle District', 'lifterlms' ),
		'32' => __( 'Matara District', 'lifterlms' ),
		'33' => __( 'Hambantota District', 'lifterlms' ),
		'41' => __( 'Jaffna District', 'lifterlms' ),
		'42' => __( 'Kilinochchi District', 'lifterlms' ),
		'43' => __( 'Mannar District', 'lifterlms' ),
		'44' => __( 'Vavuniya District', 'lifterlms' ),
		'45' => __( 'Mullaitivu District', 'lifterlms' ),
		'51' => __( 'Batticaloa District', 'lifterlms' ),
		'52' => __( 'Ampara District', 'lifterlms' ),
		'53' => __( 'Trincomalee District', 'lifterlms' ),
		'62' => __( 'Puttalam District', 'lifterlms' ),
		'71' => __( 'Anuradhapura District', 'lifterlms' ),
		'72' => __( 'Polonnaruwa District', 'lifterlms' ),
		'81' => __( 'Badulla District', 'lifterlms' ),
		'82' => __( 'Monaragala District', 'lifterlms' ),
		'91' => __( 'Ratnapura district', 'lifterlms' ),
		'92' => __( 'Kegalle District', 'lifterlms' ),
	),
	'LR' => array(
		'BM' => __( 'Bomi County', 'lifterlms' ),
		'BG' => __( 'Bong County', 'lifterlms' ),
		'GP' => __( 'Gbarpolu County', 'lifterlms' ),
		'GB' => __( 'Grand Bassa County', 'lifterlms' ),
		'CM' => __( 'Grand Cape Mount County', 'lifterlms' ),
		'GG' => __( 'Grand Gedeh County', 'lifterlms' ),
		'GK' => __( 'Grand Kru County', 'lifterlms' ),
		'LO' => __( 'Lofa County', 'lifterlms' ),
		'MG' => __( 'Margibi County', 'lifterlms' ),
		'MY' => __( 'Maryland County', 'lifterlms' ),
		'MO' => __( 'Montserrado County', 'lifterlms' ),
		'NI' => __( 'Nimba', 'lifterlms' ),
		'RI' => __( 'River Cess County', 'lifterlms' ),
		'RG' => __( 'River Gee County', 'lifterlms' ),
		'SI' => __( 'Sinoe County', 'lifterlms' ),
	),
	'LS' => array(
		'D' => __( 'Berea District', 'lifterlms' ),
		'B' => __( 'Butha-Buthe District', 'lifterlms' ),
		'C' => __( 'Leribe District', 'lifterlms' ),
		'E' => __( 'Mafeteng District', 'lifterlms' ),
		'A' => __( 'Maseru District', 'lifterlms' ),
		'F' => __( 'Mohale\'s Hoek District', 'lifterlms' ),
		'J' => __( 'Mokhotlong District', 'lifterlms' ),
		'H' => __( 'Qacha\'s Nek District', 'lifterlms' ),
		'G' => __( 'Quthing District', 'lifterlms' ),
		'K' => __( 'Thaba-Tseka District', 'lifterlms' ),
	),
	'LT' => array(
		'10' => __( 'Jonava District Municipality', 'lifterlms' ),
		'11' => __( 'Joniškis District Municipality', 'lifterlms' ),
		'12' => __( 'Jurbarkas District Municipality', 'lifterlms' ),
		'13' => __( 'Kaišiadorys District Municipality', 'lifterlms' ),
		'14' => __( 'Kalvarija municipality', 'lifterlms' ),
		'15' => __( 'Kaunas City Municipality', 'lifterlms' ),
		'16' => __( 'Kaunas District Municipality', 'lifterlms' ),
		'17' => __( 'Kazlų Rūda municipality', 'lifterlms' ),
		'18' => __( 'Kėdainiai District Municipality', 'lifterlms' ),
		'19' => __( 'Kelmė District Municipality', 'lifterlms' ),
		'20' => __( 'Klaipeda City Municipality', 'lifterlms' ),
		'21' => __( 'Klaipėda District Municipality', 'lifterlms' ),
		'22' => __( 'Kretinga District Municipality', 'lifterlms' ),
		'23' => __( 'Kupiškis District Municipality', 'lifterlms' ),
		'24' => __( 'Lazdijai District Municipality', 'lifterlms' ),
		'25' => __( 'Marijampolė Municipality', 'lifterlms' ),
		'26' => __( 'Mažeikiai District Municipality', 'lifterlms' ),
		'27' => __( 'Molėtai District Municipality', 'lifterlms' ),
		'28' => __( 'Neringa Municipality', 'lifterlms' ),
		'29' => __( 'Pagėgiai municipality', 'lifterlms' ),
		'30' => __( 'Pakruojis District Municipality', 'lifterlms' ),
		'31' => __( 'Palanga City Municipality', 'lifterlms' ),
		'32' => __( 'Panevėžys City Municipality', 'lifterlms' ),
		'33' => __( 'Panevėžys District Municipality', 'lifterlms' ),
		'34' => __( 'Pasvalys District Municipality', 'lifterlms' ),
		'35' => __( 'Plungė District Municipality', 'lifterlms' ),
		'36' => __( 'Prienai District Municipality', 'lifterlms' ),
		'37' => __( 'Radviliškis District Municipality', 'lifterlms' ),
		'38' => __( 'Raseiniai District Municipality', 'lifterlms' ),
		'39' => __( 'Rietavas municipality', 'lifterlms' ),
		'40' => __( 'Rokiškis District Municipality', 'lifterlms' ),
		'41' => __( 'Šakiai District Municipality', 'lifterlms' ),
		'42' => __( 'Šalčininkai District Municipality', 'lifterlms' ),
		'43' => __( 'Šiauliai City Municipality', 'lifterlms' ),
		'44' => __( 'Šiauliai District Municipality', 'lifterlms' ),
		'45' => __( 'Šilalė District Municipality', 'lifterlms' ),
		'46' => __( 'Šilutė District Municipality', 'lifterlms' ),
		'47' => __( 'Širvintos District Municipality', 'lifterlms' ),
		'48' => __( 'Skuodas District Municipality', 'lifterlms' ),
		'49' => __( 'Švenčionys District Municipality', 'lifterlms' ),
		'50' => __( 'Tauragė District Municipality', 'lifterlms' ),
		'51' => __( 'Telšiai District Municipality', 'lifterlms' ),
		'52' => __( 'Trakai District Municipality', 'lifterlms' ),
		'53' => __( 'Ukmergė District Municipality', 'lifterlms' ),
		'54' => __( 'Utena District Municipality', 'lifterlms' ),
		'55' => __( 'Varėna District Municipality', 'lifterlms' ),
		'56' => __( 'Vilkaviškis District Municipality', 'lifterlms' ),
		'57' => __( 'Vilnius City Municipality', 'lifterlms' ),
		'58' => __( 'Vilnius District Municipality', 'lifterlms' ),
		'59' => __( 'Visaginas Municipality', 'lifterlms' ),
		'60' => __( 'Zarasai District Municipality', 'lifterlms' ),
		'01' => __( 'Akmenė District Municipality', 'lifterlms' ),
		'02' => __( 'Alytus City Municipality', 'lifterlms' ),
		'AL' => __( 'Alytus County', 'lifterlms' ),
		'03' => __( 'Alytus District Municipality', 'lifterlms' ),
		'05' => __( 'Birštonas Municipality', 'lifterlms' ),
		'06' => __( 'Biržai District Municipality', 'lifterlms' ),
		'07' => __( 'Druskininkai municipality', 'lifterlms' ),
		'08' => __( 'Elektrėnai municipality', 'lifterlms' ),
		'09' => __( 'Ignalina District Municipality', 'lifterlms' ),
		'KU' => __( 'Kaunas County', 'lifterlms' ),
		'KL' => __( 'Klaipėda County', 'lifterlms' ),
		'MR' => __( 'Marijampolė County', 'lifterlms' ),
		'PN' => __( 'Panevėžys County', 'lifterlms' ),
		'TA' => __( 'Tauragė County', 'lifterlms' ),
		'TE' => __( 'Telšiai County', 'lifterlms' ),
		'UT' => __( 'Utena County', 'lifterlms' ),
		'VL' => __( 'Vilnius County', 'lifterlms' ),
		'SA' => __( 'Šiauliai County', 'lifterlms' ),
	),
	'LU' => array(
		'CA' => __( 'Canton of Capellen', 'lifterlms' ),
		'CL' => __( 'Canton of Clervaux', 'lifterlms' ),
		'DI' => __( 'Canton of Diekirch', 'lifterlms' ),
		'EC' => __( 'Canton of Echternach', 'lifterlms' ),
		'ES' => __( 'Canton of Esch-sur-Alzette', 'lifterlms' ),
		'GR' => __( 'Canton of Grevenmacher', 'lifterlms' ),
		'LU' => __( 'Canton of Luxembourg', 'lifterlms' ),
		'ME' => __( 'Canton of Mersch', 'lifterlms' ),
		'RD' => __( 'Canton of Redange', 'lifterlms' ),
		'RM' => __( 'Canton of Remich', 'lifterlms' ),
		'VD' => __( 'Canton of Vianden', 'lifterlms' ),
		'WI' => __( 'Canton of Wiltz', 'lifterlms' ),
		'D'  => __( 'Diekirch District', 'lifterlms' ),
		'G'  => __( 'Grevenmacher District', 'lifterlms' ),
		'L'  => __( 'Luxembourg District', 'lifterlms' ),
	),
	'LV' => array(
		'100' => __( 'Vaiņode Municipality', 'lifterlms' ),
		'101' => __( 'Valka Municipality', 'lifterlms' ),
		'102' => __( 'Varakļāni Municipality', 'lifterlms' ),
		'103' => __( 'Vārkava Municipality', 'lifterlms' ),
		'104' => __( 'Vecpiebalga Municipality', 'lifterlms' ),
		'105' => __( 'Vecumnieki Municipality', 'lifterlms' ),
		'106' => __( 'Ventspils Municipality', 'lifterlms' ),
		'107' => __( 'Viesīte Municipality', 'lifterlms' ),
		'108' => __( 'Viļaka Municipality', 'lifterlms' ),
		'109' => __( 'Viļāni Municipality', 'lifterlms' ),
		'110' => __( 'Zilupe Municipality', 'lifterlms' ),
		'001' => __( 'Aglona Municipality', 'lifterlms' ),
		'002' => __( 'Aizkraukle Municipality', 'lifterlms' ),
		'003' => __( 'Aizpute Municipality', 'lifterlms' ),
		'004' => __( 'Aknīste Municipality', 'lifterlms' ),
		'005' => __( 'Aloja Municipality', 'lifterlms' ),
		'006' => __( 'Alsunga Municipality', 'lifterlms' ),
		'007' => __( 'Alūksne Municipality', 'lifterlms' ),
		'008' => __( 'Amata Municipality', 'lifterlms' ),
		'009' => __( 'Ape Municipality', 'lifterlms' ),
		'010' => __( 'Auce Municipality', 'lifterlms' ),
		'012' => __( 'Babīte Municipality', 'lifterlms' ),
		'013' => __( 'Baldone Municipality', 'lifterlms' ),
		'014' => __( 'Baltinava Municipality', 'lifterlms' ),
		'015' => __( 'Balvi Municipality', 'lifterlms' ),
		'016' => __( 'Bauska Municipality', 'lifterlms' ),
		'017' => __( 'Beverīna Municipality', 'lifterlms' ),
		'018' => __( 'Brocēni Municipality', 'lifterlms' ),
		'019' => __( 'Burtnieki Municipality', 'lifterlms' ),
		'020' => __( 'Carnikava Municipality', 'lifterlms' ),
		'021' => __( 'Cesvaine Municipality', 'lifterlms' ),
		'023' => __( 'Cibla Municipality', 'lifterlms' ),
		'022' => __( 'Cēsis Municipality', 'lifterlms' ),
		'024' => __( 'Dagda Municipality', 'lifterlms' ),
		'DGV' => __( 'Daugavpils', 'lifterlms' ),
		'025' => __( 'Daugavpils Municipality', 'lifterlms' ),
		'026' => __( 'Dobele Municipality', 'lifterlms' ),
		'027' => __( 'Dundaga Municipality', 'lifterlms' ),
		'028' => __( 'Durbe Municipality', 'lifterlms' ),
		'029' => __( 'Engure Municipality', 'lifterlms' ),
		'031' => __( 'Garkalne Municipality', 'lifterlms' ),
		'032' => __( 'Grobiņa Municipality', 'lifterlms' ),
		'033' => __( 'Gulbene Municipality', 'lifterlms' ),
		'034' => __( 'Iecava Municipality', 'lifterlms' ),
		'035' => __( 'Ikšķile Municipality', 'lifterlms' ),
		'036' => __( 'Ilūkste Municipality', 'lifterlms' ),
		'037' => __( 'Inčukalns Municipality', 'lifterlms' ),
		'038' => __( 'Jaunjelgava Municipality', 'lifterlms' ),
		'039' => __( 'Jaunpiebalga Municipality', 'lifterlms' ),
		'040' => __( 'Jaunpils Municipality', 'lifterlms' ),
		'JEL' => __( 'Jelgava', 'lifterlms' ),
		'041' => __( 'Jelgava Municipality', 'lifterlms' ),
		'JKB' => __( 'Jēkabpils', 'lifterlms' ),
		'042' => __( 'Jēkabpils Municipality', 'lifterlms' ),
		'JUR' => __( 'Jūrmala', 'lifterlms' ),
		'043' => __( 'Kandava Municipality', 'lifterlms' ),
		'045' => __( 'Kocēni Municipality', 'lifterlms' ),
		'046' => __( 'Koknese Municipality', 'lifterlms' ),
		'048' => __( 'Krimulda Municipality', 'lifterlms' ),
		'049' => __( 'Krustpils Municipality', 'lifterlms' ),
		'047' => __( 'Krāslava Municipality', 'lifterlms' ),
		'050' => __( 'Kuldīga Municipality', 'lifterlms' ),
		'044' => __( 'Kārsava Municipality', 'lifterlms' ),
		'053' => __( 'Lielvārde Municipality', 'lifterlms' ),
		'LPX' => __( 'Liepāja', 'lifterlms' ),
		'054' => __( 'Limbaži Municipality', 'lifterlms' ),
		'057' => __( 'Lubāna Municipality', 'lifterlms' ),
		'058' => __( 'Ludza Municipality', 'lifterlms' ),
		'055' => __( 'Līgatne Municipality', 'lifterlms' ),
		'056' => __( 'Līvāni Municipality', 'lifterlms' ),
		'059' => __( 'Madona Municipality', 'lifterlms' ),
		'060' => __( 'Mazsalaca Municipality', 'lifterlms' ),
		'061' => __( 'Mālpils Municipality', 'lifterlms' ),
		'062' => __( 'Mārupe Municipality', 'lifterlms' ),
		'063' => __( 'Mērsrags Municipality', 'lifterlms' ),
		'064' => __( 'Naukšēni Municipality', 'lifterlms' ),
		'065' => __( 'Nereta Municipality', 'lifterlms' ),
		'066' => __( 'Nīca Municipality', 'lifterlms' ),
		'067' => __( 'Ogre Municipality', 'lifterlms' ),
		'068' => __( 'Olaine Municipality', 'lifterlms' ),
		'069' => __( 'Ozolnieki Municipality', 'lifterlms' ),
		'073' => __( 'Preiļi Municipality', 'lifterlms' ),
		'074' => __( 'Priekule Municipality', 'lifterlms' ),
		'075' => __( 'Priekuļi Municipality', 'lifterlms' ),
		'070' => __( 'Pārgauja Municipality', 'lifterlms' ),
		'071' => __( 'Pāvilosta Municipality', 'lifterlms' ),
		'072' => __( 'Pļaviņas Municipality', 'lifterlms' ),
		'076' => __( 'Rauna Municipality', 'lifterlms' ),
		'078' => __( 'Riebiņi Municipality', 'lifterlms' ),
		'RIX' => __( 'Riga', 'lifterlms' ),
		'079' => __( 'Roja Municipality', 'lifterlms' ),
		'080' => __( 'Ropaži Municipality', 'lifterlms' ),
		'081' => __( 'Rucava Municipality', 'lifterlms' ),
		'082' => __( 'Rugāji Municipality', 'lifterlms' ),
		'083' => __( 'Rundāle Municipality', 'lifterlms' ),
		'REZ' => __( 'Rēzekne', 'lifterlms' ),
		'077' => __( 'Rēzekne Municipality', 'lifterlms' ),
		'084' => __( 'Rūjiena Municipality', 'lifterlms' ),
		'085' => __( 'Sala Municipality', 'lifterlms' ),
		'086' => __( 'Salacgrīva Municipality', 'lifterlms' ),
		'087' => __( 'Salaspils Municipality', 'lifterlms' ),
		'088' => __( 'Saldus Municipality', 'lifterlms' ),
		'089' => __( 'Saulkrasti Municipality', 'lifterlms' ),
		'091' => __( 'Sigulda Municipality', 'lifterlms' ),
		'093' => __( 'Skrunda Municipality', 'lifterlms' ),
		'092' => __( 'Skrīveri Municipality', 'lifterlms' ),
		'094' => __( 'Smiltene Municipality', 'lifterlms' ),
		'095' => __( 'Stopiņi Municipality', 'lifterlms' ),
		'096' => __( 'Strenči Municipality', 'lifterlms' ),
		'090' => __( 'Sēja Municipality', 'lifterlms' ),
		'097' => __( 'Talsi Municipality', 'lifterlms' ),
		'099' => __( 'Tukums Municipality', 'lifterlms' ),
		'098' => __( 'Tērvete Municipality', 'lifterlms' ),
		'VMR' => __( 'Valmiera', 'lifterlms' ),
		'VEN' => __( 'Ventspils', 'lifterlms' ),
		'030' => __( 'Ērgļi Municipality', 'lifterlms' ),
		'051' => __( 'Ķegums Municipality', 'lifterlms' ),
		'052' => __( 'Ķekava Municipality', 'lifterlms' ),
	),
	'LY' => array(
		'WA' => __( 'Al Wahat District', 'lifterlms' ),
		'BA' => __( 'Benghazi', 'lifterlms' ),
		'DR' => __( 'Derna District', 'lifterlms' ),
		'GT' => __( 'Ghat District', 'lifterlms' ),
		'JA' => __( 'Jabal al Akhdar', 'lifterlms' ),
		'JG' => __( 'Jabal al Gharbi District', 'lifterlms' ),
		'JI' => __( 'Jafara', 'lifterlms' ),
		'JU' => __( 'Jufra', 'lifterlms' ),
		'KF' => __( 'Kufra District', 'lifterlms' ),
		'MJ' => __( 'Marj District', 'lifterlms' ),
		'MI' => __( 'Misrata District', 'lifterlms' ),
		'MB' => __( 'Murqub', 'lifterlms' ),
		'MQ' => __( 'Murzuq District', 'lifterlms' ),
		'NL' => __( 'Nalut District', 'lifterlms' ),
		'NQ' => __( 'Nuqat al Khams', 'lifterlms' ),
		'SB' => __( 'Sabha District', 'lifterlms' ),
		'SR' => __( 'Sirte District', 'lifterlms' ),
		'TB' => __( 'Tripoli District', 'lifterlms' ),
		'WD' => __( 'Wadi al Hayaa District', 'lifterlms' ),
		'WS' => __( 'Wadi al Shatii District', 'lifterlms' ),
		'ZA' => __( 'Zawiya District', 'lifterlms' ),
	),
	'MA' => array(
		'10'  => __( 'Guelmim-Oued Noun', 'lifterlms' ),
		'11'  => __( 'Laâyoune-Sakia El Hamra', 'lifterlms' ),
		'12'  => __( 'Dakhla-Oued Ed-Dahab', 'lifterlms' ),
		'HAO' => __( 'Al Haouz Province', 'lifterlms' ),
		'HOC' => __( 'Al Hoceïma Province', 'lifterlms' ),
		'AOU' => __( 'Aousserd Province', 'lifterlms' ),
		'ASZ' => __( 'Assa-Zag Province', 'lifterlms' ),
		'AZI' => __( 'Azilal Province', 'lifterlms' ),
		'BES' => __( 'Ben Slimane Province', 'lifterlms' ),
		'BER' => __( 'Berkane Province', 'lifterlms' ),
		'BOD' => __( 'Boujdour Province', 'lifterlms' ),
		'BOM' => __( 'Boulemane Province', 'lifterlms' ),
		'05'  => __( 'Béni Mellal-Khénifra', 'lifterlms' ),
		'BEM' => __( 'Béni-Mellal Province', 'lifterlms' ),
		'06'  => __( 'Casablanca-Settat', 'lifterlms' ),
		'CHE' => __( 'Chefchaouen Province', 'lifterlms' ),
		'CHI' => __( 'Chichaoua Province', 'lifterlms' ),
		'08'  => __( 'Drâa-Tafilalet', 'lifterlms' ),
		'HAJ' => __( 'El Hajeb Province', 'lifterlms' ),
		'JDI' => __( 'El Jadida Province', 'lifterlms' ),
		'ERR' => __( 'Errachidia Province', 'lifterlms' ),
		'ESM' => __( 'Es Semara Province', 'lifterlms' ),
		'ESI' => __( 'Essaouira Province', 'lifterlms' ),
		'FAH' => __( 'Fahs Anjra Province', 'lifterlms' ),
		'FIG' => __( 'Figuig Province', 'lifterlms' ),
		'03'  => __( 'Fès-Meknès', 'lifterlms' ),
		'GUE' => __( 'Guelmim Province', 'lifterlms' ),
		'IFR' => __( 'Ifrane Province', 'lifterlms' ),
		'INE' => __( 'Inezgane-Aït Melloul Prefecture', 'lifterlms' ),
		'JRA' => __( 'Jerada Province', 'lifterlms' ),
		'KES' => __( 'Kelaat Sraghna Province', 'lifterlms' ),
		'KHO' => __( 'Khouribga Province', 'lifterlms' ),
		'KHE' => __( 'Khémisset Province', 'lifterlms' ),
		'KHN' => __( 'Khénifra Province', 'lifterlms' ),
		'KEN' => __( 'Kénitra Province', 'lifterlms' ),
		'LAR' => __( 'Larache Province', 'lifterlms' ),
		'LAA' => __( 'Laâyoune Province', 'lifterlms' ),
		'07'  => __( 'Marrakesh-Safi', 'lifterlms' ),
		'MED' => __( 'Mediouna Province', 'lifterlms' ),
		'MOU' => __( 'Moulay Yacoub Province', 'lifterlms' ),
		'NAD' => __( 'Nador Province', 'lifterlms' ),
		'NOU' => __( 'Nouaceur Province', 'lifterlms' ),
		'02'  => __( 'Oriental', 'lifterlms' ),
		'OUA' => __( 'Ouarzazate Province', 'lifterlms' ),
		'OUD' => __( 'Oued Ed-Dahab Province', 'lifterlms' ),
		'SAF' => __( 'Safi Province', 'lifterlms' ),
		'SEF' => __( 'Sefrou Province', 'lifterlms' ),
		'SET' => __( 'Settat Province', 'lifterlms' ),
		'CHT' => __( 'Shtouka Ait Baha Province', 'lifterlms' ),
		'SIK' => __( 'Sidi Kacem Province', 'lifterlms' ),
		'SYB' => __( 'Sidi Youssef Ben Ali', 'lifterlms' ),
		'09'  => __( 'Souss-Massa', 'lifterlms' ),
		'TNT' => __( 'Tan-Tan Province', 'lifterlms' ),
		'01'  => __( 'Tanger-Tétouan-Al Hoceïma', 'lifterlms' ),
		'TAO' => __( 'Taounate Province', 'lifterlms' ),
		'TAI' => __( 'Taourirt Province', 'lifterlms' ),
		'TAR' => __( 'Taroudant Province', 'lifterlms' ),
		'TAT' => __( 'Tata Province', 'lifterlms' ),
		'TAZ' => __( 'Taza Province', 'lifterlms' ),
		'TIZ' => __( 'Tiznit Province', 'lifterlms' ),
		'TET' => __( 'Tétouan Province', 'lifterlms' ),
		'ZAG' => __( 'Zagora Province', 'lifterlms' ),
	),
	'MC' => array(
		'CL' => __( 'La Colle', 'lifterlms' ),
		'CO' => __( 'La Condamine', 'lifterlms' ),
		'MG' => __( 'Moneghetti', 'lifterlms' ),
	),
	'MD' => array(
		'AN' => __( 'Anenii Noi District', 'lifterlms' ),
		'BS' => __( 'Basarabeasca District', 'lifterlms' ),
		'BD' => __( 'Bender Municipality', 'lifterlms' ),
		'BR' => __( 'Briceni District', 'lifterlms' ),
		'BA' => __( 'Bălți Municipality', 'lifterlms' ),
		'CA' => __( 'Cahul District', 'lifterlms' ),
		'CT' => __( 'Cantemir District', 'lifterlms' ),
		'CU' => __( 'Chișinău Municipality', 'lifterlms' ),
		'CM' => __( 'Cimișlia District', 'lifterlms' ),
		'CR' => __( 'Criuleni District', 'lifterlms' ),
		'CL' => __( 'Călărași District', 'lifterlms' ),
		'CS' => __( 'Căușeni District', 'lifterlms' ),
		'DO' => __( 'Dondușeni District', 'lifterlms' ),
		'DR' => __( 'Drochia District', 'lifterlms' ),
		'DU' => __( 'Dubăsari District', 'lifterlms' ),
		'ED' => __( 'Edineț District', 'lifterlms' ),
		'FL' => __( 'Florești District', 'lifterlms' ),
		'FA' => __( 'Fălești District', 'lifterlms' ),
		'GA' => __( 'Gagauzia', 'lifterlms' ),
		'GL' => __( 'Glodeni District', 'lifterlms' ),
		'HI' => __( 'Hîncești District', 'lifterlms' ),
		'IA' => __( 'Ialoveni District', 'lifterlms' ),
		'NI' => __( 'Nisporeni District', 'lifterlms' ),
		'OC' => __( 'Ocnița District', 'lifterlms' ),
		'OR' => __( 'Orhei District', 'lifterlms' ),
		'RE' => __( 'Rezina District', 'lifterlms' ),
		'RI' => __( 'Rîșcani District', 'lifterlms' ),
		'SO' => __( 'Soroca District', 'lifterlms' ),
		'ST' => __( 'Strășeni District', 'lifterlms' ),
		'SI' => __( 'Sîngerei District', 'lifterlms' ),
		'TA' => __( 'Taraclia District', 'lifterlms' ),
		'TE' => __( 'Telenești District', 'lifterlms' ),
		'SN' => __( 'Transnistria autonomous territorial unit', 'lifterlms' ),
		'UN' => __( 'Ungheni District', 'lifterlms' ),
		'SD' => __( 'Șoldănești District', 'lifterlms' ),
		'SV' => __( 'Ștefan Vodă District', 'lifterlms' ),
	),
	'ME' => array(
		'10' => __( 'Kotor Municipality', 'lifterlms' ),
		'11' => __( 'Mojkovac Municipality', 'lifterlms' ),
		'12' => __( 'Nikšić Municipality', 'lifterlms' ),
		'13' => __( 'Plav Municipality', 'lifterlms' ),
		'14' => __( 'Pljevlja Municipality', 'lifterlms' ),
		'15' => __( 'Plužine Municipality', 'lifterlms' ),
		'16' => __( 'Podgorica Municipality', 'lifterlms' ),
		'17' => __( 'Rožaje Municipality', 'lifterlms' ),
		'18' => __( 'Šavnik Municipality', 'lifterlms' ),
		'19' => __( 'Tivat Municipality', 'lifterlms' ),
		'20' => __( 'Ulcinj Municipality', 'lifterlms' ),
		'21' => __( 'Žabljak Municipality', 'lifterlms' ),
		'22' => __( 'Gusinje Municipality', 'lifterlms' ),
		'23' => __( 'Petnjica Municipality', 'lifterlms' ),
		'01' => __( 'Andrijevica Municipality', 'lifterlms' ),
		'02' => __( 'Bar Municipality', 'lifterlms' ),
		'03' => __( 'Berane Municipality', 'lifterlms' ),
		'04' => __( 'Bijelo Polje Municipality', 'lifterlms' ),
		'05' => __( 'Budva Municipality', 'lifterlms' ),
		'07' => __( 'Danilovgrad Municipality', 'lifterlms' ),
		'09' => __( 'Kolašin Municipality', 'lifterlms' ),
		'06' => __( 'Old Royal Capital Cetinje', 'lifterlms' ),
	),
	'MF' => array(),
	'MG' => array(
		'T' => __( 'Antananarivo Province', 'lifterlms' ),
		'D' => __( 'Antsiranana Province', 'lifterlms' ),
		'F' => __( 'Fianarantsoa Province', 'lifterlms' ),
		'M' => __( 'Mahajanga Province', 'lifterlms' ),
		'A' => __( 'Toamasina Province', 'lifterlms' ),
		'U' => __( 'Toliara Province', 'lifterlms' ),
	),
	'MH' => array(
		'L' => __( 'Ralik Chain', 'lifterlms' ),
		'T' => __( 'Ratak Chain', 'lifterlms' ),
	),
	'MK' => array(
		'10' => __( 'Valandovo Municipality', 'lifterlms' ),
		'11' => __( 'Vasilevo Municipality', 'lifterlms' ),
		'12' => __( 'Vevčani Municipality', 'lifterlms' ),
		'13' => __( 'Veles Municipality', 'lifterlms' ),
		'14' => __( 'Vinica Municipality', 'lifterlms' ),
		'15' => __( 'Vraneštica Municipality', 'lifterlms' ),
		'16' => __( 'Vrapčište Municipality', 'lifterlms' ),
		'17' => __( 'Gazi Baba Municipality', 'lifterlms' ),
		'18' => __( 'Gevgelija Municipality', 'lifterlms' ),
		'19' => __( 'Gostivar Municipality', 'lifterlms' ),
		'20' => __( 'Gradsko Municipality', 'lifterlms' ),
		'22' => __( 'Debarca Municipality', 'lifterlms' ),
		'23' => __( 'Delčevo Municipality', 'lifterlms' ),
		'24' => __( 'Demir Kapija Municipality', 'lifterlms' ),
		'25' => __( 'Demir Hisar Municipality', 'lifterlms' ),
		'26' => __( 'Dojran Municipality', 'lifterlms' ),
		'27' => __( 'Dolneni Municipality', 'lifterlms' ),
		'28' => __( 'Drugovo Municipality', 'lifterlms' ),
		'29' => __( 'Gjorče Petrov Municipality', 'lifterlms' ),
		'30' => __( 'Želino Municipality', 'lifterlms' ),
		'31' => __( 'Zajas Municipality', 'lifterlms' ),
		'32' => __( 'Zelenikovo Municipality', 'lifterlms' ),
		'33' => __( 'Zrnovci Municipality', 'lifterlms' ),
		'34' => __( 'Ilinden Municipality', 'lifterlms' ),
		'35' => __( 'Jegunovce Municipality', 'lifterlms' ),
		'36' => __( 'Kavadarci Municipality', 'lifterlms' ),
		'37' => __( 'Karbinci', 'lifterlms' ),
		'38' => __( 'Karpoš Municipality', 'lifterlms' ),
		'39' => __( 'Kisela Voda Municipality', 'lifterlms' ),
		'40' => __( 'Kičevo Municipality', 'lifterlms' ),
		'41' => __( 'Konče Municipality', 'lifterlms' ),
		'42' => __( 'Kočani Municipality', 'lifterlms' ),
		'43' => __( 'Kratovo Municipality', 'lifterlms' ),
		'44' => __( 'Kriva Palanka Municipality', 'lifterlms' ),
		'45' => __( 'Krivogaštani Municipality', 'lifterlms' ),
		'46' => __( 'Kruševo Municipality', 'lifterlms' ),
		'47' => __( 'Kumanovo Municipality', 'lifterlms' ),
		'48' => __( 'Lipkovo Municipality', 'lifterlms' ),
		'49' => __( 'Lozovo Municipality', 'lifterlms' ),
		'50' => __( 'Mavrovo and Rostuša Municipality', 'lifterlms' ),
		'51' => __( 'Makedonska Kamenica Municipality', 'lifterlms' ),
		'52' => __( 'Makedonski Brod Municipality', 'lifterlms' ),
		'53' => __( 'Mogila Municipality', 'lifterlms' ),
		'54' => __( 'Negotino Municipality', 'lifterlms' ),
		'55' => __( 'Novaci Municipality', 'lifterlms' ),
		'56' => __( 'Novo Selo Municipality', 'lifterlms' ),
		'57' => __( 'Oslomej Municipality', 'lifterlms' ),
		'58' => __( 'Ohrid Municipality', 'lifterlms' ),
		'59' => __( 'Petrovec Municipality', 'lifterlms' ),
		'60' => __( 'Pehčevo Municipality', 'lifterlms' ),
		'61' => __( 'Plasnica Municipality', 'lifterlms' ),
		'62' => __( 'Prilep Municipality', 'lifterlms' ),
		'63' => __( 'Probištip Municipality', 'lifterlms' ),
		'64' => __( 'Radoviš Municipality', 'lifterlms' ),
		'65' => __( 'Rankovce Municipality', 'lifterlms' ),
		'66' => __( 'Resen Municipality', 'lifterlms' ),
		'67' => __( 'Rosoman Municipality', 'lifterlms' ),
		'68' => __( 'Saraj Municipality', 'lifterlms' ),
		'69' => __( 'Sveti Nikole Municipality', 'lifterlms' ),
		'70' => __( 'Sopište Municipality', 'lifterlms' ),
		'71' => __( 'Staro Nagoričane Municipality', 'lifterlms' ),
		'72' => __( 'Struga Municipality', 'lifterlms' ),
		'73' => __( 'Strumica Municipality', 'lifterlms' ),
		'74' => __( 'Studeničani Municipality', 'lifterlms' ),
		'75' => __( 'Tearce Municipality', 'lifterlms' ),
		'76' => __( 'Tetovo Municipality', 'lifterlms' ),
		'77' => __( 'Centar Municipality', 'lifterlms' ),
		'78' => __( 'Centar Župa Municipality', 'lifterlms' ),
		'79' => __( 'Čair Municipality', 'lifterlms' ),
		'80' => __( 'Čaška Municipality', 'lifterlms' ),
		'81' => __( 'Češinovo-Obleševo Municipality', 'lifterlms' ),
		'82' => __( 'Čučer-Sandevo Municipality', 'lifterlms' ),
		'83' => __( 'Štip Municipality', 'lifterlms' ),
		'84' => __( 'Šuto Orizari Municipality', 'lifterlms' ),
		'85' => __( 'Greater Skopje', 'lifterlms' ),
		'01' => __( 'Aerodrom Municipality', 'lifterlms' ),
		'02' => __( 'Aračinovo Municipality', 'lifterlms' ),
		'03' => __( 'Berovo Municipality', 'lifterlms' ),
		'04' => __( 'Bitola Municipality', 'lifterlms' ),
		'05' => __( 'Bogdanci Municipality', 'lifterlms' ),
		'06' => __( 'Bogovinje Municipality', 'lifterlms' ),
		'07' => __( 'Bosilovo Municipality', 'lifterlms' ),
		'08' => __( 'Brvenica Municipality', 'lifterlms' ),
		'09' => __( 'Butel Municipality', 'lifterlms' ),
	),
	'ML' => array(
		'1'   => __( 'Kayes Region', 'lifterlms' ),
		'2'   => __( 'Koulikoro Region', 'lifterlms' ),
		'3'   => __( 'Sikasso Region', 'lifterlms' ),
		'4'   => __( 'Ségou Region', 'lifterlms' ),
		'5'   => __( 'Mopti Region', 'lifterlms' ),
		'6'   => __( 'Tombouctou Region', 'lifterlms' ),
		'7'   => __( 'Gao Region', 'lifterlms' ),
		'8'   => __( 'Kidal Region', 'lifterlms' ),
		'9'   => __( 'Ménaka Region', 'lifterlms' ),
		'10'  => __( 'Taoudénit Region', 'lifterlms' ),
		'BKO' => __( 'Bamako', 'lifterlms' ),
	),
	'MM' => array(
		'11' => __( 'Kachin State', 'lifterlms' ),
		'12' => __( 'Kayah State', 'lifterlms' ),
		'13' => __( 'Kayin State', 'lifterlms' ),
		'14' => __( 'Chin State', 'lifterlms' ),
		'15' => __( 'Mon State', 'lifterlms' ),
		'16' => __( 'Rakhine State', 'lifterlms' ),
		'17' => __( 'Shan State', 'lifterlms' ),
		'18' => __( 'Naypyidaw Union Territory', 'lifterlms' ),
		'07' => __( 'Ayeyarwady Region', 'lifterlms' ),
		'02' => __( 'Bago', 'lifterlms' ),
		'03' => __( 'Magway Region', 'lifterlms' ),
		'04' => __( 'Mandalay Region', 'lifterlms' ),
		'01' => __( 'Sagaing Region', 'lifterlms' ),
		'05' => __( 'Tanintharyi Region', 'lifterlms' ),
		'06' => __( 'Yangon Region', 'lifterlms' ),
	),
	'MN' => array(
		'073' => __( 'Arkhangai Province', 'lifterlms' ),
		'071' => __( 'Bayan-Ölgii Province', 'lifterlms' ),
		'069' => __( 'Bayankhongor Province', 'lifterlms' ),
		'067' => __( 'Bulgan Province', 'lifterlms' ),
		'037' => __( 'Darkhan-Uul Province', 'lifterlms' ),
		'061' => __( 'Dornod Province', 'lifterlms' ),
		'063' => __( 'Dornogovi Province', 'lifterlms' ),
		'059' => __( 'Dundgovi Province', 'lifterlms' ),
		'065' => __( 'Govi-Altai Province', 'lifterlms' ),
		'064' => __( 'Govisümber Province', 'lifterlms' ),
		'039' => __( 'Khentii Province', 'lifterlms' ),
		'043' => __( 'Khovd Province', 'lifterlms' ),
		'041' => __( 'Khövsgöl Province', 'lifterlms' ),
		'035' => __( 'Orkhon Province', 'lifterlms' ),
		'049' => __( 'Selenge Province', 'lifterlms' ),
		'051' => __( 'Sükhbaatar Province', 'lifterlms' ),
		'047' => __( 'Töv Province', 'lifterlms' ),
		'046' => __( 'Uvs Province', 'lifterlms' ),
		'057' => __( 'Zavkhan Province', 'lifterlms' ),
		'053' => __( 'Ömnögovi Province', 'lifterlms' ),
		'055' => __( 'Övörkhangai Province', 'lifterlms' ),
	),
	'MO' => array(),
	'MP' => array(),
	'MQ' => array(),
	'MR' => array(
		'10' => __( 'Guidimaka Region', 'lifterlms' ),
		'11' => __( 'Tiris Zemmour Region', 'lifterlms' ),
		'12' => __( 'Inchiri Region', 'lifterlms' ),
		'13' => __( 'Nouakchott-Ouest Region', 'lifterlms' ),
		'14' => __( 'Nouakchott-Nord Region', 'lifterlms' ),
		'15' => __( 'Nouakchott-Sud Region', 'lifterlms' ),
		'07' => __( 'Adrar Region', 'lifterlms' ),
		'03' => __( 'Assaba Region', 'lifterlms' ),
		'05' => __( 'Brakna Region', 'lifterlms' ),
		'08' => __( 'Dakhlet Nouadhibou', 'lifterlms' ),
		'04' => __( 'Gorgol Region', 'lifterlms' ),
		'01' => __( 'Hodh Ech Chargui Region', 'lifterlms' ),
		'02' => __( 'Hodh El Gharbi Region', 'lifterlms' ),
		'09' => __( 'Tagant Region', 'lifterlms' ),
		'06' => __( 'Trarza Region', 'lifterlms' ),
	),
	'MS' => array(),
	'MT' => array(
		'10' => __( 'Fontana', 'lifterlms' ),
		'11' => __( 'Gudja', 'lifterlms' ),
		'12' => __( 'Gżira', 'lifterlms' ),
		'13' => __( 'Għajnsielem', 'lifterlms' ),
		'14' => __( 'Għarb', 'lifterlms' ),
		'15' => __( 'Għargħur', 'lifterlms' ),
		'16' => __( 'Għasri', 'lifterlms' ),
		'17' => __( 'Għaxaq', 'lifterlms' ),
		'18' => __( 'Ħamrun', 'lifterlms' ),
		'19' => __( 'Iklin', 'lifterlms' ),
		'20' => __( 'Senglea', 'lifterlms' ),
		'21' => __( 'Kalkara', 'lifterlms' ),
		'22' => __( 'Kerċem', 'lifterlms' ),
		'23' => __( 'Kirkop', 'lifterlms' ),
		'24' => __( 'Lija', 'lifterlms' ),
		'25' => __( 'Luqa', 'lifterlms' ),
		'26' => __( 'Marsa', 'lifterlms' ),
		'27' => __( 'Marsaskala', 'lifterlms' ),
		'28' => __( 'Marsaxlokk', 'lifterlms' ),
		'29' => __( 'Mdina', 'lifterlms' ),
		'30' => __( 'Mellieħa', 'lifterlms' ),
		'31' => __( 'Mġarr', 'lifterlms' ),
		'32' => __( 'Mosta', 'lifterlms' ),
		'33' => __( 'Mqabba', 'lifterlms' ),
		'34' => __( 'Msida', 'lifterlms' ),
		'35' => __( 'Mtarfa', 'lifterlms' ),
		'36' => __( 'Munxar', 'lifterlms' ),
		'37' => __( 'Nadur', 'lifterlms' ),
		'38' => __( 'Naxxar', 'lifterlms' ),
		'39' => __( 'Paola', 'lifterlms' ),
		'40' => __( 'Pembroke', 'lifterlms' ),
		'41' => __( 'Pietà', 'lifterlms' ),
		'42' => __( 'Qala', 'lifterlms' ),
		'43' => __( 'Qormi', 'lifterlms' ),
		'44' => __( 'Qrendi', 'lifterlms' ),
		'45' => __( 'Victoria', 'lifterlms' ),
		'46' => __( 'Rabat', 'lifterlms' ),
		'48' => __( 'St. Julian\'s', 'lifterlms' ),
		'49' => __( 'San Ġwann', 'lifterlms' ),
		'50' => __( 'Saint Lawrence', 'lifterlms' ),
		'51' => __( 'St. Paul\'s Bay', 'lifterlms' ),
		'52' => __( 'Sannat', 'lifterlms' ),
		'53' => __( 'Santa Luċija', 'lifterlms' ),
		'54' => __( 'Santa Venera', 'lifterlms' ),
		'55' => __( 'Siġġiewi', 'lifterlms' ),
		'56' => __( 'Sliema', 'lifterlms' ),
		'57' => __( 'Swieqi', 'lifterlms' ),
		'58' => __( 'Ta\' Xbiex', 'lifterlms' ),
		'59' => __( 'Tarxien', 'lifterlms' ),
		'60' => __( 'Valletta', 'lifterlms' ),
		'61' => __( 'Xagħra', 'lifterlms' ),
		'62' => __( 'Xewkija', 'lifterlms' ),
		'63' => __( 'Xgħajra', 'lifterlms' ),
		'64' => __( 'Żabbar', 'lifterlms' ),
		'65' => __( 'Żebbuġ Gozo', 'lifterlms' ),
		'66' => __( 'Żebbuġ Malta', 'lifterlms' ),
		'67' => __( 'Żejtun', 'lifterlms' ),
		'68' => __( 'Żurrieq', 'lifterlms' ),
		'01' => __( 'Attard', 'lifterlms' ),
		'02' => __( 'Balzan', 'lifterlms' ),
		'03' => __( 'Birgu', 'lifterlms' ),
		'04' => __( 'Birkirkara', 'lifterlms' ),
		'05' => __( 'Birżebbuġa', 'lifterlms' ),
		'06' => __( 'Cospicua', 'lifterlms' ),
		'07' => __( 'Dingli', 'lifterlms' ),
		'08' => __( 'Fgura', 'lifterlms' ),
		'09' => __( 'Floriana', 'lifterlms' ),
	),
	'MU' => array(
		'AG' => __( 'Agaléga', 'lifterlms' ),
		'BR' => __( 'Beau Bassin-Rose Hill', 'lifterlms' ),
		'CC' => __( 'Cargados Carajos', 'lifterlms' ),
		'CU' => __( 'Curepipe', 'lifterlms' ),
		'FL' => __( 'Flacq District', 'lifterlms' ),
		'GP' => __( 'Grand Port District', 'lifterlms' ),
		'MO' => __( 'Moka District', 'lifterlms' ),
		'PA' => __( 'Pamplemousses District', 'lifterlms' ),
		'PW' => __( 'Plaines Wilhems District', 'lifterlms' ),
		'PU' => __( 'Port Louis', 'lifterlms' ),
		'PL' => __( 'Port Louis District', 'lifterlms' ),
		'QB' => __( 'Quatre Bornes', 'lifterlms' ),
		'BL' => __( 'Rivière Noire District', 'lifterlms' ),
		'RR' => __( 'Rivière du Rempart District', 'lifterlms' ),
		'RO' => __( 'Rodrigues', 'lifterlms' ),
		'SA' => __( 'Savanne District', 'lifterlms' ),
		'VP' => __( 'Vacoas-Phoenix', 'lifterlms' ),
	),
	'MV' => array(
		'12'  => __( 'Meemu Atoll', 'lifterlms' ),
		'13'  => __( 'Raa Atoll', 'lifterlms' ),
		'14'  => __( 'Faafu Atoll', 'lifterlms' ),
		'17'  => __( 'Dhaalu Atoll', 'lifterlms' ),
		'23'  => __( 'Haa Dhaalu Atoll', 'lifterlms' ),
		'24'  => __( 'Shaviyani Atoll', 'lifterlms' ),
		'25'  => __( 'Noonu Atoll', 'lifterlms' ),
		'26'  => __( 'Kaafu Atoll', 'lifterlms' ),
		'27'  => __( 'Gaafu Alif Atoll', 'lifterlms' ),
		'28'  => __( 'Gaafu Dhaalu Atoll', 'lifterlms' ),
		'29'  => __( 'Gnaviyani Atoll', 'lifterlms' ),
		'01'  => __( 'Addu Atoll', 'lifterlms' ),
		'02'  => __( 'Alif Alif Atoll', 'lifterlms' ),
		'00'  => __( 'Alif Dhaal Atoll', 'lifterlms' ),
		'CE'  => __( 'Central Province', 'lifterlms' ),
		'07'  => __( 'Haa Alif Atoll', 'lifterlms' ),
		'05'  => __( 'Laamu Atoll', 'lifterlms' ),
		'03'  => __( 'Lhaviyani Atoll', 'lifterlms' ),
		'MLE' => __( 'Malé', 'lifterlms' ),
		'NC'  => __( 'North Central Province', 'lifterlms' ),
		'NO'  => __( 'North Province', 'lifterlms' ),
		'SC'  => __( 'South Central Province', 'lifterlms' ),
		'SU'  => __( 'South Province', 'lifterlms' ),
		'08'  => __( 'Thaa Atoll', 'lifterlms' ),
		'US'  => __( 'Upper South Province', 'lifterlms' ),
		'04'  => __( 'Vaavu Atoll', 'lifterlms' ),
	),
	'MW' => array(
		'BA' => __( 'Balaka District', 'lifterlms' ),
		'BL' => __( 'Blantyre District', 'lifterlms' ),
		'C'  => __( 'Central Region', 'lifterlms' ),
		'CK' => __( 'Chikwawa District', 'lifterlms' ),
		'CR' => __( 'Chiradzulu District', 'lifterlms' ),
		'CT' => __( 'Chitipa district', 'lifterlms' ),
		'DE' => __( 'Dedza District', 'lifterlms' ),
		'DO' => __( 'Dowa District', 'lifterlms' ),
		'KR' => __( 'Karonga District', 'lifterlms' ),
		'KS' => __( 'Kasungu District', 'lifterlms' ),
		'LK' => __( 'Likoma District', 'lifterlms' ),
		'LI' => __( 'Lilongwe District', 'lifterlms' ),
		'MH' => __( 'Machinga District', 'lifterlms' ),
		'MG' => __( 'Mangochi District', 'lifterlms' ),
		'MC' => __( 'Mchinji District', 'lifterlms' ),
		'MU' => __( 'Mulanje District', 'lifterlms' ),
		'MW' => __( 'Mwanza District', 'lifterlms' ),
		'MZ' => __( 'Mzimba District', 'lifterlms' ),
		'NB' => __( 'Nkhata Bay District', 'lifterlms' ),
		'NK' => __( 'Nkhotakota District', 'lifterlms' ),
		'N'  => __( 'Northern Region', 'lifterlms' ),
		'NS' => __( 'Nsanje District', 'lifterlms' ),
		'NU' => __( 'Ntcheu District', 'lifterlms' ),
		'NI' => __( 'Ntchisi District', 'lifterlms' ),
		'PH' => __( 'Phalombe District', 'lifterlms' ),
		'RU' => __( 'Rumphi District', 'lifterlms' ),
		'SA' => __( 'Salima District', 'lifterlms' ),
		'S'  => __( 'Southern Region', 'lifterlms' ),
		'TH' => __( 'Thyolo District', 'lifterlms' ),
		'ZO' => __( 'Zomba District', 'lifterlms' ),
	),
	'MX' => array(
		'AGU' => __( 'Aguascalientes', 'lifterlms' ),
		'BCN' => __( 'Baja California', 'lifterlms' ),
		'BCS' => __( 'Baja California Sur', 'lifterlms' ),
		'CAM' => __( 'Campeche', 'lifterlms' ),
		'CHP' => __( 'Chiapas', 'lifterlms' ),
		'CHH' => __( 'Chihuahua', 'lifterlms' ),
		'COA' => __( 'Coahuila', 'lifterlms' ),
		'COL' => __( 'Colima', 'lifterlms' ),
		'DUR' => __( 'Durango', 'lifterlms' ),
		'GUA' => __( 'Guanajuato', 'lifterlms' ),
		'GRO' => __( 'Guerrero', 'lifterlms' ),
		'HID' => __( 'Hidalgo', 'lifterlms' ),
		'JAL' => __( 'Jalisco', 'lifterlms' ),
		'CMX' => __( 'Mexico City', 'lifterlms' ),
		'MIC' => __( 'Michoacán', 'lifterlms' ),
		'MOR' => __( 'Morelos', 'lifterlms' ),
		'MEX' => __( 'México', 'lifterlms' ),
		'NAY' => __( 'Nayarit', 'lifterlms' ),
		'NLE' => __( 'Nuevo León', 'lifterlms' ),
		'OAX' => __( 'Oaxaca', 'lifterlms' ),
		'PUE' => __( 'Puebla', 'lifterlms' ),
		'QUE' => __( 'Querétaro', 'lifterlms' ),
		'ROO' => __( 'Quintana Roo', 'lifterlms' ),
		'SLP' => __( 'San Luis Potosí', 'lifterlms' ),
		'SIN' => __( 'Sinaloa', 'lifterlms' ),
		'SON' => __( 'Sonora', 'lifterlms' ),
		'TAB' => __( 'Tabasco', 'lifterlms' ),
		'TAM' => __( 'Tamaulipas', 'lifterlms' ),
		'TLA' => __( 'Tlaxcala', 'lifterlms' ),
		'VER' => __( 'Veracruz', 'lifterlms' ),
		'YUC' => __( 'Yucatán', 'lifterlms' ),
		'ZAC' => __( 'Zacatecas', 'lifterlms' ),
	),
	'MY' => array(
		'10' => __( 'Selangor', 'lifterlms' ),
		'11' => __( 'Terengganu', 'lifterlms' ),
		'12' => __( 'Sabah', 'lifterlms' ),
		'13' => __( 'Sarawak', 'lifterlms' ),
		'14' => __( 'Kuala Lumpur', 'lifterlms' ),
		'15' => __( 'Labuan', 'lifterlms' ),
		'16' => __( 'Putrajaya', 'lifterlms' ),
		'01' => __( 'Johor', 'lifterlms' ),
		'02' => __( 'Kedah', 'lifterlms' ),
		'03' => __( 'Kelantan', 'lifterlms' ),
		'04' => __( 'Malacca', 'lifterlms' ),
		'05' => __( 'Negeri Sembilan', 'lifterlms' ),
		'06' => __( 'Pahang', 'lifterlms' ),
		'07' => __( 'Penang', 'lifterlms' ),
		'08' => __( 'Perak', 'lifterlms' ),
		'09' => __( 'Perlis', 'lifterlms' ),
	),
	'MZ' => array(
		'P'   => __( 'Cabo Delgado Province', 'lifterlms' ),
		'G'   => __( 'Gaza Province', 'lifterlms' ),
		'I'   => __( 'Inhambane Province', 'lifterlms' ),
		'B'   => __( 'Manica Province', 'lifterlms' ),
		'MPM' => __( 'Maputo', 'lifterlms' ),
		'L'   => __( 'Maputo Province', 'lifterlms' ),
		'N'   => __( 'Nampula Province', 'lifterlms' ),
		'A'   => __( 'Niassa Province', 'lifterlms' ),
		'S'   => __( 'Sofala Province', 'lifterlms' ),
		'T'   => __( 'Tete Province', 'lifterlms' ),
		'Q'   => __( 'Zambezia Province', 'lifterlms' ),
	),
	'NA' => array(
		'ER' => __( 'Erongo Region', 'lifterlms' ),
		'HA' => __( 'Hardap Region', 'lifterlms' ),
		'KA' => __( 'Karas Region', 'lifterlms' ),
		'KE' => __( 'Kavango East Region', 'lifterlms' ),
		'KW' => __( 'Kavango West Region', 'lifterlms' ),
		'KH' => __( 'Khomas Region', 'lifterlms' ),
		'KU' => __( 'Kunene Region', 'lifterlms' ),
		'OW' => __( 'Ohangwena Region', 'lifterlms' ),
		'OH' => __( 'Omaheke Region', 'lifterlms' ),
		'OS' => __( 'Omusati Region', 'lifterlms' ),
		'ON' => __( 'Oshana Region', 'lifterlms' ),
		'OT' => __( 'Oshikoto Region', 'lifterlms' ),
		'OD' => __( 'Otjozondjupa Region', 'lifterlms' ),
		'CA' => __( 'Zambezi Region', 'lifterlms' ),
	),
	'NC' => array(),
	'NE' => array(
		'1' => __( 'Agadez Region', 'lifterlms' ),
		'2' => __( 'Diffa Region', 'lifterlms' ),
		'3' => __( 'Dosso Region', 'lifterlms' ),
		'4' => __( 'Maradi Region', 'lifterlms' ),
		'5' => __( 'Tahoua Region', 'lifterlms' ),
		'6' => __( 'Tillabéri Region', 'lifterlms' ),
		'7' => __( 'Zinder Region', 'lifterlms' ),
	),
	'NF' => array(),
	'NG' => array(
		'AB' => __( 'Abia State', 'lifterlms' ),
		'AD' => __( 'Adamawa State', 'lifterlms' ),
		'AK' => __( 'Akwa Ibom State', 'lifterlms' ),
		'AN' => __( 'Anambra State', 'lifterlms' ),
		'BA' => __( 'Bauchi State', 'lifterlms' ),
		'BY' => __( 'Bayelsa State', 'lifterlms' ),
		'BE' => __( 'Benue State', 'lifterlms' ),
		'BO' => __( 'Borno State', 'lifterlms' ),
		'CR' => __( 'Cross River State', 'lifterlms' ),
		'DE' => __( 'Delta State', 'lifterlms' ),
		'EB' => __( 'Ebonyi State', 'lifterlms' ),
		'ED' => __( 'Edo State', 'lifterlms' ),
		'EK' => __( 'Ekiti State', 'lifterlms' ),
		'EN' => __( 'Enugu State', 'lifterlms' ),
		'FC' => __( 'Federal Capital Territory', 'lifterlms' ),
		'GO' => __( 'Gombe State', 'lifterlms' ),
		'IM' => __( 'Imo State', 'lifterlms' ),
		'JI' => __( 'Jigawa State', 'lifterlms' ),
		'KD' => __( 'Kaduna State', 'lifterlms' ),
		'KN' => __( 'Kano State', 'lifterlms' ),
		'KT' => __( 'Katsina State', 'lifterlms' ),
		'KE' => __( 'Kebbi State', 'lifterlms' ),
		'KO' => __( 'Kogi State', 'lifterlms' ),
		'KW' => __( 'Kwara State', 'lifterlms' ),
		'LA' => __( 'Lagos', 'lifterlms' ),
		'NA' => __( 'Nasarawa State', 'lifterlms' ),
		'NI' => __( 'Niger State', 'lifterlms' ),
		'OG' => __( 'Ogun State', 'lifterlms' ),
		'ON' => __( 'Ondo State', 'lifterlms' ),
		'OS' => __( 'Osun State', 'lifterlms' ),
		'OY' => __( 'Oyo State', 'lifterlms' ),
		'PL' => __( 'Plateau State', 'lifterlms' ),
		'SO' => __( 'Sokoto State', 'lifterlms' ),
		'TA' => __( 'Taraba State', 'lifterlms' ),
		'YO' => __( 'Yobe State', 'lifterlms' ),
		'ZA' => __( 'Zamfara State', 'lifterlms' ),
	),
	'NI' => array(
		'BO' => __( 'Boaco Department', 'lifterlms' ),
		'CA' => __( 'Carazo Department', 'lifterlms' ),
		'CI' => __( 'Chinandega Department', 'lifterlms' ),
		'CO' => __( 'Chontales Department', 'lifterlms' ),
		'ES' => __( 'Estelí Department', 'lifterlms' ),
		'GR' => __( 'Granada Department', 'lifterlms' ),
		'JI' => __( 'Jinotega Department', 'lifterlms' ),
		'LE' => __( 'León Department', 'lifterlms' ),
		'MD' => __( 'Madriz Department', 'lifterlms' ),
		'MN' => __( 'Managua Department', 'lifterlms' ),
		'MS' => __( 'Masaya Department', 'lifterlms' ),
		'MT' => __( 'Matagalpa Department', 'lifterlms' ),
		'AN' => __( 'North Caribbean Coast Autonomous Region', 'lifterlms' ),
		'RI' => __( 'Rivas Department', 'lifterlms' ),
		'SJ' => __( 'Río San Juan Department', 'lifterlms' ),
		'AS' => __( 'South Caribbean Coast Autonomous Region', 'lifterlms' ),
	),
	'NL' => array(
		'BQ1' => __( 'Bonaire', 'lifterlms' ),
		'DR'  => __( 'Drenthe', 'lifterlms' ),
		'FL'  => __( 'Flevoland', 'lifterlms' ),
		'FR'  => __( 'Friesland', 'lifterlms' ),
		'GE'  => __( 'Gelderland', 'lifterlms' ),
		'GR'  => __( 'Groningen', 'lifterlms' ),
		'LI'  => __( 'Limburg', 'lifterlms' ),
		'NB'  => __( 'North Brabant', 'lifterlms' ),
		'NH'  => __( 'North Holland', 'lifterlms' ),
		'OV'  => __( 'Overijssel', 'lifterlms' ),
		'BQ2' => __( 'Saba', 'lifterlms' ),
		'BQ3' => __( 'Sint Eustatius', 'lifterlms' ),
		'ZH'  => __( 'South Holland', 'lifterlms' ),
		'UT'  => __( 'Utrecht', 'lifterlms' ),
		'ZE'  => __( 'Zeeland', 'lifterlms' ),
	),
	'NO' => array(
		'10' => __( 'Vest-Agder', 'lifterlms' ),
		'11' => __( 'Rogaland', 'lifterlms' ),
		'12' => __( 'Hordaland', 'lifterlms' ),
		'14' => __( 'Sogn og Fjordane', 'lifterlms' ),
		'15' => __( 'Møre og Romsdal', 'lifterlms' ),
		'16' => __( 'Sør-Trøndelag', 'lifterlms' ),
		'17' => __( 'Nord-Trøndelag', 'lifterlms' ),
		'18' => __( 'Nordland', 'lifterlms' ),
		'19' => __( 'Troms', 'lifterlms' ),
		'20' => __( 'Finnmark', 'lifterlms' ),
		'21' => __( 'Svalbard', 'lifterlms' ),
		'22' => __( 'Jan Mayen', 'lifterlms' ),
		'50' => __( 'Trøndelag', 'lifterlms' ),
		'02' => __( 'Akershus', 'lifterlms' ),
		'06' => __( 'Buskerud', 'lifterlms' ),
		'04' => __( 'Hedmark', 'lifterlms' ),
		'05' => __( 'Oppland', 'lifterlms' ),
		'03' => __( 'Oslo', 'lifterlms' ),
		'08' => __( 'Telemark', 'lifterlms' ),
		'07' => __( 'Vestfold', 'lifterlms' ),
		'01' => __( 'Østfold', 'lifterlms' ),
	),
	'NP' => array(
		'1'  => __( 'Central Region', 'lifterlms' ),
		'2'  => __( 'Mid-Western Region', 'lifterlms' ),
		'3'  => __( 'Western Region', 'lifterlms' ),
		'4'  => __( 'Eastern Development Region', 'lifterlms' ),
		'5'  => __( 'Far-Western Development Region', 'lifterlms' ),
		'BA' => __( 'Bagmati Zone', 'lifterlms' ),
		'BH' => __( 'Bheri Zone', 'lifterlms' ),
		'DH' => __( 'Dhaulagiri Zone', 'lifterlms' ),
		'GA' => __( 'Gandaki Zone', 'lifterlms' ),
		'JA' => __( 'Janakpur Zone', 'lifterlms' ),
		'KA' => __( 'Karnali Zone', 'lifterlms' ),
		'KO' => __( 'Kosi Zone', 'lifterlms' ),
		'LU' => __( 'Lumbini Zone', 'lifterlms' ),
		'MA' => __( 'Mahakali Zone', 'lifterlms' ),
		'ME' => __( 'Mechi Zone', 'lifterlms' ),
		'NA' => __( 'Narayani Zone', 'lifterlms' ),
		'RA' => __( 'Rapti Zone', 'lifterlms' ),
		'SA' => __( 'Sagarmatha Zone', 'lifterlms' ),
		'SE' => __( 'Seti Zone', 'lifterlms' ),
	),
	'NR' => array(
		'10' => __( 'Ijuw District', 'lifterlms' ),
		'11' => __( 'Meneng District', 'lifterlms' ),
		'12' => __( 'Nibok District', 'lifterlms' ),
		'13' => __( 'Uaboe District', 'lifterlms' ),
		'14' => __( 'Yaren District', 'lifterlms' ),
		'01' => __( 'Aiwo District', 'lifterlms' ),
		'02' => __( 'Anabar District', 'lifterlms' ),
		'03' => __( 'Anetan District', 'lifterlms' ),
		'04' => __( 'Anibare District', 'lifterlms' ),
		'05' => __( 'Baiti District', 'lifterlms' ),
		'06' => __( 'Boe District', 'lifterlms' ),
		'07' => __( 'Buada District', 'lifterlms' ),
		'08' => __( 'Denigomodu District', 'lifterlms' ),
		'09' => __( 'Ewa District', 'lifterlms' ),
	),
	'NU' => array(),
	'NZ' => array(
		'AUK' => __( 'Auckland Region', 'lifterlms' ),
		'BOP' => __( 'Bay of Plenty Region', 'lifterlms' ),
		'CAN' => __( 'Canterbury Region', 'lifterlms' ),
		'CIT' => __( 'Chatham Islands', 'lifterlms' ),
		'GIS' => __( 'Gisborne District', 'lifterlms' ),
		'HKB' => __( 'Hawke\'s Bay Region', 'lifterlms' ),
		'MWT' => __( 'Manawatu-Wanganui Region', 'lifterlms' ),
		'MBH' => __( 'Marlborough Region', 'lifterlms' ),
		'NSN' => __( 'Nelson Region', 'lifterlms' ),
		'NTL' => __( 'Northland Region', 'lifterlms' ),
		'OTA' => __( 'Otago Region', 'lifterlms' ),
		'STL' => __( 'Southland Region', 'lifterlms' ),
		'TKI' => __( 'Taranaki Region', 'lifterlms' ),
		'TAS' => __( 'Tasman District', 'lifterlms' ),
		'WKO' => __( 'Waikato Region', 'lifterlms' ),
		'WGN' => __( 'Wellington Region', 'lifterlms' ),
		'WTC' => __( 'West Coast Region', 'lifterlms' ),
	),
	'OM' => array(
		'DA' => __( 'Ad Dakhiliyah Governorate', 'lifterlms' ),
		'ZA' => __( 'Ad Dhahirah Governorate', 'lifterlms' ),
		'BS' => __( 'Al Batinah North Governorate', 'lifterlms' ),
		'BA' => __( 'Al Batinah Region', 'lifterlms' ),
		'BJ' => __( 'Al Batinah South Governorate', 'lifterlms' ),
		'BU' => __( 'Al Buraimi Governorate', 'lifterlms' ),
		'WU' => __( 'Al Wusta Governorate', 'lifterlms' ),
		'SS' => __( 'Ash Sharqiyah North Governorate', 'lifterlms' ),
		'SH' => __( 'Ash Sharqiyah Region', 'lifterlms' ),
		'SJ' => __( 'Ash Sharqiyah South Governorate', 'lifterlms' ),
		'ZU' => __( 'Dhofar Governorate', 'lifterlms' ),
		'MU' => __( 'Musandam Governorate', 'lifterlms' ),
		'MA' => __( 'Muscat Governorate', 'lifterlms' ),
	),
	'PA' => array(
		'1'  => __( 'Bocas del Toro Province', 'lifterlms' ),
		'2'  => __( 'Coclé Province', 'lifterlms' ),
		'3'  => __( 'Colón Province', 'lifterlms' ),
		'4'  => __( 'Chiriquí Province', 'lifterlms' ),
		'5'  => __( 'Darién Province', 'lifterlms' ),
		'6'  => __( 'Herrera Province', 'lifterlms' ),
		'7'  => __( 'Los Santos Province', 'lifterlms' ),
		'8'  => __( 'Panamá Province', 'lifterlms' ),
		'9'  => __( 'Veraguas Province', 'lifterlms' ),
		'10' => __( 'Panamá Oeste Province', 'lifterlms' ),
		'EM' => __( 'Emberá-Wounaan Comarca', 'lifterlms' ),
		'KY' => __( 'Guna Yala', 'lifterlms' ),
		'NB' => __( 'Ngöbe-Buglé Comarca', 'lifterlms' ),
	),
	'PE' => array(
		'AMA' => __( 'Amazonas', 'lifterlms' ),
		'APU' => __( 'Apurímac', 'lifterlms' ),
		'ARE' => __( 'Arequipa', 'lifterlms' ),
		'AYA' => __( 'Ayacucho', 'lifterlms' ),
		'CAJ' => __( 'Cajamarca', 'lifterlms' ),
		'CAL' => __( 'Callao', 'lifterlms' ),
		'CUS' => __( 'Cusco', 'lifterlms' ),
		'HUV' => __( 'Huancavelica', 'lifterlms' ),
		'HUC' => __( 'Huanuco', 'lifterlms' ),
		'ICA' => __( 'Ica', 'lifterlms' ),
		'JUN' => __( 'Junín', 'lifterlms' ),
		'LAL' => __( 'La Libertad', 'lifterlms' ),
		'LAM' => __( 'Lambayeque', 'lifterlms' ),
		'LIM' => __( 'Lima', 'lifterlms' ),
		'MDD' => __( 'Madre de Dios', 'lifterlms' ),
		'MOQ' => __( 'Moquegua', 'lifterlms' ),
		'PAS' => __( 'Pasco', 'lifterlms' ),
		'PIU' => __( 'Piura', 'lifterlms' ),
		'PUN' => __( 'Puno', 'lifterlms' ),
		'SAM' => __( 'San Martín', 'lifterlms' ),
		'TAC' => __( 'Tacna', 'lifterlms' ),
		'TUM' => __( 'Tumbes', 'lifterlms' ),
		'UCA' => __( 'Ucayali', 'lifterlms' ),
		'ANC' => __( 'Áncash', 'lifterlms' ),
	),
	'PF' => array(),
	'PG' => array(
		'NSB' => __( 'Bougainville', 'lifterlms' ),
		'CPM' => __( 'Central Province', 'lifterlms' ),
		'CPK' => __( 'Chimbu Province', 'lifterlms' ),
		'EBR' => __( 'East New Britain', 'lifterlms' ),
		'EHG' => __( 'Eastern Highlands Province', 'lifterlms' ),
		'EPW' => __( 'Enga Province', 'lifterlms' ),
		'GPK' => __( 'Gulf', 'lifterlms' ),
		'HLA' => __( 'Hela', 'lifterlms' ),
		'JWK' => __( 'Jiwaka Province', 'lifterlms' ),
		'MPM' => __( 'Madang Province', 'lifterlms' ),
		'MRL' => __( 'Manus Province', 'lifterlms' ),
		'MBA' => __( 'Milne Bay Province', 'lifterlms' ),
		'MPL' => __( 'Morobe Province', 'lifterlms' ),
		'NIK' => __( 'New Ireland Province', 'lifterlms' ),
		'NPP' => __( 'Oro Province', 'lifterlms' ),
		'NCD' => __( 'Port Moresby', 'lifterlms' ),
		'SAN' => __( 'Sandaun Province', 'lifterlms' ),
		'SHM' => __( 'Southern Highlands Province', 'lifterlms' ),
		'WBK' => __( 'West New Britain Province', 'lifterlms' ),
		'WHM' => __( 'Western Highlands Province', 'lifterlms' ),
		'WPD' => __( 'Western Province', 'lifterlms' ),
	),
	'PH' => array(
		'10'  => __( 'Northern Mindanao', 'lifterlms' ),
		'11'  => __( 'Davao Region', 'lifterlms' ),
		'12'  => __( 'Soccsksargen', 'lifterlms' ),
		'13'  => __( 'Caraga', 'lifterlms' ),
		'14'  => __( 'Autonomous Region in Muslim Mindanao', 'lifterlms' ),
		'15'  => __( 'Cordillera Administrative Region', 'lifterlms' ),
		'40'  => __( 'Calabarzon', 'lifterlms' ),
		'41'  => __( 'Mimaropa', 'lifterlms' ),
		'ABR' => __( 'Abra', 'lifterlms' ),
		'AGN' => __( 'Agusan del Norte', 'lifterlms' ),
		'AGS' => __( 'Agusan del Sur', 'lifterlms' ),
		'AKL' => __( 'Aklan', 'lifterlms' ),
		'ALB' => __( 'Albay', 'lifterlms' ),
		'ANT' => __( 'Antique', 'lifterlms' ),
		'APA' => __( 'Apayao', 'lifterlms' ),
		'AUR' => __( 'Aurora', 'lifterlms' ),
		'BAS' => __( 'Basilan', 'lifterlms' ),
		'BAN' => __( 'Bataan', 'lifterlms' ),
		'BTN' => __( 'Batanes', 'lifterlms' ),
		'BTG' => __( 'Batangas', 'lifterlms' ),
		'BEN' => __( 'Benguet', 'lifterlms' ),
		'05'  => __( 'Bicol Region', 'lifterlms' ),
		'BIL' => __( 'Biliran', 'lifterlms' ),
		'BOH' => __( 'Bohol', 'lifterlms' ),
		'BUK' => __( 'Bukidnon', 'lifterlms' ),
		'BUL' => __( 'Bulacan', 'lifterlms' ),
		'CAG' => __( 'Cagayan', 'lifterlms' ),
		'02'  => __( 'Cagayan Valley', 'lifterlms' ),
		'CAN' => __( 'Camarines Norte', 'lifterlms' ),
		'CAS' => __( 'Camarines Sur', 'lifterlms' ),
		'CAM' => __( 'Camiguin', 'lifterlms' ),
		'CAP' => __( 'Capiz', 'lifterlms' ),
		'CAT' => __( 'Catanduanes', 'lifterlms' ),
		'CAV' => __( 'Cavite', 'lifterlms' ),
		'CEB' => __( 'Cebu', 'lifterlms' ),
		'03'  => __( 'Central Luzon', 'lifterlms' ),
		'07'  => __( 'Central Visayas', 'lifterlms' ),
		'COM' => __( 'Compostela Valley', 'lifterlms' ),
		'NCO' => __( 'Cotabato', 'lifterlms' ),
		'DVO' => __( 'Davao Occidental', 'lifterlms' ),
		'DAO' => __( 'Davao Oriental', 'lifterlms' ),
		'DAV' => __( 'Davao del Norte', 'lifterlms' ),
		'DAS' => __( 'Davao del Sur', 'lifterlms' ),
		'DIN' => __( 'Dinagat Islands', 'lifterlms' ),
		'EAS' => __( 'Eastern Samar', 'lifterlms' ),
		'08'  => __( 'Eastern Visayas', 'lifterlms' ),
		'GUI' => __( 'Guimaras', 'lifterlms' ),
		'IFU' => __( 'Ifugao', 'lifterlms' ),
		'ILN' => __( 'Ilocos Norte', 'lifterlms' ),
		'01'  => __( 'Ilocos Region', 'lifterlms' ),
		'ILS' => __( 'Ilocos Sur', 'lifterlms' ),
		'ILI' => __( 'Iloilo', 'lifterlms' ),
		'ISA' => __( 'Isabela', 'lifterlms' ),
		'KAL' => __( 'Kalinga', 'lifterlms' ),
		'LUN' => __( 'La Union', 'lifterlms' ),
		'LAG' => __( 'Laguna', 'lifterlms' ),
		'LAN' => __( 'Lanao del Norte', 'lifterlms' ),
		'LAS' => __( 'Lanao del Sur', 'lifterlms' ),
		'LEY' => __( 'Leyte', 'lifterlms' ),
		'MAG' => __( 'Maguindanao', 'lifterlms' ),
		'MAD' => __( 'Marinduque', 'lifterlms' ),
		'MAS' => __( 'Masbate', 'lifterlms' ),
		'NCR' => __( 'Metro Manila', 'lifterlms' ),
		'MSC' => __( 'Misamis Occidental', 'lifterlms' ),
		'MSR' => __( 'Misamis Oriental', 'lifterlms' ),
		'MOU' => __( 'Mountain Province', 'lifterlms' ),
		'NEC' => __( 'Negros Occidental', 'lifterlms' ),
		'NER' => __( 'Negros Oriental', 'lifterlms' ),
		'NSA' => __( 'Northern Samar', 'lifterlms' ),
		'NUE' => __( 'Nueva Ecija', 'lifterlms' ),
		'NUV' => __( 'Nueva Vizcaya', 'lifterlms' ),
		'MDC' => __( 'Occidental Mindoro', 'lifterlms' ),
		'MDR' => __( 'Oriental Mindoro', 'lifterlms' ),
		'PLW' => __( 'Palawan', 'lifterlms' ),
		'PAM' => __( 'Pampanga', 'lifterlms' ),
		'PAN' => __( 'Pangasinan', 'lifterlms' ),
		'QUE' => __( 'Quezon', 'lifterlms' ),
		'QUI' => __( 'Quirino', 'lifterlms' ),
		'RIZ' => __( 'Rizal', 'lifterlms' ),
		'ROM' => __( 'Romblon', 'lifterlms' ),
		'SAR' => __( 'Sarangani', 'lifterlms' ),
		'SIG' => __( 'Siquijor', 'lifterlms' ),
		'SOR' => __( 'Sorsogon', 'lifterlms' ),
		'SCO' => __( 'South Cotabato', 'lifterlms' ),
		'SLE' => __( 'Southern Leyte', 'lifterlms' ),
		'SUK' => __( 'Sultan Kudarat', 'lifterlms' ),
		'SLU' => __( 'Sulu', 'lifterlms' ),
		'SUN' => __( 'Surigao del Norte', 'lifterlms' ),
		'SUR' => __( 'Surigao del Sur', 'lifterlms' ),
		'TAR' => __( 'Tarlac', 'lifterlms' ),
		'TAW' => __( 'Tawi-Tawi', 'lifterlms' ),
		'06'  => __( 'Western Visayas', 'lifterlms' ),
		'ZMB' => __( 'Zambales', 'lifterlms' ),
		'09'  => __( 'Zamboanga Peninsula', 'lifterlms' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'lifterlms' ),
		'ZAN' => __( 'Zamboanga del Norte', 'lifterlms' ),
		'ZAS' => __( 'Zamboanga del Sur', 'lifterlms' ),
	),
	'PK' => array(
		'JK' => __( 'Azad Kashmir', 'lifterlms' ),
		'BA' => __( 'Balochistan', 'lifterlms' ),
		'TA' => __( 'Federally Administered Tribal Areas', 'lifterlms' ),
		'GB' => __( 'Gilgit-Baltistan', 'lifterlms' ),
		'IS' => __( 'Islamabad Capital Territory', 'lifterlms' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'lifterlms' ),
		'PB' => __( 'Punjab', 'lifterlms' ),
		'SD' => __( 'Sindh', 'lifterlms' ),
	),
	'PL' => array(
		'WP' => __( 'Greater Poland Voivodeship', 'lifterlms' ),
		'KP' => __( 'Kuyavian-Pomeranian Voivodeship', 'lifterlms' ),
		'MA' => __( 'Lesser Poland Voivodeship', 'lifterlms' ),
		'DS' => __( 'Lower Silesian Voivodeship', 'lifterlms' ),
		'LU' => __( 'Lublin Voivodeship', 'lifterlms' ),
		'LB' => __( 'Lubusz Voivodeship', 'lifterlms' ),
		'MZ' => __( 'Masovian Voivodeship', 'lifterlms' ),
		'OP' => __( 'Opole Voivodeship', 'lifterlms' ),
		'PK' => __( 'Podkarpackie Voivodeship', 'lifterlms' ),
		'PD' => __( 'Podlaskie Voivodeship', 'lifterlms' ),
		'PM' => __( 'Pomeranian Voivodeship', 'lifterlms' ),
		'SL' => __( 'Silesian Voivodeship', 'lifterlms' ),
		'WN' => __( 'Warmian-Masurian Voivodeship', 'lifterlms' ),
		'ZP' => __( 'West Pomeranian Voivodeship', 'lifterlms' ),
		'LD' => __( 'Łódź Voivodeship', 'lifterlms' ),
		'SK' => __( 'Świętokrzyskie Voivodeship', 'lifterlms' ),
	),
	'PM' => array(),
	'PN' => array(),
	'PR' => array(),
	'PS' => array(),
	'PT' => array(
		'10' => __( 'Leiria', 'lifterlms' ),
		'11' => __( 'Lisbon', 'lifterlms' ),
		'12' => __( 'Portalegre', 'lifterlms' ),
		'13' => __( 'Porto', 'lifterlms' ),
		'14' => __( 'Santarém', 'lifterlms' ),
		'15' => __( 'Setúbal', 'lifterlms' ),
		'16' => __( 'Viana do Castelo', 'lifterlms' ),
		'17' => __( 'Vila Real', 'lifterlms' ),
		'18' => __( 'Viseu', 'lifterlms' ),
		'20' => __( 'Açores', 'lifterlms' ),
		'30' => __( 'Madeira', 'lifterlms' ),
		'01' => __( 'Aveiro', 'lifterlms' ),
		'02' => __( 'Beja', 'lifterlms' ),
		'03' => __( 'Braga', 'lifterlms' ),
		'04' => __( 'Bragança', 'lifterlms' ),
		'05' => __( 'Castelo Branco', 'lifterlms' ),
		'06' => __( 'Coimbra', 'lifterlms' ),
		'08' => __( 'Faro', 'lifterlms' ),
		'09' => __( 'Guarda', 'lifterlms' ),
		'07' => __( 'Évora', 'lifterlms' ),
	),
	'PW' => array(
		'100' => __( 'Kayangel', 'lifterlms' ),
		'150' => __( 'Koror', 'lifterlms' ),
		'212' => __( 'Melekeok', 'lifterlms' ),
		'214' => __( 'Ngaraard', 'lifterlms' ),
		'218' => __( 'Ngarchelong', 'lifterlms' ),
		'222' => __( 'Ngardmau', 'lifterlms' ),
		'224' => __( 'Ngatpang', 'lifterlms' ),
		'226' => __( 'Ngchesar', 'lifterlms' ),
		'227' => __( 'Ngeremlengui', 'lifterlms' ),
		'228' => __( 'Ngiwal', 'lifterlms' ),
		'350' => __( 'Peleliu', 'lifterlms' ),
		'370' => __( 'Sonsorol', 'lifterlms' ),
		'002' => __( 'Aimeliik', 'lifterlms' ),
		'004' => __( 'Airai', 'lifterlms' ),
		'010' => __( 'Angaur', 'lifterlms' ),
		'050' => __( 'Hatohobei', 'lifterlms' ),
	),
	'PY' => array(
		'1'  => __( 'Concepción Department', 'lifterlms' ),
		'2'  => __( 'San Pedro Department', 'lifterlms' ),
		'3'  => __( 'Cordillera Department', 'lifterlms' ),
		'4'  => __( 'Guairá Department', 'lifterlms' ),
		'5'  => __( 'Caaguazú', 'lifterlms' ),
		'6'  => __( 'Caazapá', 'lifterlms' ),
		'7'  => __( 'Itapúa', 'lifterlms' ),
		'8'  => __( 'Misiones Department', 'lifterlms' ),
		'9'  => __( 'Paraguarí Department', 'lifterlms' ),
		'10' => __( 'Alto Paraná Department', 'lifterlms' ),
		'11' => __( 'Central Department', 'lifterlms' ),
		'12' => __( 'Ñeembucú Department', 'lifterlms' ),
		'13' => __( 'Amambay Department', 'lifterlms' ),
		'14' => __( 'Canindeyú', 'lifterlms' ),
		'15' => __( 'Presidente Hayes Department', 'lifterlms' ),
		'16' => __( 'Alto Paraguay Department', 'lifterlms' ),
		'19' => __( 'Boquerón Department', 'lifterlms' ),
	),
	'QA' => array(
		'ZA' => __( 'Al Daayen', 'lifterlms' ),
		'KH' => __( 'Al Khor', 'lifterlms' ),
		'RA' => __( 'Al Rayyan Municipality', 'lifterlms' ),
		'WA' => __( 'Al Wakrah', 'lifterlms' ),
		'SH' => __( 'Al-Shahaniya', 'lifterlms' ),
		'DA' => __( 'Doha', 'lifterlms' ),
		'MS' => __( 'Madinat ash Shamal', 'lifterlms' ),
		'US' => __( 'Umm Salal Municipality', 'lifterlms' ),
	),
	'RE' => array(),
	'RO' => array(
		'AB' => __( 'Alba', 'lifterlms' ),
		'AR' => __( 'Arad County', 'lifterlms' ),
		'AG' => __( 'Arges', 'lifterlms' ),
		'BC' => __( 'Bacău County', 'lifterlms' ),
		'BH' => __( 'Bihor County', 'lifterlms' ),
		'BN' => __( 'Bistrița-Năsăud County', 'lifterlms' ),
		'BT' => __( 'Botoșani County', 'lifterlms' ),
		'BR' => __( 'Braila', 'lifterlms' ),
		'BV' => __( 'Brașov County', 'lifterlms' ),
		'B'  => __( 'Bucharest', 'lifterlms' ),
		'BZ' => __( 'Buzău County', 'lifterlms' ),
		'CS' => __( 'Caraș-Severin County', 'lifterlms' ),
		'CJ' => __( 'Cluj County', 'lifterlms' ),
		'CT' => __( 'Constanța County', 'lifterlms' ),
		'CV' => __( 'Covasna County', 'lifterlms' ),
		'CL' => __( 'Călărași County', 'lifterlms' ),
		'DJ' => __( 'Dolj County', 'lifterlms' ),
		'DB' => __( 'Dâmbovița County', 'lifterlms' ),
		'GL' => __( 'Galați County', 'lifterlms' ),
		'GR' => __( 'Giurgiu County', 'lifterlms' ),
		'GJ' => __( 'Gorj County', 'lifterlms' ),
		'HR' => __( 'Harghita County', 'lifterlms' ),
		'HD' => __( 'Hunedoara County', 'lifterlms' ),
		'IL' => __( 'Ialomița County', 'lifterlms' ),
		'IS' => __( 'Iași County', 'lifterlms' ),
		'IF' => __( 'Ilfov County', 'lifterlms' ),
		'MM' => __( 'Maramureș County', 'lifterlms' ),
		'MH' => __( 'Mehedinți County', 'lifterlms' ),
		'MS' => __( 'Mureș County', 'lifterlms' ),
		'NT' => __( 'Neamț County', 'lifterlms' ),
		'OT' => __( 'Olt County', 'lifterlms' ),
		'PH' => __( 'Prahova County', 'lifterlms' ),
		'SM' => __( 'Satu Mare County', 'lifterlms' ),
		'SB' => __( 'Sibiu County', 'lifterlms' ),
		'SV' => __( 'Suceava County', 'lifterlms' ),
		'SJ' => __( 'Sălaj County', 'lifterlms' ),
		'TR' => __( 'Teleorman County', 'lifterlms' ),
		'TM' => __( 'Timiș County', 'lifterlms' ),
		'TL' => __( 'Tulcea County', 'lifterlms' ),
		'VS' => __( 'Vaslui County', 'lifterlms' ),
		'VN' => __( 'Vrancea County', 'lifterlms' ),
		'VL' => __( 'Vâlcea County', 'lifterlms' ),
	),
	'RS' => array(
		'10' => __( 'Podunavlje District', 'lifterlms' ),
		'11' => __( 'Braničevo District', 'lifterlms' ),
		'12' => __( 'Šumadija District', 'lifterlms' ),
		'13' => __( 'Pomoravlje District', 'lifterlms' ),
		'14' => __( 'Bor District', 'lifterlms' ),
		'15' => __( 'Zaječar District', 'lifterlms' ),
		'16' => __( 'Zlatibor District', 'lifterlms' ),
		'17' => __( 'Moravica District', 'lifterlms' ),
		'18' => __( 'Raška District', 'lifterlms' ),
		'19' => __( 'Rasina District', 'lifterlms' ),
		'20' => __( 'Nišava District', 'lifterlms' ),
		'21' => __( 'Toplica District', 'lifterlms' ),
		'22' => __( 'Pirot District', 'lifterlms' ),
		'23' => __( 'Jablanica District', 'lifterlms' ),
		'24' => __( 'Pčinja District', 'lifterlms' ),
		'00' => __( 'Belgrade', 'lifterlms' ),
		'02' => __( 'Central Banat District', 'lifterlms' ),
		'09' => __( 'Kolubara District', 'lifterlms' ),
		'08' => __( 'Mačva District', 'lifterlms' ),
		'03' => __( 'North Banat District', 'lifterlms' ),
		'01' => __( 'North Bačka District', 'lifterlms' ),
		'04' => __( 'South Banat District', 'lifterlms' ),
		'06' => __( 'South Bačka District', 'lifterlms' ),
		'07' => __( 'Srem District', 'lifterlms' ),
		'VO' => __( 'Vojvodina', 'lifterlms' ),
		'05' => __( 'West Bačka District', 'lifterlms' ),
	),
	'RU' => array(
		'ALT'   => __( 'Altai Krai', 'lifterlms' ),
		'AL'    => __( 'Altai Republic', 'lifterlms' ),
		'AMU'   => __( 'Amur Oblast', 'lifterlms' ),
		'ARK'   => __( 'Arkhangelsk', 'lifterlms' ),
		'AST'   => __( 'Astrakhan Oblast', 'lifterlms' ),
		'BEL'   => __( 'Belgorod Oblast', 'lifterlms' ),
		'BRY'   => __( 'Bryansk Oblast', 'lifterlms' ),
		'CE'    => __( 'Chechen Republic', 'lifterlms' ),
		'CHE'   => __( 'Chelyabinsk Oblast', 'lifterlms' ),
		'CHU'   => __( 'Chukotka Autonomous Okrug', 'lifterlms' ),
		'CU'    => __( 'Chuvash Republic', 'lifterlms' ),
		'IRK'   => __( 'Irkutsk', 'lifterlms' ),
		'IVA'   => __( 'Ivanovo Oblast', 'lifterlms' ),
		'YEV'   => __( 'Jewish Autonomous Oblast', 'lifterlms' ),
		'KB'    => __( 'Kabardino-Balkar Republic', 'lifterlms' ),
		'KGD'   => __( 'Kaliningrad', 'lifterlms' ),
		'KLU'   => __( 'Kaluga Oblast', 'lifterlms' ),
		'KAM'   => __( 'Kamchatka Krai', 'lifterlms' ),
		'KC'    => __( 'Karachay-Cherkess Republic', 'lifterlms' ),
		'KEM'   => __( 'Kemerovo Oblast', 'lifterlms' ),
		'KHA'   => __( 'Khabarovsk Krai', 'lifterlms' ),
		'KHM'   => __( 'Khanty-Mansi Autonomous Okrug', 'lifterlms' ),
		'KIR'   => __( 'Kirov Oblast', 'lifterlms' ),
		'KO'    => __( 'Komi Republic', 'lifterlms' ),
		'KOS'   => __( 'Kostroma Oblast', 'lifterlms' ),
		'KDA'   => __( 'Krasnodar Krai', 'lifterlms' ),
		'KYA'   => __( 'Krasnoyarsk Krai', 'lifterlms' ),
		'KGN'   => __( 'Kurgan Oblast', 'lifterlms' ),
		'KRS'   => __( 'Kursk Oblast', 'lifterlms' ),
		'LEN'   => __( 'Leningrad Oblast', 'lifterlms' ),
		'LIP'   => __( 'Lipetsk Oblast', 'lifterlms' ),
		'MAG'   => __( 'Magadan Oblast', 'lifterlms' ),
		'ME'    => __( 'Mari El Republic', 'lifterlms' ),
		'MOW'   => __( 'Moscow', 'lifterlms' ),
		'MOS'   => __( 'Moscow Oblast', 'lifterlms' ),
		'MUR'   => __( 'Murmansk Oblast', 'lifterlms' ),
		'NEN'   => __( 'Nenets Autonomous Okrug', 'lifterlms' ),
		'NIZ'   => __( 'Nizhny Novgorod Oblast', 'lifterlms' ),
		'NGR'   => __( 'Novgorod Oblast', 'lifterlms' ),
		'NVS'   => __( 'Novosibirsk', 'lifterlms' ),
		'OMS'   => __( 'Omsk Oblast', 'lifterlms' ),
		'ORE'   => __( 'Orenburg Oblast', 'lifterlms' ),
		'ORL'   => __( 'Oryol Oblast', 'lifterlms' ),
		'PNZ'   => __( 'Penza Oblast', 'lifterlms' ),
		'PER'   => __( 'Perm Krai', 'lifterlms' ),
		'PRI'   => __( 'Primorsky Krai', 'lifterlms' ),
		'PSK'   => __( 'Pskov Oblast', 'lifterlms' ),
		'AD'    => __( 'Republic of Adygea', 'lifterlms' ),
		'BA'    => __( 'Republic of Bashkortostan', 'lifterlms' ),
		'BU'    => __( 'Republic of Buryatia', 'lifterlms' ),
		'DA'    => __( 'Republic of Dagestan', 'lifterlms' ),
		'IN'    => __( 'Republic of Ingushetia', 'lifterlms' ),
		'KL'    => __( 'Republic of Kalmykia', 'lifterlms' ),
		'KR'    => __( 'Republic of Karelia', 'lifterlms' ),
		'KK'    => __( 'Republic of Khakassia', 'lifterlms' ),
		'MO'    => __( 'Republic of Mordovia', 'lifterlms' ),
		'SE'    => __( 'Republic of North Ossetia-Alania', 'lifterlms' ),
		'TA'    => __( 'Republic of Tatarstan', 'lifterlms' ),
		'ROS'   => __( 'Rostov Oblast', 'lifterlms' ),
		'RYA'   => __( 'Ryazan Oblast', 'lifterlms' ),
		'SPE'   => __( 'Saint Petersburg', 'lifterlms' ),
		'SA'    => __( 'Sakha Republic', 'lifterlms' ),
		'SAK'   => __( 'Sakhalin', 'lifterlms' ),
		'SAM'   => __( 'Samara Oblast', 'lifterlms' ),
		'SAR'   => __( 'Saratov Oblast', 'lifterlms' ),
		'UA-40' => __( 'Sevastopol', 'lifterlms' ),
		'SMO'   => __( 'Smolensk Oblast', 'lifterlms' ),
		'STA'   => __( 'Stavropol Krai', 'lifterlms' ),
		'SVE'   => __( 'Sverdlovsk', 'lifterlms' ),
		'TAM'   => __( 'Tambov Oblast', 'lifterlms' ),
		'TOM'   => __( 'Tomsk Oblast', 'lifterlms' ),
		'TUL'   => __( 'Tula Oblast', 'lifterlms' ),
		'TY'    => __( 'Tuva Republic', 'lifterlms' ),
		'TVE'   => __( 'Tver Oblast', 'lifterlms' ),
		'TYU'   => __( 'Tyumen Oblast', 'lifterlms' ),
		'UD'    => __( 'Udmurt Republic', 'lifterlms' ),
		'ULY'   => __( 'Ulyanovsk Oblast', 'lifterlms' ),
		'VLA'   => __( 'Vladimir Oblast', 'lifterlms' ),
		'VGG'   => __( 'Volgograd Oblast', 'lifterlms' ),
		'VLG'   => __( 'Vologda Oblast', 'lifterlms' ),
		'VOR'   => __( 'Voronezh Oblast', 'lifterlms' ),
		'YAN'   => __( 'Yamalo-Nenets Autonomous Okrug', 'lifterlms' ),
		'YAR'   => __( 'Yaroslavl Oblast', 'lifterlms' ),
		'ZAB'   => __( 'Zabaykalsky Krai', 'lifterlms' ),
	),
	'RW' => array(
		'02' => __( 'Eastern Province', 'lifterlms' ),
		'01' => __( 'Kigali district', 'lifterlms' ),
		'03' => __( 'Northern Province', 'lifterlms' ),
		'05' => __( 'Southern Province', 'lifterlms' ),
		'04' => __( 'Western Province', 'lifterlms' ),
	),
	'SA' => array(
		'10' => __( 'Najran Region', 'lifterlms' ),
		'11' => __( 'Al Bahah Region', 'lifterlms' ),
		'12' => __( 'Al Jawf Region', 'lifterlms' ),
		'14' => __( '\'Asir Region', 'lifterlms' ),
		'03' => __( 'Al Madinah Region', 'lifterlms' ),
		'05' => __( 'Al-Qassim Region', 'lifterlms' ),
		'04' => __( 'Eastern Province', 'lifterlms' ),
		'06' => __( 'Ha\'il Region', 'lifterlms' ),
		'09' => __( 'Jizan Region', 'lifterlms' ),
		'02' => __( 'Makkah Region', 'lifterlms' ),
		'08' => __( 'Northern Borders Region', 'lifterlms' ),
		'01' => __( 'Riyadh Region', 'lifterlms' ),
		'07' => __( 'Tabuk Region', 'lifterlms' ),
	),
	'SB' => array(
		'CE' => __( 'Central Province', 'lifterlms' ),
		'CH' => __( 'Choiseul Province', 'lifterlms' ),
		'GU' => __( 'Guadalcanal Province', 'lifterlms' ),
		'CT' => __( 'Honiara', 'lifterlms' ),
		'IS' => __( 'Isabel Province', 'lifterlms' ),
		'MK' => __( 'Makira-Ulawa Province', 'lifterlms' ),
		'ML' => __( 'Malaita Province', 'lifterlms' ),
		'RB' => __( 'Rennell and Bellona Province', 'lifterlms' ),
		'TE' => __( 'Temotu Province', 'lifterlms' ),
		'WE' => __( 'Western Province', 'lifterlms' ),
	),
	'SC' => array(
		'10' => __( 'Bel Ombre', 'lifterlms' ),
		'11' => __( 'Cascade', 'lifterlms' ),
		'12' => __( 'Glacis', 'lifterlms' ),
		'13' => __( 'Grand\'Anse Mahé', 'lifterlms' ),
		'14' => __( 'Grand\'Anse Praslin', 'lifterlms' ),
		'15' => __( 'La Digue', 'lifterlms' ),
		'16' => __( 'La Rivière Anglaise', 'lifterlms' ),
		'17' => __( 'Mont Buxton', 'lifterlms' ),
		'18' => __( 'Mont Fleuri', 'lifterlms' ),
		'19' => __( 'Plaisance', 'lifterlms' ),
		'20' => __( 'Pointe La Rue', 'lifterlms' ),
		'21' => __( 'Port Glaud', 'lifterlms' ),
		'22' => __( 'Saint Louis', 'lifterlms' ),
		'23' => __( 'Takamaka', 'lifterlms' ),
		'24' => __( 'Les Mamelles', 'lifterlms' ),
		'25' => __( 'Roche Caiman', 'lifterlms' ),
		'02' => __( 'Anse Boileau', 'lifterlms' ),
		'05' => __( 'Anse Royale', 'lifterlms' ),
		'01' => __( 'Anse-aux-Pins', 'lifterlms' ),
		'04' => __( 'Au Cap', 'lifterlms' ),
		'06' => __( 'Baie Lazare', 'lifterlms' ),
		'07' => __( 'Baie Sainte Anne', 'lifterlms' ),
		'08' => __( 'Beau Vallon', 'lifterlms' ),
		'09' => __( 'Bel Air', 'lifterlms' ),
	),
	'SD' => array(
		'GZ' => __( 'Al Jazirah', 'lifterlms' ),
		'GD' => __( 'Al Qadarif', 'lifterlms' ),
		'NB' => __( 'Blue Nile', 'lifterlms' ),
		'DC' => __( 'Central Darfur', 'lifterlms' ),
		'DE' => __( 'East Darfur', 'lifterlms' ),
		'KA' => __( 'Kassala', 'lifterlms' ),
		'KH' => __( 'Khartoum', 'lifterlms' ),
		'DN' => __( 'North Darfur', 'lifterlms' ),
		'KN' => __( 'North Kordofan', 'lifterlms' ),
		'NO' => __( 'Northern', 'lifterlms' ),
		'RS' => __( 'Red Sea', 'lifterlms' ),
		'NR' => __( 'River Nile', 'lifterlms' ),
		'SI' => __( 'Sennar', 'lifterlms' ),
		'DS' => __( 'South Darfur', 'lifterlms' ),
		'KS' => __( 'South Kordofan', 'lifterlms' ),
		'DW' => __( 'West Darfur', 'lifterlms' ),
		'GK' => __( 'West Kordofan', 'lifterlms' ),
		'NW' => __( 'White Nile', 'lifterlms' ),
	),
	'SE' => array(
		'K'  => __( 'Blekinge', 'lifterlms' ),
		'W'  => __( 'Dalarna County', 'lifterlms' ),
		'I'  => __( 'Gotland County', 'lifterlms' ),
		'X'  => __( 'Gävleborg County', 'lifterlms' ),
		'N'  => __( 'Halland County', 'lifterlms' ),
		'F'  => __( 'Jönköping County', 'lifterlms' ),
		'H'  => __( 'Kalmar County', 'lifterlms' ),
		'G'  => __( 'Kronoberg County', 'lifterlms' ),
		'BD' => __( 'Norrbotten County', 'lifterlms' ),
		'M'  => __( 'Skåne County', 'lifterlms' ),
		'AB' => __( 'Stockholm County', 'lifterlms' ),
		'D'  => __( 'Södermanland County', 'lifterlms' ),
		'C'  => __( 'Uppsala County', 'lifterlms' ),
		'S'  => __( 'Värmland County', 'lifterlms' ),
		'AC' => __( 'Västerbotten County', 'lifterlms' ),
		'Y'  => __( 'Västernorrland County', 'lifterlms' ),
		'U'  => __( 'Västmanland County', 'lifterlms' ),
		'O'  => __( 'Västra Götaland County', 'lifterlms' ),
		'T'  => __( 'Örebro County', 'lifterlms' ),
		'E'  => __( 'Östergötland County', 'lifterlms' ),
	),
	'SG' => array(
		'01' => __( 'Central Singapore Community Development Council', 'lifterlms' ),
		'02' => __( 'North East Community Development Council', 'lifterlms' ),
		'03' => __( 'North West Community Development Council', 'lifterlms' ),
		'04' => __( 'South East Community Development Council', 'lifterlms' ),
		'05' => __( 'South West Community Development Council', 'lifterlms' ),
	),
	'SH' => array(),
	'SI' => array(
		'100' => __( 'Radenci Municipality', 'lifterlms' ),
		'101' => __( 'Radlje ob Dravi Municipality', 'lifterlms' ),
		'102' => __( 'Radovljica Municipality', 'lifterlms' ),
		'103' => __( 'Ravne na Koroškem Municipality', 'lifterlms' ),
		'104' => __( 'Ribnica Municipality', 'lifterlms' ),
		'105' => __( 'Rogašovci Municipality', 'lifterlms' ),
		'106' => __( 'Rogaška Slatina Municipality', 'lifterlms' ),
		'107' => __( 'Rogatec Municipality', 'lifterlms' ),
		'108' => __( 'Ruše Municipality', 'lifterlms' ),
		'109' => __( 'Semič Municipality', 'lifterlms' ),
		'110' => __( 'Sevnica Municipality', 'lifterlms' ),
		'111' => __( 'Sežana Municipality', 'lifterlms' ),
		'112' => __( 'Slovenj Gradec City Municipality', 'lifterlms' ),
		'113' => __( 'Slovenska Bistrica Municipality', 'lifterlms' ),
		'114' => __( 'Slovenske Konjice Municipality', 'lifterlms' ),
		'115' => __( 'Starše Municipality', 'lifterlms' ),
		'116' => __( 'Sveti Jurij ob Ščavnici Municipality', 'lifterlms' ),
		'117' => __( 'Šenčur Municipality', 'lifterlms' ),
		'118' => __( 'Šentilj Municipality', 'lifterlms' ),
		'119' => __( 'Šentjernej Municipality', 'lifterlms' ),
		'120' => __( 'Šentjur Municipality', 'lifterlms' ),
		'121' => __( 'Škocjan Municipality', 'lifterlms' ),
		'122' => __( 'Škofja Loka Municipality', 'lifterlms' ),
		'123' => __( 'Municipality of Škofljica', 'lifterlms' ),
		'124' => __( 'Šmarje pri Jelšah Municipality', 'lifterlms' ),
		'125' => __( 'Šmartno ob Paki Municipality', 'lifterlms' ),
		'126' => __( 'Šoštanj Municipality', 'lifterlms' ),
		'127' => __( 'Štore Municipality', 'lifterlms' ),
		'128' => __( 'Tolmin Municipality', 'lifterlms' ),
		'129' => __( 'Trbovlje Municipality', 'lifterlms' ),
		'130' => __( 'Trebnje Municipality', 'lifterlms' ),
		'131' => __( 'Tržič Municipality', 'lifterlms' ),
		'132' => __( 'Turnišče Municipality', 'lifterlms' ),
		'134' => __( 'Velike Lašče Municipality', 'lifterlms' ),
		'135' => __( 'Videm Municipality', 'lifterlms' ),
		'136' => __( 'Vipava Municipality', 'lifterlms' ),
		'137' => __( 'Vitanje Municipality', 'lifterlms' ),
		'138' => __( 'Vodice Municipality', 'lifterlms' ),
		'139' => __( 'Vojnik Municipality', 'lifterlms' ),
		'140' => __( 'Vrhnika Municipality', 'lifterlms' ),
		'141' => __( 'Vuzenica Municipality', 'lifterlms' ),
		'142' => __( 'Zagorje ob Savi Municipality', 'lifterlms' ),
		'143' => __( 'Zavrč Municipality', 'lifterlms' ),
		'144' => __( 'Zreče Municipality', 'lifterlms' ),
		'146' => __( 'Železniki Municipality', 'lifterlms' ),
		'147' => __( 'Žiri Municipality', 'lifterlms' ),
		'148' => __( 'Benedikt Municipality', 'lifterlms' ),
		'149' => __( 'Bistrica ob Sotli Municipality', 'lifterlms' ),
		'150' => __( 'Bloke Municipality', 'lifterlms' ),
		'151' => __( 'Braslovče Municipality', 'lifterlms' ),
		'152' => __( 'Cankova Municipality', 'lifterlms' ),
		'153' => __( 'Cerkvenjak Municipality', 'lifterlms' ),
		'154' => __( 'Dobje Municipality', 'lifterlms' ),
		'155' => __( 'Dobrna Municipality', 'lifterlms' ),
		'156' => __( 'Dobrovnik Municipality', 'lifterlms' ),
		'157' => __( 'Dolenjske Toplice Municipality', 'lifterlms' ),
		'158' => __( 'Grad Municipality', 'lifterlms' ),
		'159' => __( 'Hajdina Municipality', 'lifterlms' ),
		'160' => __( 'Hoče–Slivnica Municipality', 'lifterlms' ),
		'161' => __( 'Hodoš Municipality', 'lifterlms' ),
		'162' => __( 'Horjul Municipality', 'lifterlms' ),
		'163' => __( 'Jezersko Municipality', 'lifterlms' ),
		'164' => __( 'Komenda Municipality', 'lifterlms' ),
		'165' => __( 'Kostel Municipality', 'lifterlms' ),
		'166' => __( 'Križevci Municipality', 'lifterlms' ),
		'167' => __( 'Lovrenc na Pohorju Municipality', 'lifterlms' ),
		'168' => __( 'Markovci Municipality', 'lifterlms' ),
		'169' => __( 'Miklavž na Dravskem Polju Municipality', 'lifterlms' ),
		'170' => __( 'Mirna Peč Municipality', 'lifterlms' ),
		'171' => __( 'Oplotnica', 'lifterlms' ),
		'172' => __( 'Podlehnik Municipality', 'lifterlms' ),
		'173' => __( 'Polzela Municipality', 'lifterlms' ),
		'174' => __( 'Prebold Municipality', 'lifterlms' ),
		'175' => __( 'Prevalje Municipality', 'lifterlms' ),
		'176' => __( 'Razkrižje Municipality', 'lifterlms' ),
		'177' => __( 'Ribnica na Pohorju Municipality', 'lifterlms' ),
		'178' => __( 'Selnica ob Dravi Municipality', 'lifterlms' ),
		'179' => __( 'Sodražica Municipality', 'lifterlms' ),
		'180' => __( 'Solčava Municipality', 'lifterlms' ),
		'181' => __( 'Sveta Ana Municipality', 'lifterlms' ),
		'182' => __( 'Sveti Andraž v Slovenskih Goricah Municipality', 'lifterlms' ),
		'183' => __( 'Šempeter–Vrtojba Municipality', 'lifterlms' ),
		'184' => __( 'Tabor Municipality', 'lifterlms' ),
		'185' => __( 'Trnovska Vas Municipality', 'lifterlms' ),
		'186' => __( 'Trzin Municipality', 'lifterlms' ),
		'187' => __( 'Velika Polana Municipality', 'lifterlms' ),
		'188' => __( 'Veržej Municipality', 'lifterlms' ),
		'189' => __( 'Vransko Municipality', 'lifterlms' ),
		'190' => __( 'Žalec Municipality', 'lifterlms' ),
		'191' => __( 'Žetale Municipality', 'lifterlms' ),
		'192' => __( 'Žirovnica Municipality', 'lifterlms' ),
		'193' => __( 'Žužemberk Municipality', 'lifterlms' ),
		'194' => __( 'Šmartno pri Litiji Municipality', 'lifterlms' ),
		'195' => __( 'Municipality of Apače', 'lifterlms' ),
		'196' => __( 'Municipality of Cirkulane', 'lifterlms' ),
		'197' => __( 'Kostanjevica na Krki Municipality', 'lifterlms' ),
		'198' => __( 'Makole Municipality', 'lifterlms' ),
		'199' => __( 'Mokronog–Trebelno Municipality', 'lifterlms' ),
		'200' => __( 'Poljčane Municipality', 'lifterlms' ),
		'201' => __( 'Renče–Vogrsko Municipality', 'lifterlms' ),
		'202' => __( 'Središče ob Dravi', 'lifterlms' ),
		'203' => __( 'Straža Municipality', 'lifterlms' ),
		'204' => __( 'Sveta Trojica v Slovenskih Goricah Municipality', 'lifterlms' ),
		'205' => __( 'Sveti Tomaž Municipality', 'lifterlms' ),
		'206' => __( 'Šmarješke Toplice Municipality', 'lifterlms' ),
		'207' => __( 'Gorje Municipality', 'lifterlms' ),
		'208' => __( 'Log–Dragomer Municipality', 'lifterlms' ),
		'209' => __( 'Rečica ob Savinji Municipality', 'lifterlms' ),
		'210' => __( 'Sveti Jurij v Slovenskih Goricah Municipality', 'lifterlms' ),
		'211' => __( 'Šentrupert Municipality', 'lifterlms' ),
		'212' => __( 'Mirna Municipality', 'lifterlms' ),
		'213' => __( 'Ankaran Municipality', 'lifterlms' ),
		'001' => __( 'Ajdovščina Municipality', 'lifterlms' ),
		'002' => __( 'Beltinci Municipality', 'lifterlms' ),
		'003' => __( 'Bled Municipality', 'lifterlms' ),
		'004' => __( 'Bohinj Municipality', 'lifterlms' ),
		'005' => __( 'Borovnica Municipality', 'lifterlms' ),
		'006' => __( 'Bovec Municipality', 'lifterlms' ),
		'007' => __( 'Brda Municipality', 'lifterlms' ),
		'008' => __( 'Brezovica Municipality', 'lifterlms' ),
		'009' => __( 'Brežice Municipality', 'lifterlms' ),
		'012' => __( 'Cerklje na Gorenjskem Municipality', 'lifterlms' ),
		'013' => __( 'Cerknica Municipality', 'lifterlms' ),
		'014' => __( 'Cerkno Municipality', 'lifterlms' ),
		'011' => __( 'City Municipality of Celje', 'lifterlms' ),
		'085' => __( 'City Municipality of Novo Mesto', 'lifterlms' ),
		'018' => __( 'Destrnik Municipality', 'lifterlms' ),
		'019' => __( 'Divača Municipality', 'lifterlms' ),
		'020' => __( 'Dobrepolje Municipality', 'lifterlms' ),
		'021' => __( 'Dobrova–Polhov Gradec Municipality', 'lifterlms' ),
		'022' => __( 'Dol pri Ljubljani Municipality', 'lifterlms' ),
		'023' => __( 'Domžale Municipality', 'lifterlms' ),
		'024' => __( 'Dornava Municipality', 'lifterlms' ),
		'025' => __( 'Dravograd Municipality', 'lifterlms' ),
		'026' => __( 'Duplek Municipality', 'lifterlms' ),
		'027' => __( 'Gorenja Vas–Poljane Municipality', 'lifterlms' ),
		'028' => __( 'Gorišnica Municipality', 'lifterlms' ),
		'029' => __( 'Gornja Radgona Municipality', 'lifterlms' ),
		'030' => __( 'Gornji Grad Municipality', 'lifterlms' ),
		'031' => __( 'Gornji Petrovci Municipality', 'lifterlms' ),
		'032' => __( 'Grosuplje Municipality', 'lifterlms' ),
		'034' => __( 'Hrastnik Municipality', 'lifterlms' ),
		'035' => __( 'Hrpelje–Kozina Municipality', 'lifterlms' ),
		'036' => __( 'Idrija Municipality', 'lifterlms' ),
		'037' => __( 'Ig Municipality', 'lifterlms' ),
		'039' => __( 'Ivančna Gorica Municipality', 'lifterlms' ),
		'040' => __( 'Izola Municipality', 'lifterlms' ),
		'041' => __( 'Jesenice Municipality', 'lifterlms' ),
		'042' => __( 'Juršinci Municipality', 'lifterlms' ),
		'043' => __( 'Kamnik Municipality', 'lifterlms' ),
		'044' => __( 'Kanal ob Soči Municipality', 'lifterlms' ),
		'045' => __( 'Kidričevo Municipality', 'lifterlms' ),
		'046' => __( 'Kobarid Municipality', 'lifterlms' ),
		'047' => __( 'Kobilje Municipality', 'lifterlms' ),
		'049' => __( 'Komen Municipality', 'lifterlms' ),
		'050' => __( 'Koper City Municipality', 'lifterlms' ),
		'051' => __( 'Kozje Municipality', 'lifterlms' ),
		'048' => __( 'Kočevje Municipality', 'lifterlms' ),
		'052' => __( 'Kranj City Municipality', 'lifterlms' ),
		'053' => __( 'Kranjska Gora Municipality', 'lifterlms' ),
		'055' => __( 'Kungota', 'lifterlms' ),
		'056' => __( 'Kuzma Municipality', 'lifterlms' ),
		'057' => __( 'Laško Municipality', 'lifterlms' ),
		'058' => __( 'Lenart Municipality', 'lifterlms' ),
		'059' => __( 'Lendava Municipality', 'lifterlms' ),
		'060' => __( 'Litija Municipality', 'lifterlms' ),
		'061' => __( 'Ljubljana City Municipality', 'lifterlms' ),
		'062' => __( 'Ljubno Municipality', 'lifterlms' ),
		'063' => __( 'Ljutomer Municipality', 'lifterlms' ),
		'064' => __( 'Logatec Municipality', 'lifterlms' ),
		'065' => __( 'Loška Dolina Municipality', 'lifterlms' ),
		'066' => __( 'Loški Potok Municipality', 'lifterlms' ),
		'068' => __( 'Lukovica Municipality', 'lifterlms' ),
		'067' => __( 'Luče Municipality', 'lifterlms' ),
		'069' => __( 'Majšperk Municipality', 'lifterlms' ),
		'070' => __( 'Maribor City Municipality', 'lifterlms' ),
		'071' => __( 'Medvode Municipality', 'lifterlms' ),
		'072' => __( 'Mengeš Municipality', 'lifterlms' ),
		'073' => __( 'Metlika Municipality', 'lifterlms' ),
		'074' => __( 'Mežica Municipality', 'lifterlms' ),
		'075' => __( 'Miren–Kostanjevica Municipality', 'lifterlms' ),
		'076' => __( 'Mislinja Municipality', 'lifterlms' ),
		'078' => __( 'Moravske Toplice Municipality', 'lifterlms' ),
		'077' => __( 'Moravče Municipality', 'lifterlms' ),
		'079' => __( 'Mozirje Municipality', 'lifterlms' ),
		'038' => __( 'Municipality of Ilirska Bistrica', 'lifterlms' ),
		'054' => __( 'Municipality of Krško', 'lifterlms' ),
		'080' => __( 'Murska Sobota City Municipality', 'lifterlms' ),
		'081' => __( 'Muta Municipality', 'lifterlms' ),
		'082' => __( 'Naklo Municipality', 'lifterlms' ),
		'083' => __( 'Nazarje Municipality', 'lifterlms' ),
		'084' => __( 'Nova Gorica City Municipality', 'lifterlms' ),
		'086' => __( 'Odranci Municipality', 'lifterlms' ),
		'087' => __( 'Ormož Municipality', 'lifterlms' ),
		'088' => __( 'Osilnica Municipality', 'lifterlms' ),
		'089' => __( 'Pesnica Municipality', 'lifterlms' ),
		'090' => __( 'Piran Municipality', 'lifterlms' ),
		'091' => __( 'Pivka Municipality', 'lifterlms' ),
		'093' => __( 'Podvelka Municipality', 'lifterlms' ),
		'092' => __( 'Podčetrtek Municipality', 'lifterlms' ),
		'094' => __( 'Postojna Municipality', 'lifterlms' ),
		'095' => __( 'Preddvor Municipality', 'lifterlms' ),
		'096' => __( 'Ptuj City Municipality', 'lifterlms' ),
		'097' => __( 'Puconci Municipality', 'lifterlms' ),
		'099' => __( 'Radeče Municipality', 'lifterlms' ),
		'098' => __( 'Rače–Fram Municipality', 'lifterlms' ),
		'010' => __( 'Tišina Municipality', 'lifterlms' ),
		'015' => __( 'Črenšovci Municipality', 'lifterlms' ),
		'016' => __( 'Črna na Koroškem Municipality', 'lifterlms' ),
		'017' => __( 'Črnomelj Municipality', 'lifterlms' ),
		'033' => __( 'Šalovci Municipality', 'lifterlms' ),
	),
	'SJ' => array(),
	'SK' => array(
		'BC' => __( 'Banská Bystrica Region', 'lifterlms' ),
		'BL' => __( 'Bratislava Region', 'lifterlms' ),
		'KI' => __( 'Košice Region', 'lifterlms' ),
		'NI' => __( 'Nitra Region', 'lifterlms' ),
		'PV' => __( 'Prešov Region', 'lifterlms' ),
		'TC' => __( 'Trenčín Region', 'lifterlms' ),
		'TA' => __( 'Trnava Region', 'lifterlms' ),
		'ZI' => __( 'Žilina Region', 'lifterlms' ),
	),
	'SL' => array(
		'E' => __( 'Eastern Province', 'lifterlms' ),
		'N' => __( 'Northern Province', 'lifterlms' ),
		'S' => __( 'Southern Province', 'lifterlms' ),
		'W' => __( 'Western Area', 'lifterlms' ),
	),
	'SM' => array(
		'01' => __( 'Acquaviva', 'lifterlms' ),
		'06' => __( 'Borgo Maggiore', 'lifterlms' ),
		'02' => __( 'Chiesanuova', 'lifterlms' ),
		'03' => __( 'Domagnano', 'lifterlms' ),
		'04' => __( 'Faetano', 'lifterlms' ),
		'05' => __( 'Fiorentino', 'lifterlms' ),
		'08' => __( 'Montegiardino', 'lifterlms' ),
		'07' => __( 'San Marino', 'lifterlms' ),
		'09' => __( 'Serravalle', 'lifterlms' ),
	),
	'SN' => array(
		'DK' => __( 'Dakar', 'lifterlms' ),
		'DB' => __( 'Diourbel Region', 'lifterlms' ),
		'FK' => __( 'Fatick', 'lifterlms' ),
		'KA' => __( 'Kaffrine', 'lifterlms' ),
		'KL' => __( 'Kaolack', 'lifterlms' ),
		'KD' => __( 'Kolda', 'lifterlms' ),
		'KE' => __( 'Kédougou', 'lifterlms' ),
		'LG' => __( 'Louga', 'lifterlms' ),
		'MT' => __( 'Matam', 'lifterlms' ),
		'SL' => __( 'Saint-Louis', 'lifterlms' ),
		'SE' => __( 'Sédhiou', 'lifterlms' ),
		'TC' => __( 'Tambacounda Region', 'lifterlms' ),
		'TH' => __( 'Thiès Region', 'lifterlms' ),
		'ZG' => __( 'Ziguinchor', 'lifterlms' ),
	),
	'SO' => array(
		'AW' => __( 'Awdal Region', 'lifterlms' ),
		'BK' => __( 'Bakool', 'lifterlms' ),
		'BN' => __( 'Banaadir', 'lifterlms' ),
		'BR' => __( 'Bari', 'lifterlms' ),
		'BY' => __( 'Bay', 'lifterlms' ),
		'GA' => __( 'Galguduud', 'lifterlms' ),
		'GE' => __( 'Gedo', 'lifterlms' ),
		'HI' => __( 'Hiran', 'lifterlms' ),
		'JH' => __( 'Lower Juba', 'lifterlms' ),
		'SH' => __( 'Lower Shebelle', 'lifterlms' ),
		'JD' => __( 'Middle Juba', 'lifterlms' ),
		'SD' => __( 'Middle Shebelle', 'lifterlms' ),
		'MU' => __( 'Mudug', 'lifterlms' ),
		'NU' => __( 'Nugal', 'lifterlms' ),
		'SA' => __( 'Sanaag Region', 'lifterlms' ),
		'TO' => __( 'Togdheer Region', 'lifterlms' ),
	),
	'SR' => array(
		'BR' => __( 'Brokopondo District', 'lifterlms' ),
		'CM' => __( 'Commewijne District', 'lifterlms' ),
		'CR' => __( 'Coronie District', 'lifterlms' ),
		'MA' => __( 'Marowijne District', 'lifterlms' ),
		'NI' => __( 'Nickerie District', 'lifterlms' ),
		'PR' => __( 'Para District', 'lifterlms' ),
		'PM' => __( 'Paramaribo District', 'lifterlms' ),
		'SA' => __( 'Saramacca District', 'lifterlms' ),
		'SI' => __( 'Sipaliwini District', 'lifterlms' ),
		'WA' => __( 'Wanica District', 'lifterlms' ),
	),
	'SS' => array(
		'EC' => __( 'Central Equatoria', 'lifterlms' ),
		'EE' => __( 'Eastern Equatoria', 'lifterlms' ),
		'JG' => __( 'Jonglei State', 'lifterlms' ),
		'LK' => __( 'Lakes', 'lifterlms' ),
		'BN' => __( 'Northern Bahr el Ghazal', 'lifterlms' ),
		'UY' => __( 'Unity', 'lifterlms' ),
		'NU' => __( 'Upper Nile', 'lifterlms' ),
		'WR' => __( 'Warrap', 'lifterlms' ),
		'BW' => __( 'Western Bahr el Ghazal', 'lifterlms' ),
		'EW' => __( 'Western Equatoria', 'lifterlms' ),
	),
	'ST' => array(
		'P' => __( 'Príncipe Province', 'lifterlms' ),
		'S' => __( 'São Tomé Province', 'lifterlms' ),
	),
	'SV' => array(
		'AH' => __( 'Ahuachapán Department', 'lifterlms' ),
		'CA' => __( 'Cabañas Department', 'lifterlms' ),
		'CH' => __( 'Chalatenango Department', 'lifterlms' ),
		'CU' => __( 'Cuscatlán Department', 'lifterlms' ),
		'LI' => __( 'La Libertad Department', 'lifterlms' ),
		'PA' => __( 'La Paz Department', 'lifterlms' ),
		'UN' => __( 'La Unión Department', 'lifterlms' ),
		'MO' => __( 'Morazán Department', 'lifterlms' ),
		'SM' => __( 'San Miguel Department', 'lifterlms' ),
		'SS' => __( 'San Salvador Department', 'lifterlms' ),
		'SV' => __( 'San Vicente Department', 'lifterlms' ),
		'SA' => __( 'Santa Ana Department', 'lifterlms' ),
		'SO' => __( 'Sonsonate Department', 'lifterlms' ),
		'US' => __( 'Usulután Department', 'lifterlms' ),
	),
	'SX' => array(),
	'SY' => array(
		'HA' => __( 'Al-Hasakah Governorate', 'lifterlms' ),
		'RA' => __( 'Al-Raqqah Governorate', 'lifterlms' ),
		'HL' => __( 'Aleppo Governorate', 'lifterlms' ),
		'SU' => __( 'As-Suwayda Governorate', 'lifterlms' ),
		'DI' => __( 'Damascus Governorate', 'lifterlms' ),
		'DR' => __( 'Daraa Governorate', 'lifterlms' ),
		'DY' => __( 'Deir ez-Zor Governorate', 'lifterlms' ),
		'HM' => __( 'Hama Governorate', 'lifterlms' ),
		'HI' => __( 'Homs Governorate', 'lifterlms' ),
		'ID' => __( 'Idlib Governorate', 'lifterlms' ),
		'LA' => __( 'Latakia Governorate', 'lifterlms' ),
		'QU' => __( 'Quneitra Governorate', 'lifterlms' ),
		'RD' => __( 'Rif Dimashq Governorate', 'lifterlms' ),
		'TA' => __( 'Tartus Governorate', 'lifterlms' ),
	),
	'SZ' => array(
		'HH' => __( 'Hhohho District', 'lifterlms' ),
		'LU' => __( 'Lubombo District', 'lifterlms' ),
		'MA' => __( 'Manzini District', 'lifterlms' ),
		'SH' => __( 'Shiselweni District', 'lifterlms' ),
	),
	'TC' => array(),
	'TD' => array(
		'BG' => __( 'Bahr el Gazel', 'lifterlms' ),
		'BA' => __( 'Batha Region', 'lifterlms' ),
		'BO' => __( 'Borkou', 'lifterlms' ),
		'EN' => __( 'Ennedi Region', 'lifterlms' ),
		'EE' => __( 'Ennedi-Est', 'lifterlms' ),
		'EO' => __( 'Ennedi-Ouest', 'lifterlms' ),
		'GR' => __( 'Guéra Region', 'lifterlms' ),
		'HL' => __( 'Hadjer-Lamis', 'lifterlms' ),
		'KA' => __( 'Kanem Region', 'lifterlms' ),
		'LC' => __( 'Lac Region', 'lifterlms' ),
		'LO' => __( 'Logone Occidental Region', 'lifterlms' ),
		'LR' => __( 'Logone Oriental Region', 'lifterlms' ),
		'MA' => __( 'Mandoul Region', 'lifterlms' ),
		'ME' => __( 'Mayo-Kebbi Est Region', 'lifterlms' ),
		'MO' => __( 'Mayo-Kebbi Ouest Region', 'lifterlms' ),
		'MC' => __( 'Moyen-Chari Region', 'lifterlms' ),
		'ND' => __( 'N\'Djamena', 'lifterlms' ),
		'OD' => __( 'Ouaddaï Region', 'lifterlms' ),
		'SA' => __( 'Salamat Region', 'lifterlms' ),
		'SI' => __( 'Sila Region', 'lifterlms' ),
		'TA' => __( 'Tandjilé Region', 'lifterlms' ),
		'TI' => __( 'Tibesti Region', 'lifterlms' ),
		'WF' => __( 'Wadi Fira Region', 'lifterlms' ),
	),
	'TF' => array(),
	'TG' => array(
		'C' => __( 'Centrale Region', 'lifterlms' ),
		'K' => __( 'Kara Region', 'lifterlms' ),
		'M' => __( 'Maritime', 'lifterlms' ),
		'P' => __( 'Plateaux Region', 'lifterlms' ),
		'S' => __( 'Savanes Region', 'lifterlms' ),
	),
	'TH' => array(
		'10' => __( 'Bangkok', 'lifterlms' ),
		'11' => __( 'Samut Prakan', 'lifterlms' ),
		'12' => __( 'Nonthaburi', 'lifterlms' ),
		'13' => __( 'Pathum Thani', 'lifterlms' ),
		'14' => __( 'Phra Nakhon Si Ayutthaya', 'lifterlms' ),
		'15' => __( 'Ang Thong', 'lifterlms' ),
		'16' => __( 'Lopburi', 'lifterlms' ),
		'17' => __( 'Sing Buri', 'lifterlms' ),
		'18' => __( 'Chai Nat', 'lifterlms' ),
		'19' => __( 'Saraburi', 'lifterlms' ),
		'20' => __( 'Chon Buri', 'lifterlms' ),
		'21' => __( 'Rayong', 'lifterlms' ),
		'22' => __( 'Chanthaburi', 'lifterlms' ),
		'23' => __( 'Trat', 'lifterlms' ),
		'24' => __( 'Chachoengsao', 'lifterlms' ),
		'25' => __( 'Prachin Buri', 'lifterlms' ),
		'26' => __( 'Nakhon Nayok', 'lifterlms' ),
		'27' => __( 'Sa Kaeo', 'lifterlms' ),
		'30' => __( 'Nakhon Ratchasima', 'lifterlms' ),
		'31' => __( 'Buri Ram', 'lifterlms' ),
		'32' => __( 'Surin', 'lifterlms' ),
		'33' => __( 'Si Sa Ket', 'lifterlms' ),
		'34' => __( 'Ubon Ratchathani', 'lifterlms' ),
		'35' => __( 'Yasothon', 'lifterlms' ),
		'37' => __( 'Amnat Charoen', 'lifterlms' ),
		'38' => __( 'Bueng Kan', 'lifterlms' ),
		'39' => __( 'Nong Bua Lam Phu', 'lifterlms' ),
		'40' => __( 'Khon Kaen', 'lifterlms' ),
		'41' => __( 'Udon Thani', 'lifterlms' ),
		'42' => __( 'Loei', 'lifterlms' ),
		'43' => __( 'Nong Khai', 'lifterlms' ),
		'44' => __( 'Maha Sarakham', 'lifterlms' ),
		'45' => __( 'Roi Et', 'lifterlms' ),
		'46' => __( 'Kalasin', 'lifterlms' ),
		'47' => __( 'Sakon Nakhon', 'lifterlms' ),
		'48' => __( 'Nakhon Phanom', 'lifterlms' ),
		'49' => __( 'Mukdahan', 'lifterlms' ),
		'50' => __( 'Chiang Mai', 'lifterlms' ),
		'51' => __( 'Lamphun', 'lifterlms' ),
		'52' => __( 'Lampang', 'lifterlms' ),
		'53' => __( 'Uttaradit', 'lifterlms' ),
		'54' => __( 'Phrae', 'lifterlms' ),
		'55' => __( 'Nan', 'lifterlms' ),
		'56' => __( 'Phayao', 'lifterlms' ),
		'57' => __( 'Chiang Rai', 'lifterlms' ),
		'58' => __( 'Mae Hong Son', 'lifterlms' ),
		'60' => __( 'Nakhon Sawan', 'lifterlms' ),
		'61' => __( 'Uthai Thani', 'lifterlms' ),
		'62' => __( 'Kamphaeng Phet', 'lifterlms' ),
		'63' => __( 'Tak', 'lifterlms' ),
		'64' => __( 'Sukhothai', 'lifterlms' ),
		'65' => __( 'Phitsanulok', 'lifterlms' ),
		'66' => __( 'Phichit', 'lifterlms' ),
		'67' => __( 'Phetchabun', 'lifterlms' ),
		'70' => __( 'Ratchaburi', 'lifterlms' ),
		'71' => __( 'Kanchanaburi', 'lifterlms' ),
		'72' => __( 'Suphanburi', 'lifterlms' ),
		'73' => __( 'Nakhon Pathom', 'lifterlms' ),
		'74' => __( 'Samut Sakhon', 'lifterlms' ),
		'75' => __( 'Samut Songkhram', 'lifterlms' ),
		'76' => __( 'Phetchaburi', 'lifterlms' ),
		'77' => __( 'Prachuap Khiri Khan', 'lifterlms' ),
		'80' => __( 'Nakhon Si Thammarat', 'lifterlms' ),
		'81' => __( 'Krabi', 'lifterlms' ),
		'82' => __( 'Phang Nga', 'lifterlms' ),
		'83' => __( 'Phuket', 'lifterlms' ),
		'84' => __( 'Surat Thani', 'lifterlms' ),
		'85' => __( 'Ranong', 'lifterlms' ),
		'86' => __( 'Chumphon', 'lifterlms' ),
		'90' => __( 'Songkhla', 'lifterlms' ),
		'91' => __( 'Satun', 'lifterlms' ),
		'92' => __( 'Trang', 'lifterlms' ),
		'93' => __( 'Phatthalung', 'lifterlms' ),
		'94' => __( 'Pattani', 'lifterlms' ),
		'95' => __( 'Yala', 'lifterlms' ),
		'96' => __( 'Narathiwat', 'lifterlms' ),
		'S'  => __( 'Pattaya', 'lifterlms' ),
	),
	'TJ' => array(
		'GB' => __( 'Gorno-Badakhshan Autonomous Province', 'lifterlms' ),
		'KT' => __( 'Khatlon Province', 'lifterlms' ),
		'SU' => __( 'Sughd Province', 'lifterlms' ),
		'RA' => __( 'districts of Republican Subordination', 'lifterlms' ),
	),
	'TK' => array(),
	'TL' => array(
		'AL' => __( 'Aileu municipality', 'lifterlms' ),
		'AN' => __( 'Ainaro Municipality', 'lifterlms' ),
		'BA' => __( 'Baucau Municipality', 'lifterlms' ),
		'BO' => __( 'Bobonaro Municipality', 'lifterlms' ),
		'CO' => __( 'Cova Lima Municipality', 'lifterlms' ),
		'DI' => __( 'Dili municipality', 'lifterlms' ),
		'ER' => __( 'Ermera District', 'lifterlms' ),
		'LA' => __( 'Lautém Municipality', 'lifterlms' ),
		'LI' => __( 'Liquiçá Municipality', 'lifterlms' ),
		'MT' => __( 'Manatuto District', 'lifterlms' ),
		'MF' => __( 'Manufahi Municipality', 'lifterlms' ),
		'VI' => __( 'Viqueque Municipality', 'lifterlms' ),
	),
	'TM' => array(
		'A' => __( 'Ahal Region', 'lifterlms' ),
		'S' => __( 'Ashgabat', 'lifterlms' ),
		'B' => __( 'Balkan Region', 'lifterlms' ),
		'D' => __( 'Daşoguz Region', 'lifterlms' ),
		'L' => __( 'Lebap Region', 'lifterlms' ),
		'M' => __( 'Mary Region', 'lifterlms' ),
	),
	'TN' => array(
		'11' => __( 'Tunis Governorate', 'lifterlms' ),
		'12' => __( 'Ariana Governorate', 'lifterlms' ),
		'13' => __( 'Ben Arous Governorate', 'lifterlms' ),
		'14' => __( 'Manouba Governorate', 'lifterlms' ),
		'22' => __( 'Zaghouan Governorate', 'lifterlms' ),
		'23' => __( 'Bizerte Governorate', 'lifterlms' ),
		'31' => __( 'Kassrine', 'lifterlms' ),
		'32' => __( 'Jendouba Governorate', 'lifterlms' ),
		'33' => __( 'Kef Governorate', 'lifterlms' ),
		'34' => __( 'Siliana Governorate', 'lifterlms' ),
		'41' => __( 'Kairouan Governorate', 'lifterlms' ),
		'42' => __( 'Kasserine Governorate', 'lifterlms' ),
		'43' => __( 'Sidi Bouzid Governorate', 'lifterlms' ),
		'51' => __( 'Sousse Governorate', 'lifterlms' ),
		'52' => __( 'Monastir Governorate', 'lifterlms' ),
		'53' => __( 'Mahdia Governorate', 'lifterlms' ),
		'61' => __( 'Sfax Governorate', 'lifterlms' ),
		'71' => __( 'Gafsa Governorate', 'lifterlms' ),
		'72' => __( 'Tozeur Governorate', 'lifterlms' ),
		'73' => __( 'Kebili Governorate', 'lifterlms' ),
		'81' => __( 'Gabès Governorate', 'lifterlms' ),
		'82' => __( 'Medenine Governorate', 'lifterlms' ),
		'83' => __( 'Tataouine Governorate', 'lifterlms' ),
	),
	'TO' => array(
		'02' => __( 'Haʻapai', 'lifterlms' ),
		'03' => __( 'Niuas', 'lifterlms' ),
		'04' => __( 'Tongatapu', 'lifterlms' ),
		'05' => __( 'Vavaʻu', 'lifterlms' ),
		'01' => __( 'ʻEua', 'lifterlms' ),
	),
	'TR' => array(
		'10' => __( 'Balıkesir Province', 'lifterlms' ),
		'11' => __( 'Bilecik Province', 'lifterlms' ),
		'12' => __( 'Bingöl Province', 'lifterlms' ),
		'13' => __( 'Bitlis Province', 'lifterlms' ),
		'14' => __( 'Bolu Province', 'lifterlms' ),
		'15' => __( 'Burdur Province', 'lifterlms' ),
		'16' => __( 'Bursa Province', 'lifterlms' ),
		'17' => __( 'Çanakkale Province', 'lifterlms' ),
		'18' => __( 'Çankırı Province', 'lifterlms' ),
		'19' => __( 'Çorum Province', 'lifterlms' ),
		'20' => __( 'Denizli Province', 'lifterlms' ),
		'21' => __( 'Diyarbakır Province', 'lifterlms' ),
		'22' => __( 'Edirne Province', 'lifterlms' ),
		'23' => __( 'Elazığ Province', 'lifterlms' ),
		'24' => __( 'Erzincan Province', 'lifterlms' ),
		'25' => __( 'Erzurum Province', 'lifterlms' ),
		'26' => __( 'Eskişehir Province', 'lifterlms' ),
		'27' => __( 'Gaziantep Province', 'lifterlms' ),
		'28' => __( 'Giresun Province', 'lifterlms' ),
		'29' => __( 'Gümüşhane Province', 'lifterlms' ),
		'30' => __( 'Hakkâri Province', 'lifterlms' ),
		'31' => __( 'Hatay Province', 'lifterlms' ),
		'32' => __( 'Isparta Province', 'lifterlms' ),
		'33' => __( 'Mersin Province', 'lifterlms' ),
		'34' => __( 'Istanbul Province', 'lifterlms' ),
		'35' => __( 'İzmir Province', 'lifterlms' ),
		'36' => __( 'Kars Province', 'lifterlms' ),
		'37' => __( 'Kastamonu Province', 'lifterlms' ),
		'38' => __( 'Kayseri Province', 'lifterlms' ),
		'39' => __( 'Kırklareli Province', 'lifterlms' ),
		'40' => __( 'Kırşehir Province', 'lifterlms' ),
		'41' => __( 'Kocaeli Province', 'lifterlms' ),
		'42' => __( 'Konya Province', 'lifterlms' ),
		'43' => __( 'Kütahya Province', 'lifterlms' ),
		'44' => __( 'Malatya Province', 'lifterlms' ),
		'45' => __( 'Manisa Province', 'lifterlms' ),
		'46' => __( 'Kahramanmaraş Province', 'lifterlms' ),
		'47' => __( 'Mardin Province', 'lifterlms' ),
		'48' => __( 'Muğla Province', 'lifterlms' ),
		'49' => __( 'Muş Province', 'lifterlms' ),
		'50' => __( 'Nevşehir Province', 'lifterlms' ),
		'51' => __( 'Niğde Province', 'lifterlms' ),
		'52' => __( 'Ordu Province', 'lifterlms' ),
		'53' => __( 'Rize Province', 'lifterlms' ),
		'54' => __( 'Sakarya Province', 'lifterlms' ),
		'55' => __( 'Samsun Province', 'lifterlms' ),
		'56' => __( 'Siirt Province', 'lifterlms' ),
		'57' => __( 'Sinop Province', 'lifterlms' ),
		'58' => __( 'Sivas Province', 'lifterlms' ),
		'59' => __( 'Tekirdağ Province', 'lifterlms' ),
		'60' => __( 'Tokat Province', 'lifterlms' ),
		'61' => __( 'Trabzon Province', 'lifterlms' ),
		'62' => __( 'Tunceli Province', 'lifterlms' ),
		'63' => __( 'Şanlıurfa Province', 'lifterlms' ),
		'64' => __( 'Uşak Province', 'lifterlms' ),
		'65' => __( 'Van Province', 'lifterlms' ),
		'66' => __( 'Yozgat Province', 'lifterlms' ),
		'67' => __( 'Zonguldak Province', 'lifterlms' ),
		'68' => __( 'Aksaray Province', 'lifterlms' ),
		'69' => __( 'Bayburt Province', 'lifterlms' ),
		'70' => __( 'Karaman Province', 'lifterlms' ),
		'71' => __( 'Kırıkkale Province', 'lifterlms' ),
		'72' => __( 'Batman Province', 'lifterlms' ),
		'73' => __( 'Şırnak Province', 'lifterlms' ),
		'74' => __( 'Bartın Province', 'lifterlms' ),
		'75' => __( 'Ardahan Province', 'lifterlms' ),
		'76' => __( 'Iğdır Province', 'lifterlms' ),
		'77' => __( 'Yalova Province', 'lifterlms' ),
		'78' => __( 'Karabük Province', 'lifterlms' ),
		'79' => __( 'Kilis Province', 'lifterlms' ),
		'80' => __( 'Osmaniye Province', 'lifterlms' ),
		'81' => __( 'Düzce Province', 'lifterlms' ),
		'01' => __( 'Adana Province', 'lifterlms' ),
		'02' => __( 'Adıyaman Province', 'lifterlms' ),
		'03' => __( 'Afyonkarahisar Province', 'lifterlms' ),
		'05' => __( 'Amasya Province', 'lifterlms' ),
		'06' => __( 'Ankara Province', 'lifterlms' ),
		'07' => __( 'Antalya Province', 'lifterlms' ),
		'08' => __( 'Artvin Province', 'lifterlms' ),
		'09' => __( 'Aydın Province', 'lifterlms' ),
		'04' => __( 'Ağrı Province', 'lifterlms' ),
	),
	'TT' => array(
		'ARI' => __( 'Arima', 'lifterlms' ),
		'CHA' => __( 'Chaguanas', 'lifterlms' ),
		'CTT' => __( 'Couva-Tabaquite-Talparo Regional Corporation', 'lifterlms' ),
		'DMN' => __( 'Diego Martin Regional Corporation', 'lifterlms' ),
		'ETO' => __( 'Eastern Tobago', 'lifterlms' ),
		'PED' => __( 'Penal-Debe Regional Corporation', 'lifterlms' ),
		'PTF' => __( 'Point Fortin', 'lifterlms' ),
		'POS' => __( 'Port of Spain', 'lifterlms' ),
		'PRT' => __( 'Princes Town Regional Corporation', 'lifterlms' ),
		'MRC' => __( 'Rio Claro-Mayaro Regional Corporation', 'lifterlms' ),
		'SFO' => __( 'San Fernando', 'lifterlms' ),
		'SJL' => __( 'San Juan-Laventille Regional Corporation', 'lifterlms' ),
		'SGE' => __( 'Sangre Grande Regional Corporation', 'lifterlms' ),
		'SIP' => __( 'Siparia Regional Corporation', 'lifterlms' ),
		'TUP' => __( 'Tunapuna-Piarco Regional Corporation', 'lifterlms' ),
		'WTO' => __( 'Western Tobago', 'lifterlms' ),
	),
	'TV' => array(
		'FUN' => __( 'Funafuti', 'lifterlms' ),
		'NMG' => __( 'Nanumanga', 'lifterlms' ),
		'NMA' => __( 'Nanumea', 'lifterlms' ),
		'NIT' => __( 'Niutao Island Council', 'lifterlms' ),
		'NUI' => __( 'Nui', 'lifterlms' ),
		'NKF' => __( 'Nukufetau', 'lifterlms' ),
		'NKL' => __( 'Nukulaelae', 'lifterlms' ),
		'VAI' => __( 'Vaitupu', 'lifterlms' ),
	),
	'TW' => array(
		'CHA' => __( 'Changhua County', 'lifterlms' ),
		'CYQ' => __( 'Chiayi City', 'lifterlms' ),
		'CYI' => __( 'Chiayi County', 'lifterlms' ),
		'HSZ' => __( 'Hsinchu', 'lifterlms' ),
		'HSQ' => __( 'Hsinchu County', 'lifterlms' ),
		'HUA' => __( 'Hualien County', 'lifterlms' ),
		'KHH' => __( 'Kaohsiung', 'lifterlms' ),
		'KHQ' => __( 'Kaohsiung County', 'lifterlms' ),
		'KIN' => __( 'Kinmen', 'lifterlms' ),
		'LIE' => __( 'Lienchiang County', 'lifterlms' ),
		'MIA' => __( 'Miaoli County', 'lifterlms' ),
		'NAN' => __( 'Nantou County', 'lifterlms' ),
		'PEN' => __( 'Penghu County', 'lifterlms' ),
		'PIF' => __( 'Pingtung County', 'lifterlms' ),
		'TXG' => __( 'Taichung', 'lifterlms' ),
		'TXQ' => __( 'Taichung County', 'lifterlms' ),
		'TNN' => __( 'Tainan', 'lifterlms' ),
		'TNQ' => __( 'Tainan County', 'lifterlms' ),
		'TPE' => __( 'Taipei', 'lifterlms' ),
		'TTT' => __( 'Taitung County', 'lifterlms' ),
		'TAO' => __( 'Taoyuan City', 'lifterlms' ),
		'ILA' => __( 'Yilan County', 'lifterlms' ),
		'YUN' => __( 'Yunlin County', 'lifterlms' ),
	),
	'TZ' => array(
		'10' => __( 'South Pemba Region', 'lifterlms' ),
		'11' => __( 'Zanzibar Central/South Region', 'lifterlms' ),
		'12' => __( 'Lindi Region', 'lifterlms' ),
		'13' => __( 'Mara Region', 'lifterlms' ),
		'15' => __( 'Zanzibar Urban/West Region', 'lifterlms' ),
		'16' => __( 'Morogoro Region', 'lifterlms' ),
		'17' => __( 'Mtwara Region', 'lifterlms' ),
		'18' => __( 'Mwanza Region', 'lifterlms' ),
		'19' => __( 'Pwani Region', 'lifterlms' ),
		'20' => __( 'Rukwa Region', 'lifterlms' ),
		'21' => __( 'Ruvuma Region', 'lifterlms' ),
		'22' => __( 'Shinyanga Region', 'lifterlms' ),
		'23' => __( 'Singida Region', 'lifterlms' ),
		'24' => __( 'Tabora Region', 'lifterlms' ),
		'25' => __( 'Tanga Region', 'lifterlms' ),
		'26' => __( 'Manyara Region', 'lifterlms' ),
		'27' => __( 'Geita Region', 'lifterlms' ),
		'28' => __( 'Katavi Region', 'lifterlms' ),
		'29' => __( 'Njombe Region', 'lifterlms' ),
		'30' => __( 'Simiyu Region', 'lifterlms' ),
		'01' => __( 'Arusha Region', 'lifterlms' ),
		'02' => __( 'Dar es Salaam Region', 'lifterlms' ),
		'03' => __( 'Dodoma Region', 'lifterlms' ),
		'04' => __( 'Iringa Region', 'lifterlms' ),
		'05' => __( 'Kagera Region', 'lifterlms' ),
		'08' => __( 'Kigoma Region', 'lifterlms' ),
		'09' => __( 'Kilimanjaro Region', 'lifterlms' ),
		'06' => __( 'North Pemba Region', 'lifterlms' ),
		'07' => __( 'Zanzibar North Region', 'lifterlms' ),
	),
	'UA' => array(
		'12' => __( 'Dnipropetrovsk Oblast', 'lifterlms' ),
		'14' => __( 'Donetsk Oblast', 'lifterlms' ),
		'18' => __( 'Zhytomyr Oblast', 'lifterlms' ),
		'21' => __( 'Zakarpattia Oblast', 'lifterlms' ),
		'23' => __( 'Zaporizhzhya Oblast', 'lifterlms' ),
		'26' => __( 'Ivano-Frankivsk Oblast', 'lifterlms' ),
		'30' => __( 'Kiev', 'lifterlms' ),
		'32' => __( 'Kyiv Oblast', 'lifterlms' ),
		'35' => __( 'Kirovohrad Oblast', 'lifterlms' ),
		'43' => __( 'Autonomous Republic of Crimea', 'lifterlms' ),
		'46' => __( 'Lviv Oblast', 'lifterlms' ),
		'48' => __( 'Mykolaiv Oblast', 'lifterlms' ),
		'51' => __( 'Odessa Oblast', 'lifterlms' ),
		'56' => __( 'Rivne Oblast', 'lifterlms' ),
		'59' => __( 'Sumy Oblast', 'lifterlms' ),
		'61' => __( 'Ternopil Oblast', 'lifterlms' ),
		'63' => __( 'Kharkiv Oblast', 'lifterlms' ),
		'65' => __( 'Kherson Oblast', 'lifterlms' ),
		'68' => __( 'Khmelnytsky Oblast', 'lifterlms' ),
		'71' => __( 'Cherkasy Oblast', 'lifterlms' ),
		'74' => __( 'Chernihiv Oblast', 'lifterlms' ),
		'77' => __( 'Chernivtsi Oblast', 'lifterlms' ),
		'09' => __( 'Luhansk Oblast', 'lifterlms' ),
		'05' => __( 'Vinnytsia Oblast', 'lifterlms' ),
		'07' => __( 'Volyn Oblast', 'lifterlms' ),
	),
	'UG' => array(
		'101' => __( 'Kalangala District', 'lifterlms' ),
		'102' => __( 'Kampala District', 'lifterlms' ),
		'103' => __( 'Kiboga District', 'lifterlms' ),
		'104' => __( 'Luwero District', 'lifterlms' ),
		'105' => __( 'Masaka District', 'lifterlms' ),
		'106' => __( 'Mpigi District', 'lifterlms' ),
		'107' => __( 'Mubende District', 'lifterlms' ),
		'108' => __( 'Mukono District', 'lifterlms' ),
		'109' => __( 'Nakasongola District', 'lifterlms' ),
		'110' => __( 'Rakai District', 'lifterlms' ),
		'111' => __( 'Sembabule District', 'lifterlms' ),
		'112' => __( 'Kayunga District', 'lifterlms' ),
		'113' => __( 'Wakiso District', 'lifterlms' ),
		'114' => __( 'Lyantonde District', 'lifterlms' ),
		'115' => __( 'Mityana District', 'lifterlms' ),
		'116' => __( 'Nakaseke District', 'lifterlms' ),
		'117' => __( 'Buikwe District', 'lifterlms' ),
		'118' => __( 'Bukomansimbi District', 'lifterlms' ),
		'119' => __( 'Butambala District', 'lifterlms' ),
		'120' => __( 'Buvuma District', 'lifterlms' ),
		'121' => __( 'Gomba District', 'lifterlms' ),
		'122' => __( 'Kalungu District', 'lifterlms' ),
		'123' => __( 'Kyankwanzi District', 'lifterlms' ),
		'124' => __( 'Lwengo District', 'lifterlms' ),
		'125' => __( 'Kyotera District', 'lifterlms' ),
		'201' => __( 'Bugiri District', 'lifterlms' ),
		'202' => __( 'Busia District', 'lifterlms' ),
		'203' => __( 'Iganga District', 'lifterlms' ),
		'204' => __( 'Jinja District', 'lifterlms' ),
		'205' => __( 'Kamuli District', 'lifterlms' ),
		'206' => __( 'Kapchorwa District', 'lifterlms' ),
		'207' => __( 'Katakwi District', 'lifterlms' ),
		'208' => __( 'Kumi District', 'lifterlms' ),
		'209' => __( 'Mbale District', 'lifterlms' ),
		'210' => __( 'Pallisa District', 'lifterlms' ),
		'211' => __( 'Soroti District', 'lifterlms' ),
		'212' => __( 'Tororo District', 'lifterlms' ),
		'213' => __( 'Kaberamaido District', 'lifterlms' ),
		'214' => __( 'Mayuge District', 'lifterlms' ),
		'215' => __( 'Sironko District', 'lifterlms' ),
		'216' => __( 'Amuria District', 'lifterlms' ),
		'217' => __( 'Budaka District', 'lifterlms' ),
		'218' => __( 'Bududa District', 'lifterlms' ),
		'219' => __( 'Bukedea District', 'lifterlms' ),
		'220' => __( 'Bukwo District', 'lifterlms' ),
		'221' => __( 'Butaleja District', 'lifterlms' ),
		'222' => __( 'Kaliro District', 'lifterlms' ),
		'223' => __( 'Manafwa District', 'lifterlms' ),
		'224' => __( 'Namutumba District', 'lifterlms' ),
		'225' => __( 'Bulambuli District', 'lifterlms' ),
		'226' => __( 'Buyende District', 'lifterlms' ),
		'227' => __( 'Kibuku District', 'lifterlms' ),
		'228' => __( 'Kween District', 'lifterlms' ),
		'229' => __( 'Luuka District', 'lifterlms' ),
		'230' => __( 'Namayingo District', 'lifterlms' ),
		'231' => __( 'Ngora District', 'lifterlms' ),
		'232' => __( 'Serere District', 'lifterlms' ),
		'233' => __( 'Butebo District', 'lifterlms' ),
		'234' => __( 'Namisindwa District', 'lifterlms' ),
		'301' => __( 'Adjumani District', 'lifterlms' ),
		'302' => __( 'Apac District', 'lifterlms' ),
		'303' => __( 'Arua District', 'lifterlms' ),
		'304' => __( 'Gulu District', 'lifterlms' ),
		'305' => __( 'Kitgum District', 'lifterlms' ),
		'306' => __( 'Kotido District', 'lifterlms' ),
		'307' => __( 'Lira District', 'lifterlms' ),
		'308' => __( 'Moroto District', 'lifterlms' ),
		'309' => __( 'Moyo District', 'lifterlms' ),
		'310' => __( 'Nebbi District', 'lifterlms' ),
		'311' => __( 'Nakapiripirit District', 'lifterlms' ),
		'312' => __( 'Pader District', 'lifterlms' ),
		'313' => __( 'Yumbe District', 'lifterlms' ),
		'314' => __( 'Abim District', 'lifterlms' ),
		'315' => __( 'Amolatar District', 'lifterlms' ),
		'316' => __( 'Amuru District', 'lifterlms' ),
		'317' => __( 'Dokolo District', 'lifterlms' ),
		'318' => __( 'Kaabong District', 'lifterlms' ),
		'319' => __( 'Koboko District', 'lifterlms' ),
		'320' => __( 'Maracha District', 'lifterlms' ),
		'321' => __( 'Oyam District', 'lifterlms' ),
		'322' => __( 'Agago District', 'lifterlms' ),
		'323' => __( 'Alebtong District', 'lifterlms' ),
		'324' => __( 'Amudat District', 'lifterlms' ),
		'325' => __( 'Kole District', 'lifterlms' ),
		'326' => __( 'Lamwo District', 'lifterlms' ),
		'327' => __( 'Napak District', 'lifterlms' ),
		'328' => __( 'Nwoya District', 'lifterlms' ),
		'329' => __( 'Otuke District', 'lifterlms' ),
		'330' => __( 'Zombo District', 'lifterlms' ),
		'331' => __( 'Omoro District', 'lifterlms' ),
		'332' => __( 'Pakwach District', 'lifterlms' ),
		'401' => __( 'Bundibugyo District', 'lifterlms' ),
		'402' => __( 'Bushenyi District', 'lifterlms' ),
		'404' => __( 'Kabale District', 'lifterlms' ),
		'405' => __( 'Kabarole District', 'lifterlms' ),
		'406' => __( 'Kasese District', 'lifterlms' ),
		'407' => __( 'Kibaale District', 'lifterlms' ),
		'408' => __( 'Kisoro District', 'lifterlms' ),
		'409' => __( 'Masindi District', 'lifterlms' ),
		'410' => __( 'Mbarara District', 'lifterlms' ),
		'411' => __( 'Ntungamo District', 'lifterlms' ),
		'412' => __( 'Rukungiri District', 'lifterlms' ),
		'413' => __( 'Kamwenge District', 'lifterlms' ),
		'414' => __( 'Kanungu District', 'lifterlms' ),
		'415' => __( 'Kyenjojo District', 'lifterlms' ),
		'416' => __( 'Buliisa District', 'lifterlms' ),
		'417' => __( 'Ibanda District', 'lifterlms' ),
		'418' => __( 'Isingiro District', 'lifterlms' ),
		'419' => __( 'Kiruhura District', 'lifterlms' ),
		'420' => __( 'Buhweju District', 'lifterlms' ),
		'421' => __( 'Kiryandongo District', 'lifterlms' ),
		'422' => __( 'Kyegegwa District', 'lifterlms' ),
		'423' => __( 'Mitooma District', 'lifterlms' ),
		'424' => __( 'Ntoroko District', 'lifterlms' ),
		'425' => __( 'Rubirizi District', 'lifterlms' ),
		'426' => __( 'Sheema District', 'lifterlms' ),
		'427' => __( 'Kagadi District', 'lifterlms' ),
		'428' => __( 'Kakumiro District', 'lifterlms' ),
		'429' => __( 'Rubanda District', 'lifterlms' ),
		'430' => __( 'Bunyangabu District', 'lifterlms' ),
		'431' => __( 'Rukiga District', 'lifterlms' ),
		'C'   => __( 'Central Region', 'lifterlms' ),
		'E'   => __( 'Eastern Region', 'lifterlms' ),
		'N'   => __( 'Northern Region', 'lifterlms' ),
		'W'   => __( 'Western Region', 'lifterlms' ),
	),
	'UM' => array(),
	'US' => array(
		'AL' => __( 'Alabama', 'lifterlms' ),
		'AK' => __( 'Alaska', 'lifterlms' ),
		'AS' => __( 'American Samoa', 'lifterlms' ),
		'AZ' => __( 'Arizona', 'lifterlms' ),
		'AR' => __( 'Arkansas', 'lifterlms' ),
		'CA' => __( 'California', 'lifterlms' ),
		'CO' => __( 'Colorado', 'lifterlms' ),
		'CT' => __( 'Connecticut', 'lifterlms' ),
		'DE' => __( 'Delaware', 'lifterlms' ),
		'DC' => __( 'District of Columbia', 'lifterlms' ),
		'FL' => __( 'Florida', 'lifterlms' ),
		'GA' => __( 'Georgia', 'lifterlms' ),
		'GU' => __( 'Guam', 'lifterlms' ),
		'HI' => __( 'Hawaii', 'lifterlms' ),
		'ID' => __( 'Idaho', 'lifterlms' ),
		'IL' => __( 'Illinois', 'lifterlms' ),
		'IN' => __( 'Indiana', 'lifterlms' ),
		'IA' => __( 'Iowa', 'lifterlms' ),
		'KS' => __( 'Kansas', 'lifterlms' ),
		'KY' => __( 'Kentucky', 'lifterlms' ),
		'LA' => __( 'Louisiana', 'lifterlms' ),
		'ME' => __( 'Maine', 'lifterlms' ),
		'MD' => __( 'Maryland', 'lifterlms' ),
		'MA' => __( 'Massachusetts', 'lifterlms' ),
		'MI' => __( 'Michigan', 'lifterlms' ),
		'MN' => __( 'Minnesota', 'lifterlms' ),
		'MS' => __( 'Mississippi', 'lifterlms' ),
		'MO' => __( 'Missouri', 'lifterlms' ),
		'MT' => __( 'Montana', 'lifterlms' ),
		'NE' => __( 'Nebraska', 'lifterlms' ),
		'NV' => __( 'Nevada', 'lifterlms' ),
		'NH' => __( 'New Hampshire', 'lifterlms' ),
		'NJ' => __( 'New Jersey', 'lifterlms' ),
		'NM' => __( 'New Mexico', 'lifterlms' ),
		'NY' => __( 'New York', 'lifterlms' ),
		'NC' => __( 'North Carolina', 'lifterlms' ),
		'ND' => __( 'North Dakota', 'lifterlms' ),
		'MP' => __( 'Northern Mariana Islands', 'lifterlms' ),
		'OH' => __( 'Ohio', 'lifterlms' ),
		'OK' => __( 'Oklahoma', 'lifterlms' ),
		'OR' => __( 'Oregon', 'lifterlms' ),
		'PA' => __( 'Pennsylvania', 'lifterlms' ),
		'PR' => __( 'Puerto Rico', 'lifterlms' ),
		'RI' => __( 'Rhode Island', 'lifterlms' ),
		'SC' => __( 'South Carolina', 'lifterlms' ),
		'SD' => __( 'South Dakota', 'lifterlms' ),
		'TN' => __( 'Tennessee', 'lifterlms' ),
		'TX' => __( 'Texas', 'lifterlms' ),
		'UM' => __( 'United States Minor Outlying Islands', 'lifterlms' ),
		'VI' => __( 'United States Virgin Islands', 'lifterlms' ),
		'UT' => __( 'Utah', 'lifterlms' ),
		'VT' => __( 'Vermont', 'lifterlms' ),
		'VA' => __( 'Virginia', 'lifterlms' ),
		'WA' => __( 'Washington', 'lifterlms' ),
		'WV' => __( 'West Virginia', 'lifterlms' ),
		'WI' => __( 'Wisconsin', 'lifterlms' ),
		'WY' => __( 'Wyoming', 'lifterlms' ),
	),
	'UY' => array(
		'AR' => __( 'Artigas Department', 'lifterlms' ),
		'CA' => __( 'Canelones Department', 'lifterlms' ),
		'CL' => __( 'Cerro Largo Department', 'lifterlms' ),
		'CO' => __( 'Colonia Department', 'lifterlms' ),
		'DU' => __( 'Durazno Department', 'lifterlms' ),
		'FS' => __( 'Flores Department', 'lifterlms' ),
		'FD' => __( 'Florida Department', 'lifterlms' ),
		'LA' => __( 'Lavalleja Department', 'lifterlms' ),
		'MA' => __( 'Maldonado Department', 'lifterlms' ),
		'MO' => __( 'Montevideo Department', 'lifterlms' ),
		'PA' => __( 'Paysandú Department', 'lifterlms' ),
		'RV' => __( 'Rivera Department', 'lifterlms' ),
		'RO' => __( 'Rocha Department', 'lifterlms' ),
		'RN' => __( 'Río Negro Department', 'lifterlms' ),
		'SA' => __( 'Salto Department', 'lifterlms' ),
		'SJ' => __( 'San José Department', 'lifterlms' ),
		'SO' => __( 'Soriano Department', 'lifterlms' ),
		'TA' => __( 'Tacuarembó Department', 'lifterlms' ),
		'TT' => __( 'Treinta y Tres Department', 'lifterlms' ),
	),
	'UZ' => array(
		'AN' => __( 'Andijan Region', 'lifterlms' ),
		'BU' => __( 'Bukhara Region', 'lifterlms' ),
		'FA' => __( 'Fergana Region', 'lifterlms' ),
		'JI' => __( 'Jizzakh Region', 'lifterlms' ),
		'QR' => __( 'Karakalpakstan', 'lifterlms' ),
		'NG' => __( 'Namangan Region', 'lifterlms' ),
		'NW' => __( 'Navoiy Region', 'lifterlms' ),
		'QA' => __( 'Qashqadaryo Region', 'lifterlms' ),
		'SA' => __( 'Samarqand Region', 'lifterlms' ),
		'SI' => __( 'Sirdaryo Region', 'lifterlms' ),
		'SU' => __( 'Surxondaryo Region', 'lifterlms' ),
		'TK' => __( 'Tashkent', 'lifterlms' ),
		'TO' => __( 'Tashkent Region', 'lifterlms' ),
		'XO' => __( 'Xorazm Region', 'lifterlms' ),
	),
	'VA' => array(),
	'VC' => array(
		'01' => __( 'Charlotte Parish', 'lifterlms' ),
		'06' => __( 'Grenadines Parish', 'lifterlms' ),
		'02' => __( 'Saint Andrew Parish', 'lifterlms' ),
		'03' => __( 'Saint David Parish', 'lifterlms' ),
		'04' => __( 'Saint George Parish', 'lifterlms' ),
		'05' => __( 'Saint Patrick Parish', 'lifterlms' ),
	),
	'VE' => array(
		'Z' => __( 'Amazonas', 'lifterlms' ),
		'B' => __( 'Anzoátegui', 'lifterlms' ),
		'C' => __( 'Apure', 'lifterlms' ),
		'D' => __( 'Aragua', 'lifterlms' ),
		'E' => __( 'Barinas', 'lifterlms' ),
		'F' => __( 'Bolívar', 'lifterlms' ),
		'A' => __( 'Capital District', 'lifterlms' ),
		'G' => __( 'Carabobo', 'lifterlms' ),
		'H' => __( 'Cojedes', 'lifterlms' ),
		'Y' => __( 'Delta Amacuro', 'lifterlms' ),
		'I' => __( 'Falcón', 'lifterlms' ),
		'W' => __( 'Federal Dependencies of Venezuela', 'lifterlms' ),
		'J' => __( 'Guárico', 'lifterlms' ),
		'K' => __( 'Lara', 'lifterlms' ),
		'M' => __( 'Miranda', 'lifterlms' ),
		'N' => __( 'Monagas', 'lifterlms' ),
		'L' => __( 'Mérida', 'lifterlms' ),
		'O' => __( 'Nueva Esparta', 'lifterlms' ),
		'P' => __( 'Portuguesa', 'lifterlms' ),
		'R' => __( 'Sucre', 'lifterlms' ),
		'T' => __( 'Trujillo', 'lifterlms' ),
		'S' => __( 'Táchira', 'lifterlms' ),
		'X' => __( 'Vargas', 'lifterlms' ),
		'U' => __( 'Yaracuy', 'lifterlms' ),
		'V' => __( 'Zulia', 'lifterlms' ),
	),
	'VG' => array(),
	'VI' => array(),
	'VN' => array(
		'13' => __( 'Quảng Ninh', 'lifterlms' ),
		'14' => __( 'Hòa Bình', 'lifterlms' ),
		'15' => __( 'Hà Tây', 'lifterlms' ),
		'18' => __( 'Ninh Bình', 'lifterlms' ),
		'20' => __( 'Thái Bình', 'lifterlms' ),
		'21' => __( 'Thanh Hóa', 'lifterlms' ),
		'22' => __( 'Nghệ An', 'lifterlms' ),
		'23' => __( 'Hà Tĩnh', 'lifterlms' ),
		'24' => __( 'Quảng Bình', 'lifterlms' ),
		'25' => __( 'Quảng Trị', 'lifterlms' ),
		'26' => __( 'Thừa Thiên-Huế', 'lifterlms' ),
		'27' => __( 'Quảng Nam', 'lifterlms' ),
		'28' => __( 'Kon Tum', 'lifterlms' ),
		'29' => __( 'Quảng Ngãi', 'lifterlms' ),
		'30' => __( 'Gia Lai', 'lifterlms' ),
		'31' => __( 'Bình Định', 'lifterlms' ),
		'32' => __( 'Phú Yên', 'lifterlms' ),
		'33' => __( 'Đắk Lắk', 'lifterlms' ),
		'34' => __( 'Khánh Hòa', 'lifterlms' ),
		'35' => __( 'Lâm Đồng', 'lifterlms' ),
		'36' => __( 'Ninh Thuận', 'lifterlms' ),
		'37' => __( 'Tây Ninh', 'lifterlms' ),
		'39' => __( 'Đồng Nai', 'lifterlms' ),
		'40' => __( 'Bình Thuận', 'lifterlms' ),
		'41' => __( 'Long An', 'lifterlms' ),
		'43' => __( 'Bà Rịa-Vũng Tàu', 'lifterlms' ),
		'44' => __( 'An Giang', 'lifterlms' ),
		'45' => __( 'Đồng Tháp', 'lifterlms' ),
		'46' => __( 'Tiền Giang', 'lifterlms' ),
		'47' => __( 'Kiên Giang', 'lifterlms' ),
		'49' => __( 'Vĩnh Long', 'lifterlms' ),
		'50' => __( 'Bến Tre', 'lifterlms' ),
		'51' => __( 'Trà Vinh', 'lifterlms' ),
		'52' => __( 'Sóc Trăng', 'lifterlms' ),
		'53' => __( 'Bắc Kạn', 'lifterlms' ),
		'54' => __( 'Bắc Giang', 'lifterlms' ),
		'55' => __( 'Bạc Liêu', 'lifterlms' ),
		'56' => __( 'Bắc Ninh', 'lifterlms' ),
		'57' => __( 'Bình Dương', 'lifterlms' ),
		'58' => __( 'Bình Phước', 'lifterlms' ),
		'59' => __( 'Cà Mau', 'lifterlms' ),
		'61' => __( 'Hải Dương', 'lifterlms' ),
		'63' => __( 'Hà Nam', 'lifterlms' ),
		'66' => __( 'Hưng Yên', 'lifterlms' ),
		'67' => __( 'Nam Định', 'lifterlms' ),
		'68' => __( 'Phú Thọ', 'lifterlms' ),
		'69' => __( 'Thái Nguyên', 'lifterlms' ),
		'70' => __( 'Vĩnh Phúc', 'lifterlms' ),
		'71' => __( 'Điện Biên', 'lifterlms' ),
		'72' => __( 'Đắk Nông', 'lifterlms' ),
		'73' => __( 'Hậu Giang', 'lifterlms' ),
		'04' => __( 'Cao Bằng', 'lifterlms' ),
		'DN' => __( 'Da Nang', 'lifterlms' ),
		'HP' => __( 'Haiphong', 'lifterlms' ),
		'HN' => __( 'Hanoi', 'lifterlms' ),
		'SG' => __( 'Ho Chi Minh City', 'lifterlms' ),
		'03' => __( 'Hà Giang', 'lifterlms' ),
		'01' => __( 'Lai Châu', 'lifterlms' ),
		'02' => __( 'Lào Cai', 'lifterlms' ),
		'09' => __( 'Lạng Sơn', 'lifterlms' ),
		'05' => __( 'Sơn La', 'lifterlms' ),
		'07' => __( 'Tuyên Quang', 'lifterlms' ),
		'06' => __( 'Yên Bái', 'lifterlms' ),
	),
	'VU' => array(
		'MAP' => __( 'Malampa', 'lifterlms' ),
		'PAM' => __( 'Penama', 'lifterlms' ),
		'SAM' => __( 'Sanma', 'lifterlms' ),
		'SEE' => __( 'Shefa', 'lifterlms' ),
		'TAE' => __( 'Tafea', 'lifterlms' ),
		'TOB' => __( 'Torba', 'lifterlms' ),
	),
	'WF' => array(),
	'WS' => array(
		'AA' => __( 'A\'ana', 'lifterlms' ),
		'AL' => __( 'Aiga-i-le-Tai', 'lifterlms' ),
		'AT' => __( 'Atua', 'lifterlms' ),
		'FA' => __( 'Fa\'asaleleaga', 'lifterlms' ),
		'GE' => __( 'Gaga\'emauga', 'lifterlms' ),
		'GI' => __( 'Gaga\'ifomauga', 'lifterlms' ),
		'PA' => __( 'Palauli', 'lifterlms' ),
		'SA' => __( 'Satupa\'itea', 'lifterlms' ),
		'TU' => __( 'Tuamasaga', 'lifterlms' ),
		'VF' => __( 'Va\'a-o-Fonoti', 'lifterlms' ),
		'VS' => __( 'Vaisigano', 'lifterlms' ),
	),
	'XK' => array(
		'XGJ' => __( 'Gjilan District', 'lifterlms' ),
		'XKM' => __( 'Kosovska Mitrovica District', 'lifterlms' ),
		'XPE' => __( 'Peć District', 'lifterlms' ),
		'XPI' => __( 'Pristina (Priştine)', 'lifterlms' ),
		'XPR' => __( 'Prizren District', 'lifterlms' ),
		'XUF' => __( 'Uroševac District (Ferizaj)', 'lifterlms' ),
		'XDG' => __( 'Đakovica District (Gjakove)', 'lifterlms' ),
	),
	'YE' => array(
		'AD' => __( '\'Adan Governorate', 'lifterlms' ),
		'AM' => __( '\'Amran Governorate', 'lifterlms' ),
		'AB' => __( 'Abyan Governorate', 'lifterlms' ),
		'BA' => __( 'Al Bayda\' Governorate', 'lifterlms' ),
		'HU' => __( 'Al Hudaydah Governorate', 'lifterlms' ),
		'JA' => __( 'Al Jawf Governorate', 'lifterlms' ),
		'MR' => __( 'Al Mahrah Governorate', 'lifterlms' ),
		'MW' => __( 'Al Mahwit Governorate', 'lifterlms' ),
		'DH' => __( 'Dhamar Governorate', 'lifterlms' ),
		'HD' => __( 'Hadhramaut Governorate', 'lifterlms' ),
		'HJ' => __( 'Hajjah Governorate', 'lifterlms' ),
		'IB' => __( 'Ibb Governorate', 'lifterlms' ),
		'LA' => __( 'Lahij Governorate', 'lifterlms' ),
		'MA' => __( 'Ma\'rib Governorate', 'lifterlms' ),
		'RA' => __( 'Raymah Governorate', 'lifterlms' ),
		'SD' => __( 'Saada Governorate', 'lifterlms' ),
		'SA' => __( 'Sana\'a', 'lifterlms' ),
		'SN' => __( 'Sana\'a Governorate', 'lifterlms' ),
		'SH' => __( 'Shabwah Governorate', 'lifterlms' ),
		'SU' => __( 'Socotra Governorate', 'lifterlms' ),
		'TA' => __( 'Ta\'izz Governorate', 'lifterlms' ),
	),
	'YT' => array(),
	'ZA' => array(
		'EC'  => __( 'Eastern Cape', 'lifterlms' ),
		'FS'  => __( 'Free State', 'lifterlms' ),
		'GP'  => __( 'Gauteng', 'lifterlms' ),
		'KZN' => __( 'KwaZulu-Natal', 'lifterlms' ),
		'LP'  => __( 'Limpopo', 'lifterlms' ),
		'MP'  => __( 'Mpumalanga', 'lifterlms' ),
		'NW'  => __( 'North West', 'lifterlms' ),
		'NC'  => __( 'Northern Cape', 'lifterlms' ),
		'WC'  => __( 'Western Cape', 'lifterlms' ),
	),
	'ZM' => array(
		'10' => __( 'Muchinga Province', 'lifterlms' ),
		'02' => __( 'Central Province', 'lifterlms' ),
		'08' => __( 'Copperbelt Province', 'lifterlms' ),
		'03' => __( 'Eastern Province', 'lifterlms' ),
		'04' => __( 'Luapula Province', 'lifterlms' ),
		'09' => __( 'Lusaka Province', 'lifterlms' ),
		'05' => __( 'Northern Province', 'lifterlms' ),
		'06' => __( 'Northwestern Province', 'lifterlms' ),
		'07' => __( 'Southern Province', 'lifterlms' ),
		'01' => __( 'Western Province', 'lifterlms' ),
	),
	'ZW' => array(
		'BU' => __( 'Bulawayo Province', 'lifterlms' ),
		'HA' => __( 'Harare Province', 'lifterlms' ),
		'MA' => __( 'Manicaland', 'lifterlms' ),
		'MC' => __( 'Mashonaland Central Province', 'lifterlms' ),
		'ME' => __( 'Mashonaland East Province', 'lifterlms' ),
		'MW' => __( 'Mashonaland West Province', 'lifterlms' ),
		'MV' => __( 'Masvingo Province', 'lifterlms' ),
		'MN' => __( 'Matabeleland North Province', 'lifterlms' ),
		'MS' => __( 'Matabeleland South Province', 'lifterlms' ),
		'MI' => __( 'Midlands Province', 'lifterlms' ),
	),
);
