<?php
/**
 * Countries Address Info
 *
 * Returns a map of countries and localization information related to address formatting.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * The data contained within this file is derived from various open-source *
 * projects and libraries.                                                 *
 *                                                                         *
 * See the README.md file in this directory for credits and more.          *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * Note to contributors:                                                   *
 *                                                                         *
 * The data contained within this file is automatically generated. Do not  *
 * modify or submit pull requests on this file directly. If you've located *
 * an issue with any of the data contained within this file please open a  *
 * new issue at https://github.com/gocodebox/lifterlms/issues/new/choose.  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * @package LifterLMS/i18n
 *
 * @see llms_get_countries_address_info()
 *
 * @since 5.0.0
 * @version 5.0.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AE' => array(
		'city'     => false,
		'state'    => __( 'Emirate', 'lifterlms' ),
		'postcode' => false,
	),
	'AF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'AI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'AM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'AQ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'AT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AU' => array(
		'city'     => __( 'City / Suburb', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postcode', 'lifterlms' ),
	),
	'AW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AX' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'AZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BB' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'BD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'BJ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'BL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'BQ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal Code', 'lifterlms' ),
	),
	'BR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Island', 'lifterlms' ),
		'postcode' => false,
	),
	'BT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BV' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'BY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'BZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => false,
	),
	'CA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'CG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'CH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'CN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'CR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CV' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Island', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CX' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'CZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'DE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'DJ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'DK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'DM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'DO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'DZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'EC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'EE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'EG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Governorate', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'EH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ER' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'ES' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ET' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'FI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'FJ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => false,
	),
	'FK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'FM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'FO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'FR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GB' => array(
		'city'     => __( 'Town / City', 'lifterlms' ),
		'state'    => __( 'County', 'lifterlms' ),
		'postcode' => __( 'Postcode', 'lifterlms' ),
	),
	'GD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'GE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'GI' => array(
		'city'     => false,
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'GN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GP' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GQ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'GR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'GW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'GY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'HK' => array(
		'city'     => __( 'District', 'lifterlms' ),
		'state'    => __( 'Area', 'lifterlms' ),
		'postcode' => false,
	),
	'HM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'HN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'HR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'HT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'HU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ID' => array(
		'city'     => __( 'City / Regency', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IE' => array(
		'city'     => __( 'Town / City', 'lifterlms' ),
		'state'    => __( 'County', 'lifterlms' ),
		'postcode' => false,
	),
	'IL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'PIN code', 'lifterlms' ),
	),
	'IO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IQ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'IT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'JE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'JM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Parish', 'lifterlms' ),
		'postcode' => false,
	),
	'JO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'JP' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Prefecture', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Island', 'lifterlms' ),
		'postcode' => false,
	),
	'KM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'KN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Island', 'lifterlms' ),
		'postcode' => false,
	),
	'KP' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'KR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KY' => array(
		'city'     => false,
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'KZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LB' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'LI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LV' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'LY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'MA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ME' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'MK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ML' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'MM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MP' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'MQ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'MS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MV' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MX' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'MZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'NC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Department', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NP' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NR' => array(
		'city'     => false,
		'state'    => __( 'District', 'lifterlms' ),
		'postcode' => false,
	),
	'NU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'NZ' => array(
		'city'     => __( 'Town / City', 'lifterlms' ),
		'state'    => __( 'Region', 'lifterlms' ),
		'postcode' => __( 'Postcode', 'lifterlms' ),
	),
	'OM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => false,
	),
	'PE' => array(
		'city'     => __( 'District', 'lifterlms' ),
		'state'    => __( 'Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'PS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'PW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'PY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'QA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'RE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'RO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'RS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'RU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'RW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'SA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SB' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'SC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Island', 'lifterlms' ),
		'postcode' => false,
	),
	'SD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SG' => array(
		'city'     => false,
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SJ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'SM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => false,
	),
	'SS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal Code', 'lifterlms' ),
	),
	'ST' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'SV' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SX' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal Code', 'lifterlms' ),
	),
	'SY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'SZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TD' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'TF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'TH' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TJ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TL' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'TM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TO' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'TR' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'TV' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Island', 'lifterlms' ),
		'postcode' => false,
	),
	'TW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'TZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'UA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'UG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'UM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'US' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'ZIP code', 'lifterlms' ),
	),
	'UY' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'UZ' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'VA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'VC' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'VE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'VG' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'VI' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'VN' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'VU' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'WF' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'WS' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
	'XK' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal Code', 'lifterlms' ),
	),
	'YE' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'YT' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => false,
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ZA' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'Province', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ZM' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => __( 'Postal code', 'lifterlms' ),
	),
	'ZW' => array(
		'city'     => __( 'City', 'lifterlms' ),
		'state'    => __( 'State / Region', 'lifterlms' ),
		'postcode' => false,
	),
);
