from functools import partial


def calc_decay(n0, t, t_half):
    return n0 * 2 ** (t/t_half)

# период полураспада в годах
isotopes_half_lifes = {
    "C": 5730,
    "Cd": 9*10**15,
    "H": 12.3,
    "Np": 2.1 * 10**6
}

isotopes_decay_fucns = dict()

for isotope in isotopes_half_lifes.keys():
    isotopes_half_life = isotopes_half_lifes[isotope]
    decay_func = partial(calc_decay, t_half=isotopes_half_life)
    isotopes_decay_fucns[isotope] = decay_func

t = 100
n0 = 1e10
for isotope in isotopes_decay_fucns.keys():
    print(f"Через {t} лет останется {isotopes_decay_fucns[isotope](n0=n0, t=t)} ядер {isotope}")
