"""
Простой калькулятор, позволяет ввести 2 числа и операцию и вычисляет результат.
Выводит логи при вызове функции и возврате значения функции.
"""
import logging as log

log.basicConfig(level=log.INFO)

def log_wrapper(func):
    def wrapper(*args, **kwargs):
        log.info(f"Called {func.__name__} with args {args} and kwargs {kwargs}")
        result = func(*args, **kwargs)
        log.info(f"{func.__name__} returned {result}")
        return result
    return wrapper

@log_wrapper
def calculate(x, y, op):
    """
    Считает x op y, где x и y - числа любого типа, а op - строка 
    """
    if (op == "+"):
        return x + y
    elif (op == "-"):
        return x - y
    elif (op == "*"):
        return x * y
    elif (op == "/"):
        return x / y
    else:
        return None


print(calculate("9", "+", "10"))
